/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.InvalidMachineAttributeException;

public class Machine {
    private String name = "";
    private boolean empty = true;

    private Machine(String name, boolean empty) {
        this.name = name.replaceAll(" ", "");
        this.empty = empty;
    }

    public static Machine makeEmpty() {
        return new Machine("", true);
    }

    public static Machine make(String s) throws InvalidMachineAttributeException {
        if (s == null || s.equals("")) {
            throw new InvalidMachineAttributeException(s);
        }
        return new Machine(s, false);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getValue() {
        return this.name;
    }

    public String toString() {
        if (this.empty) {
            return "Empty Machine";
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Machine)) {
            return false;
        }
        Machine mo = (Machine)o;
        if (mo.empty && this.empty) {
            return true;
        }
        return !mo.empty && !this.empty && mo.getValue().equals(this.name);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        return 37 * hash + this.name.hashCode();
    }
}

