/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check.sanity.filesystem;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckResponse;
import it.grid.storm.check.CheckStatus;
import it.grid.storm.check.GenericCheckException;
import it.grid.storm.check.sanity.filesystem.SupportedFSType;
import it.grid.storm.filesystem.MtabRow;
import it.grid.storm.filesystem.MtabUtil;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceFSExtendedAttributeDeclarationCheck
implements Check {
    private static final Logger log = LoggerFactory.getLogger(NamespaceFSExtendedAttributeDeclarationCheck.class);
    private static final String POSIX_EXTENDED_ATTRIBUTES_OPTION_NAME = "user_xattr";
    private static final String CHECK_NAME = "NamespaceFSEAValidation";
    private static final String CHECK_DESCRIPTION = "This check verifies that all the file systems declared in namespace.xml are mounted at boot time with the mount 'extended attribute abilitation' option ";
    private static final boolean criticalCheck = false;

    @Override
    public CheckResponse execute() throws GenericCheckException {
        List<MtabRow> rows;
        CheckStatus status = CheckStatus.SUCCESS;
        String errorMessage = "";
        try {
            rows = MtabUtil.getRows();
        }
        catch (IOException e) {
            log.warn("Unable to get the rows from mtab. IOException : " + e.getMessage());
            return new CheckResponse(CheckStatus.INDETERMINATE, "Check not performed. Unable to get the rows from mtab. IOException : " + e.getMessage());
        }
        log.debug("Retrieved Mtab : " + rows.toString());
        try {
            for (VirtualFSInterface vfs : NamespaceDirector.getNamespace().getAllDefinedVFS()) {
                String fsTypeName = vfs.getFSType();
                String fsRootPath = vfs.getRootPath();
                if (fsTypeName == null || fsRootPath == null) {
                    log.warn("Skipping chek on VFS with alias '" + vfs.getAliasName() + "' has null type ->" + vfs.getFSType() + "<- or root path ->" + vfs.getRootPath() + "<-");
                    continue;
                }
                log.debug("Checking fs at " + fsRootPath + " with type " + fsTypeName);
                boolean found = false;
                for (MtabRow row : rows) {
                    CheckStatus retrievedStatus;
                    SupportedFSType fsType;
                    if (!fsRootPath.startsWith(row.getMountPoint())) continue;
                    log.debug("Found on mountPoint " + row.getMountPoint());
                    found = true;
                    try {
                        fsType = SupportedFSType.parseFS(fsTypeName);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Unable to get the SupportedFSType for file system '" + fsTypeName + "' IllegalArgumentException : " + e.getMessage());
                        throw new GenericCheckException("Unable to get the SupportedFSType for file system '" + fsTypeName + "' IllegalArgumentException : " + e.getMessage());
                    }
                    switch (fsType) {
                        case EXT3: {
                            retrievedStatus = this.checkEXT3(row.getMountOptions());
                            break;
                        }
                        case GPFS: {
                            retrievedStatus = this.checkGPFS(row.getMountOptions());
                            break;
                        }
                        default: {
                            log.error("Unable to switch on the provided SupportedFSType (unknown) : " + (Object)((Object)fsType));
                            throw new GenericCheckException("Unable to switch on the provided SupportedFSType (unknown) : " + (Object)((Object)fsType));
                        }
                    }
                    if (!retrievedStatus.equals((Object)CheckStatus.SUCCESS)) {
                        log.error("Check failed for file system at " + fsRootPath + " with type " + (Object)((Object)fsType));
                        errorMessage = errorMessage + "Check failed for file system at " + fsRootPath + " with type " + (Object)((Object)fsType) + "; ";
                    }
                    status = CheckStatus.and(status, retrievedStatus);
                    break;
                }
                if (found) continue;
                log.error("No file systems are mounted at path " + fsRootPath + "!");
                errorMessage = errorMessage + "No file systems are mounted at path " + fsRootPath + "; ";
                status = CheckStatus.INDETERMINATE;
            }
        }
        catch (NamespaceException e) {
            log.warn("Unable to proceede received a NamespaceException : " + e.getMessage());
            errorMessage = errorMessage + "Unable to proceede received a NamespaceException : " + e.getMessage() + "; ";
            status = CheckStatus.INDETERMINATE;
        }
        return new CheckResponse(status, errorMessage);
    }

    private CheckStatus checkEXT3(List<String> fsOptions) {
        log.debug("Checking ext3 file system estended attribute options against '" + fsOptions.toString() + "'");
        CheckStatus response = CheckStatus.FAILURE;
        if (fsOptions.contains(POSIX_EXTENDED_ATTRIBUTES_OPTION_NAME)) {
            log.debug("Options for ext3 correctly set");
            response = CheckStatus.SUCCESS;
        }
        return response;
    }

    private CheckStatus checkGPFS(List<String> fsOptions) {
        log.debug("Checking gpfs file system estended attribute options against '" + fsOptions.toString() + "'");
        CheckStatus response = CheckStatus.SUCCESS;
        return response;
    }

    @Override
    public String getName() {
        return CHECK_NAME;
    }

    @Override
    public String getDescription() {
        return CHECK_DESCRIPTION;
    }

    @Override
    public boolean isCritical() {
        return false;
    }
}

