/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check.sanity.filesystem;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckResponse;
import it.grid.storm.check.CheckStatus;
import it.grid.storm.check.GenericCheckException;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.naming.NamespaceUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceFSAssociationCheck
implements Check {
    private static final Logger log = LoggerFactory.getLogger(NamespaceFSAssociationCheck.class);
    private static final String CHECK_NAME = "NamespaceFSvalidation";
    private static final String CHECK_DESCRIPTION = "This check verifies that the file system type declared in namespace.xml and phisical filesystem type matches";
    private static final boolean criticalCheck = true;
    private static final String POSIX_FILESYSTEM_TYPE = "ext3";
    private Map<String, String> mountPoints;
    private Collection<VirtualFSInterface> vfsSet;

    private NamespaceFSAssociationCheck() {
    }

    public NamespaceFSAssociationCheck(Map<String, String> mountPoints, Collection<VirtualFSInterface> vfsSet) throws IllegalArgumentException {
        this();
        if (mountPoints == null || vfsSet == null) {
            log.error("Unable to create NamespaceFSAssociationCheck received null arguments: mountPoints=" + mountPoints + " vfsSet=" + vfsSet);
            throw new IllegalArgumentException("Unable to create NamespaceFSAssociationCheck received null arguments");
        }
        if (!this.verifyMountPoints(mountPoints)) {
            log.error("Unable to create NamespaceFSAssociationCheck received invalid mountPoints");
            throw new IllegalArgumentException("Unable to create NamespaceFSAssociationCheck received invalid mountPoints");
        }
        if (!this.verifyVfsSet(vfsSet)) {
            log.error("Unable to create NamespaceFSAssociationCheck received invalid vfsSet");
            throw new IllegalArgumentException("Unable to create NamespaceFSAssociationCheck received invalid vfsSet");
        }
        this.mountPoints = mountPoints;
        this.vfsSet = vfsSet;
    }

    private boolean verifyVfsSet(Collection<VirtualFSInterface> vfsSet) {
        for (VirtualFSInterface vfs : vfsSet) {
            if (vfs == null) {
                log.info("The vfsSet contains null entries");
                return false;
            }
            try {
                if (vfs.getFSType() == null) {
                    log.info("The vfs " + vfs.getAliasName() + " has null FSType");
                    return false;
                }
            }
            catch (NamespaceException e) {
                log.info("Unable to get FSType from vfs " + vfs);
                return false;
            }
            try {
                if (vfs.getRootPath() != null) continue;
                log.info("The vfs " + vfs.getAliasName() + " has null rootPath");
                return false;
            }
            catch (NamespaceException e) {
                log.info("Unable to get rootPath from vfs " + vfs);
                return false;
            }
        }
        log.debug("verifyVfsSet: vfsSet is valid");
        return true;
    }

    private boolean verifyMountPoints(Map<String, String> mountPoints) {
        for (String key : mountPoints.keySet()) {
            if (key == null) {
                log.info("The mountPoints map contains null keys");
                return false;
            }
            if (mountPoints.get(key) != null) continue;
            log.info("The mountPoint key " + key + " points to a null value");
            return false;
        }
        log.debug("verifyMountPoints: mountPoints is valid");
        return true;
    }

    @Override
    public CheckResponse execute() throws GenericCheckException {
        CheckStatus status = CheckStatus.SUCCESS;
        String errorMessage = "";
        try {
            for (VirtualFSInterface vfs : this.vfsSet) {
                boolean currentResponse = this.verifyPosixDeclaredFS(vfs.getFSType());
                if (!currentResponse) {
                    currentResponse = this.check(vfs.getRootPath(), vfs.getFSType(), this.mountPoints);
                }
                if (!currentResponse) {
                    log.error("Check on VFS " + vfs.getAliasName() + " failed. Type =" + vfs.getFSType() + " , root path =" + vfs.getRootPath());
                    errorMessage = errorMessage + "Check on VFS " + vfs.getAliasName() + " failed. Type =" + vfs.getFSType() + " , root path =" + vfs.getRootPath();
                }
                log.debug("Check response for path " + vfs.getRootPath() + " is " + (currentResponse ? "success" : "failure"));
                status = CheckStatus.and(status, currentResponse);
                log.debug("Partial result is " + status.toString());
            }
        }
        catch (NamespaceException e) {
            log.warn("Unexpected NamespaceException, unable to proceede : " + e.getMessage());
            errorMessage = errorMessage + "Unable to proceede received a NamespaceException : " + e.getMessage() + "; ";
            status = CheckStatus.INDETERMINATE;
        }
        return new CheckResponse(status, errorMessage);
    }

    private boolean verifyPosixDeclaredFS(String FSType) throws IllegalArgumentException {
        if (FSType == null) {
            log.error("Unable to check posix filesystem declaration received null argument: FSType= " + FSType);
            throw new IllegalArgumentException("Unable to check posix filesystem declaration received null argument");
        }
        return POSIX_FILESYSTEM_TYPE.equals(FSType.trim());
    }

    private boolean check(String fsRootPath, String fsType, Map<String, String> mountPoints) {
        String canonicalpath;
        boolean response = false;
        log.debug("Checking fs at " + fsRootPath + " as a " + fsType);
        try {
            canonicalpath = new File(fsRootPath).getCanonicalPath();
        }
        catch (IOException e) {
            log.error("unable to build the canonical path for root '" + fsRootPath + "' . IOException : " + e.getMessage());
            return false;
        }
        String mountPointFSType = this.getMountPointFSTypeBestmatch(canonicalpath, mountPoints);
        if (mountPointFSType != null) {
            log.debug("Found on a mountPoint of a '" + mountPointFSType + "' FS");
            if (fsType.equals(mountPointFSType)) {
                response = true;
            } else {
                log.warn("Mount point File System type " + mountPointFSType + " differs from the declared " + fsType + ". Check failed");
            }
        } else {
            log.warn("No file systems are mounted at path " + fsRootPath + "! Check failed");
        }
        return response;
    }

    private String getMountPointFSTypeBestmatch(String fsRootPath, Map<String, String> mountPoints) {
        log.debug("Retrieving mout point for path " + fsRootPath);
        String fsType = null;
        int minDistance = -1;
        int pathSize = this.conputePathSize(fsRootPath);
        for (String mountPoint : mountPoints.keySet()) {
            int distance;
            if (this.conputePathSize(mountPoint) > pathSize || (distance = NamespaceUtil.computeDistanceFromPath(fsRootPath, mountPoint)) < 0 || distance > pathSize || fsType != null && distance >= minDistance) continue;
            minDistance = distance;
            fsType = mountPoints.get(mountPoint).trim();
        }
        return fsType;
    }

    private int conputePathSize(String fsRootPath) {
        String[] elements = fsRootPath.split("/");
        int counter = 0;
        for (String element : elements) {
            if (element.trim().length() <= 0) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public String getName() {
        return CHECK_NAME;
    }

    @Override
    public String getDescription() {
        return CHECK_DESCRIPTION;
    }

    @Override
    public boolean isCritical() {
        return true;
    }
}

