/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckManager;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClassLoaderCheckManager
extends CheckManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleClassLoaderCheckManager.class);
    private ArrayList<Check> checks = new ArrayList();

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected void loadChecks() {
        CodeSource source = SimpleClassLoaderCheckManager.class.getProtectionDomain().getCodeSource();
        URL location = null;
        if (source != null) {
            location = source.getLocation();
            System.out.println(location);
        }
        String packageResourcePath = "it" + File.separatorChar + "grid" + File.separatorChar + "storm" + File.separatorChar + "check" + File.separatorChar + "sanity";
        List<String> classes = this.getClasseNamesInPackage(location.toString(), packageResourcePath);
        for (String className : classes) {
            Class<?> classe = null;
            try {
                classe = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            try {
                Constructor<?> constructor = classe.getConstructor(new Class[0]);
                try {
                    Check check = (Check)constructor.newInstance(new Object[0]);
                    this.checks.add(check);
                }
                catch (IllegalArgumentException e) {
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
    }

    private List<String> getClasseNamesInPackage(String jarName, String packageName) {
        ArrayList<String> arrayList = new ArrayList<String>();
        packageName = packageName.replaceAll("\\.", "" + File.separatorChar);
        try {
            JarEntry jarEntry;
            JarInputStream jarFile = new JarInputStream(new FileInputStream(jarName));
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (!jarEntry.getName().startsWith(packageName) || !jarEntry.getName().endsWith(".class")) continue;
                arrayList.add(jarEntry.getName().replaceAll("" + File.separatorChar, "\\."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    @Override
    protected List<Check> prepareSchedule() {
        return this.checks;
    }
}

