/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckResponse;
import it.grid.storm.check.CheckStatus;
import it.grid.storm.check.GenericCheckException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public abstract class CheckManager {
    private final List<Check> checkSchedule = new ArrayList<Check>();

    public void init() {
        this.getLogger().debug("Initializing Check Manager");
        this.loadChecks();
        this.checkSchedule.addAll(this.prepareSchedule());
        this.getLogger().debug("Initialization completed");
    }

    protected abstract void loadChecks();

    protected abstract List<Check> prepareSchedule();

    protected abstract Logger getLogger();

    public CheckResponse lauchChecks() {
        this.getLogger().debug("Executing check schedule");
        CheckResponse result = new CheckResponse(CheckStatus.SUCCESS, "");
        for (Check check : this.checkSchedule) {
            CheckResponse response;
            this.getLogger().info("Executing check : " + check.getName());
            this.getLogger().info("Check description : " + check.getDescription());
            try {
                response = check.execute();
            }
            catch (GenericCheckException e) {
                this.getLogger().warn("Received a GenericCheckException during " + check.getName() + " check execution : " + e.getMessage());
                response = new CheckResponse(CheckStatus.INDETERMINATE, "Received a GenericCheckException during " + check.getName() + " check execution : " + e.getMessage());
            }
            this.getLogger().info("Check '" + check.getName() + "' response is : " + response.toString());
            if (!response.isSuccessfull() && check.isCritical()) {
                result.setStatus(CheckStatus.and(result.getStatus(), CheckStatus.CRITICAL_FAILURE));
            } else {
                result.setStatus(CheckStatus.and(result.getStatus(), response.getStatus()));
            }
            this.getLogger().debug("Partial result is " + (result.isSuccessfull() ? "success" : "failure"));
        }
        return result;
    }
}

