/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.BoLChunkCatalog;
import it.grid.storm.catalogs.InvalidRequestSummaryDataAttributesException;
import it.grid.storm.catalogs.MalformedGridUserException;
import it.grid.storm.catalogs.PinLifetimeConverter;
import it.grid.storm.catalogs.PtGChunkCatalog;
import it.grid.storm.catalogs.RequestSummaryDAO;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.catalogs.RequestSummaryDataTO;
import it.grid.storm.catalogs.RequestTypeConverter;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummaryCatalog {
    private static final Logger log = LoggerFactory.getLogger(RequestSummaryCatalog.class);
    private static RequestSummaryCatalog cat = new RequestSummaryCatalog();
    private final RequestSummaryDAO dao = RequestSummaryDAO.getInstance();
    private Timer clock = null;
    private TimerTask clockTask = null;

    private RequestSummaryCatalog() {
        if (Configuration.getInstance().getExpiredRequestPurging()) {
            this.clock = new Timer();
            this.clockTask = new TimerTask(){

                @Override
                public void run() {
                    ArrayList expiredRequests = RequestSummaryCatalog.this.purgeExpiredRequests();
                    RequestSummaryCatalog.this.removeOrphanProxies(expiredRequests);
                }
            };
            this.clock.scheduleAtFixedRate(this.clockTask, Configuration.getInstance().getRequestPurgerDelay() * 1000, (long)(Configuration.getInstance().getRequestPurgerPeriod() * 1000));
        }
        TimerTask tableRecallPurgeTask = new TimerTask(){

            @Override
            public void run() {
                new TapeRecallCatalog().purgeCatalog(Configuration.getInstance().getPurgeBatchSize());
            }
        };
        this.clock.scheduleAtFixedRate(tableRecallPurgeTask, Configuration.getInstance().getTransitInitialDelay() * 1000L, Configuration.getInstance().getTransitTimeInterval() * 1000L);
    }

    public static RequestSummaryCatalog getInstance() {
        return cat;
    }

    public synchronized Collection<RequestSummaryData> fetchNewRequests(int capacity) {
        Collection<RequestSummaryDataTO> c = this.dao.findNew(capacity);
        if (c != null && !c.isEmpty()) {
            log.debug("REQUEST SUMMARY CATALOG: retrieved data " + c);
        }
        ArrayList<RequestSummaryData> list = new ArrayList<RequestSummaryData>();
        if (!c.isEmpty()) {
            int fetched = c.size();
            log.debug("REQUEST SUMMARY CATALOG: " + fetched + " new requests picked up. ");
            for (RequestSummaryDataTO auxTO : c) {
                try {
                    RequestSummaryData aux = this.makeOne(auxTO);
                    if (aux == null) continue;
                    log.debug("REQUEST SUMMARY CATALOG; " + aux.requestToken() + " associated to " + aux.gridUser().getDn() + " included for processing ");
                    list.add(aux);
                }
                catch (IllegalArgumentException e) {
                    log.error("REQUEST SUMMARY CATALOG; Failure performing makeOne operation. IllegalArgumentException: " + e.getMessage());
                }
            }
            int ret = list.size();
            if (ret < fetched) {
                log.warn("REQUEST SUMMARY CATALOG: including " + ret + " requests for processing, since the dropped ones were malformed!");
            } else {
                log.debug("REQUEST SUMMARY CATALOG: including for processing all " + ret + " requests.");
            }
        }
        if (!list.isEmpty()) {
            log.debug("REQUEST SUMMARY CATALOG: returning " + list + "\n\n");
        }
        return list;
    }

    private RequestSummaryData makeOne(RequestSummaryDataTO to) throws IllegalArgumentException {
        GridUserInterface auxgu;
        TRequestToken auxrtoken;
        TRequestType auxrtype = RequestTypeConverter.getInstance().toSTORM(to.requestType());
        if (auxrtype == TRequestType.EMPTY) {
            StringBuffer sb = new StringBuffer();
            sb.append("TRequestType could not be created from its String representation ");
            sb.append(to.requestType());
            sb.append("\n");
            log.warn(sb.toString());
            throw new IllegalArgumentException("Invalid TRequestType in the provided RequestSummaryDataTO");
        }
        try {
            auxrtoken = new TRequestToken(to.requestToken(), to.timestamp());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            log.warn("Unable to create TRequestToken from RequestSummaryDataTO. InvalidTRequestTokenAttributesException: " + e.getMessage());
            throw new IllegalArgumentException("Unable to create TRequestToken from RequestSummaryDataTO.");
        }
        try {
            auxgu = this.loadVomsGridUser(to.clientDN(), to.vomsAttributes(), to.requestToken());
        }
        catch (MalformedGridUserException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("VomsGridUser could not be created from DN String ");
            sb.append(to.clientDN());
            sb.append(" voms attributes String ");
            sb.append(to.vomsAttributes());
            sb.append(" and from request token String ");
            sb.append(to.requestToken());
            log.warn(sb.toString() + " MalformedGridUserException: " + e.getMessage());
            throw new IllegalArgumentException("Unable to load Voms Grid User from RequestSummaryDataTO. MalformedGridUserException: " + e.getMessage());
        }
        RequestSummaryData data = null;
        try {
            data = new RequestSummaryData(auxrtype, auxrtoken, auxgu);
            data.setPrimaryKey(to.primaryKey());
        }
        catch (InvalidRequestSummaryDataAttributesException e) {
            this.dao.failRequest(to.primaryKey(), "The request data is malformed!");
            log.warn("REQUEST SUMMARY CATALOG! Unable to create RequestSummaryData. InvalidRequestSummaryDataAttributesException: " + e.getMessage());
            log.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Unable to reate RequestSummaryData");
        }
        TReturnStatus status = null;
        if (to.getStatus() != null) {
            TStatusCode code = StatusCodeConverter.getInstance().toSTORM(to.getStatus());
            if (code == TStatusCode.EMPTY) {
                log.warn("RequestSummaryDataTO retrieved StatusCode was not recognised: " + to.getStatus());
            } else {
                try {
                    status = new TReturnStatus(code, to.getErrstring());
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    log.warn("Unable to build TReturnStatus from " + (Object)((Object)code) + " " + to.getErrstring() + ".InvalidTReturnStatusAttributeException : " + e.getMessage());
                }
            }
        }
        data.setUserToken(to.getUserToken());
        data.setRetrytime(to.getRetrytime());
        if (to.getPinLifetime() != null) {
            data.setPinLifetime(TLifeTimeInSeconds.make(PinLifetimeConverter.getInstance().toStoRM(to.getPinLifetime()), TimeUnit.SECONDS));
        }
        data.setSpaceToken(to.getSpaceToken());
        data.setStatus(status);
        data.setErrstring(to.getErrstring());
        data.setRemainingTotalTime(to.getRemainingTotalTime());
        data.setNbreqfiles(to.getNbreqfiles());
        data.setNumOfCompleted(to.getNumOfCompleted());
        if (to.getFileLifetime() != null) {
            data.setFileLifetime(TLifeTimeInSeconds.make(to.getFileLifetime().intValue(), TimeUnit.SECONDS));
        }
        data.setDeferredStartTime(to.getDeferredStartTime());
        data.setNumOfWaiting(to.getNumOfWaiting());
        data.setNumOfFailed(to.getNumOfFailed());
        data.setRemainingDeferredStartTime(to.getRemainingDeferredStartTime());
        return data;
    }

    private GridUserInterface loadVomsGridUser(String dn, String fqans_string, String rtoken) throws MalformedGridUserException {
        GridUserInterface gridUser;
        log.debug("REQUEST SUMMARY CATALOG! Received request to create VomsGridUser for " + dn + " " + rtoken);
        String proxyString = null;
        FQAN[] fqans_vector = null;
        try {
            File proxyFile = new File(Configuration.getInstance().getProxyHome() + File.separator + rtoken);
            if (proxyFile.exists()) {
                int c;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                FileInputStream in = new FileInputStream(proxyFile);
                while ((c = ((InputStream)in).read()) != -1) {
                    out.write(c);
                }
                ((InputStream)in).close();
                out.close();
                proxyString = new String(out.toByteArray());
                log.debug("REQUEST SUMMARY CATALOG: Loaded proxy file " + proxyFile.getAbsolutePath() + " for request " + rtoken);
                log.debug("REQUEST SUMMARY CATALOG: proxy content is " + proxyString);
            } else {
                log.debug("REQUEST SUMMARY CATALOG: No proxy file " + proxyFile.getAbsolutePath() + " found for request " + rtoken);
            }
        }
        catch (FileNotFoundException e) {
            log.error("REQUEST SUMMARY CATALOG! The file containing the proxy was deleted just before reading its content! No proxy has been loaded!");
        }
        catch (IOException e) {
            log.error("REQUEST SUMMARY CATALOG! The file containing the proxy could not be read! No proxy has been loaded! " + e);
        }
        catch (Exception e) {
            log.error("REQUEST SUMMARY CATALOG! There was an unexpected error while attempting to read the file containing the proxy! No proxy has been loaded!");
        }
        if (fqans_string != "") {
            String[] fqans_string_array = fqans_string.split("#");
            if (fqans_string_array.length != 0) {
                fqans_vector = new FQAN[fqans_string_array.length];
                for (int i = 0; i < fqans_string_array.length; ++i) {
                    fqans_vector[i] = new FQAN(fqans_string_array[i]);
                }
            }
        } else {
            fqans_string = null;
        }
        log.debug("REQUEST SUMMARY CATALOG! Received request to create VomsGridUser for " + dn + " " + fqans_string + " " + proxyString);
        if (dn != null && fqans_vector != null && fqans_vector.length > 0 && proxyString != null) {
            log.debug("REQUEST SUMMARY CATALOG! DN, VOMS Attributes, and Proxy certificate found for request " + rtoken);
            gridUser = null;
            try {
                gridUser = GridUserManager.makeVOMSGridUser(dn, proxyString, fqans_vector);
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
            }
            return gridUser;
        }
        if (dn != null && fqans_vector != null && fqans_vector.length > 0 && proxyString == null) {
            log.debug("REQUEST SUMMARY CATALOG! DN and VOMS Attributes found for request " + rtoken);
            gridUser = null;
            try {
                gridUser = GridUserManager.makeVOMSGridUser(dn, fqans_vector);
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
            }
            return gridUser;
        }
        if (dn != null && fqans_string == null && proxyString != null) {
            log.debug("REQUEST SUMMARY CATALOG! DN and Proxy found for request " + rtoken);
            return GridUserManager.makeGridUser(dn, proxyString);
        }
        if (dn != null && fqans_string == null && proxyString == null) {
            log.debug("REQUEST SUMMARY CATALOG! DN only found for request " + rtoken);
            return GridUserManager.makeGridUser(dn);
        }
        log.warn("REQUEST SUMMARY CATALOG! Catalog retrieved invalid credentials data for request " + rtoken);
        log.warn("REQUEST SUMMARY CATALOG! proxy=" + fqans_string + "\n dn=" + dn + "\n attributes=" + fqans_string);
        throw new MalformedGridUserException();
    }

    public synchronized void updateGlobalStatus(TRequestToken rt, TReturnStatus status) {
        this.dao.updateGlobalStatus(rt.toString(), StatusCodeConverter.getInstance().toDB(status.getStatusCode()), status.getExplanation());
    }

    public void updateFromPreviousGlobalStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        this.dao.updateGlobalStatusOnMatchingGlobalStatus(requestToken, expectedStatusCode, newStatusCode, explanation);
    }

    public synchronized void updateGlobalStatusPinFileLifetime(TRequestToken rt, TReturnStatus status) {
        this.dao.updateGlobalStatusPinFileLifetime(rt.toString(), StatusCodeConverter.getInstance().toDB(status.getStatusCode()), status.getExplanation());
    }

    public synchronized void failRequest(RequestSummaryData rsd, String explanation) {
        if (rsd != null) {
            TRequestType rtype = rsd.requestType();
            if (rtype == TRequestType.PREPARE_TO_GET) {
                this.dao.failPtGRequest(rsd.primaryKey(), explanation);
            } else if (rtype == TRequestType.PREPARE_TO_PUT) {
                this.dao.failPtPRequest(rsd.primaryKey(), explanation);
            } else if (rtype == TRequestType.COPY) {
                this.dao.failCopyRequest(rsd.primaryKey(), explanation);
            } else {
                this.dao.failRequest(rsd.primaryKey(), explanation);
            }
        }
    }

    public synchronized void abortRequest(TRequestToken rt) {
        if (rt != null) {
            this.dao.abortRequest(rt.toString());
        }
    }

    public synchronized void abortChunksOfRequest(TRequestToken rt, Collection<TSURL> c) {
        if (rt != null && c != null && !c.isEmpty()) {
            try {
                ArrayList<String> aux = new ArrayList<String>();
                for (TSURL tsurl : c) {
                    aux.add(tsurl.toString());
                }
                this.dao.abortChunksOfRequest(rt.toString(), aux);
            }
            catch (ClassCastException e) {
                log.error("REQUEST SUMMARY CATALOG! Unexpected error in abortChunksOfRequest: the supplied Collection did not contain TSURLs! " + c + e);
            }
        }
    }

    public synchronized void abortChunksOfInProgressRequest(TRequestToken rt, Collection<TSURL> tsurls) {
        if (rt != null && tsurls != null && !tsurls.isEmpty()) {
            try {
                ArrayList<String> aux = new ArrayList<String>();
                for (TSURL tsurl : tsurls) {
                    aux.add(tsurl.toString());
                }
                this.dao.abortChunksOfInProgressRequest(rt.toString(), aux);
            }
            catch (ClassCastException e) {
                log.error("REQUEST SUMMARY CATALOG! Unexpected error in abortChunksOfInProgressRequest: the supplied Collection did not contain TSURLs! " + tsurls + e);
            }
        }
    }

    public synchronized RequestSummaryData find(TRequestToken requestToken) throws IllegalArgumentException {
        if (requestToken == null || requestToken.toString().trim().isEmpty()) {
            throw new IllegalArgumentException("Unable to perform find, illegal arguments: requestToken=" + requestToken);
        }
        RequestSummaryDataTO to = this.dao.find(requestToken.toString());
        if (to != null) {
            try {
                RequestSummaryData data = this.makeOne(to);
                if (data != null) {
                    log.debug("REQUEST SUMMARY CATALOG; " + data.requestToken() + " associated to " + data.gridUser().getDn() + " retrieved");
                    return data;
                }
            }
            catch (IllegalArgumentException e) {
                log.error("REQUEST SUMMARY CATALOG; Failure performing makeOne operation. IllegalArgumentException: " + e.getMessage());
            }
        } else {
            log.debug("REQUEST SUMMARY CATALOG; " + requestToken + " token not found");
        }
        return null;
    }

    public synchronized TRequestType typeOf(TRequestToken rt) {
        String type = null;
        if (rt != null) {
            type = this.dao.typeOf(rt.toString());
        }
        return RequestTypeConverter.getInstance().toSTORM(type);
    }

    public synchronized void abortInProgressRequest(TRequestToken rt) {
        if (rt != null) {
            this.dao.abortInProgressRequest(rt.toString());
        }
    }

    private synchronized ArrayList<String> purgeExpiredRequests() {
        ArrayList<String> expiredRequests = new ArrayList<String>();
        PtGChunkCatalog.getInstance().transitExpiredSRM_FILE_PINNED();
        BoLChunkCatalog.getInstance().transitExpiredSRM_SUCCESS();
        int garbageChunkSize = Configuration.getInstance().getPurgeBatchSize();
        int minChunkSize = garbageChunkSize / 2;
        int nrExpiredTasks = this.dao.getNumberExpired();
        int nrChunks = nrExpiredTasks / garbageChunkSize;
        if (nrChunks < 1) {
            if (nrExpiredTasks > minChunkSize) {
                log.debug("Purging the expired in single step (expired requests:" + nrExpiredTasks + ")");
            } else {
                log.debug("Skipping the purging phase of expired requests. (expired requests:" + nrExpiredTasks + ")");
            }
        } else {
            log.debug("Purging the expired requests in " + nrChunks + " steps (expired requests:" + nrExpiredTasks + ")");
            for (int i = 0; i < nrChunks; ++i) {
                expiredRequests.addAll(this.dao.purgeExpiredRequests());
            }
            log.info("REQUEST SUMMARY CATALOG; removed from DB < " + expiredRequests.size() + " > expired requests");
        }
        return expiredRequests;
    }

    private void removeOrphanProxies(ArrayList<String> expiredRequests) {
        if (!expiredRequests.isEmpty()) {
            for (String rt : expiredRequests) {
                String proxyFileName = Configuration.getInstance().getProxyHome() + File.separator + rt;
                File proxyFile = new File(proxyFileName);
                if (!proxyFile.exists()) continue;
                boolean deleted = proxyFile.delete();
                if (!deleted) {
                    log.error("ERROR IN REQUEST SUMMARY CATALOG! Removal of proxy file " + proxyFileName + " failed!");
                    continue;
                }
                log.info("REQUEST SUMMARY CATALOG: removed proxy file " + proxyFileName);
            }
        }
    }
}

