/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidReducedPtPChunkDataAttributesException;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducedPtPChunkData {
    private static final Logger log = LoggerFactory.getLogger(ReducedPtPChunkData.class);
    private long primaryKey = -1L;
    private TSURL toSURL;
    private TReturnStatus status;
    private TFileStorageType fileStorageType;
    private TLifeTimeInSeconds fileLifetime;

    public ReducedPtPChunkData(TSURL toSURL, TReturnStatus status, TFileStorageType fileStorageType, TLifeTimeInSeconds fileLifetime) throws InvalidReducedPtPChunkDataAttributesException {
        if (status == null || toSURL == null || fileStorageType == null || fileLifetime == null) {
            throw new InvalidReducedPtPChunkDataAttributesException(toSURL, status, fileStorageType, fileLifetime);
        }
        this.toSURL = toSURL;
        this.status = status;
        this.fileStorageType = fileStorageType;
        this.fileLifetime = fileLifetime;
    }

    public long primaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(long l) {
        this.primaryKey = l;
    }

    public TSURL toSURL() {
        return this.toSURL;
    }

    public TReturnStatus status() {
        return this.status;
    }

    public TFileStorageType fileStorageType() {
        return this.fileStorageType;
    }

    public TLifeTimeInSeconds fileLifetime() {
        return this.fileLifetime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReducedPtPChunkData\n");
        sb.append("primaryKey=");
        sb.append(this.primaryKey);
        sb.append("; ");
        sb.append("toSURL=");
        sb.append(this.toSURL);
        sb.append("; ");
        sb.append("status=");
        sb.append(this.status);
        sb.append(";");
        sb.append("fileStorageType=");
        sb.append(this.fileStorageType);
        sb.append(";");
        sb.append("fileLifetime=");
        sb.append(this.fileLifetime);
        sb.append(".");
        return sb.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + new Long(this.primaryKey).hashCode();
        hash = 37 * hash + this.toSURL.hashCode();
        hash = 37 * hash + this.status.hashCode();
        hash = 37 * hash + this.fileStorageType.hashCode();
        hash = 37 * hash + this.fileLifetime.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReducedPtPChunkData)) {
            return false;
        }
        ReducedPtPChunkData cd = (ReducedPtPChunkData)o;
        return this.primaryKey == cd.primaryKey && this.toSURL.equals(cd.toSURL) && this.status.equals(cd.status) && this.fileStorageType.equals(cd.fileStorageType) && this.fileLifetime.equals(cd.fileLifetime);
    }
}

