/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.InvalidReducedBoLChunkDataAttributesException;
import it.grid.storm.catalogs.ReducedChunkData;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducedBoLChunkData
implements ReducedChunkData {
    private static final Logger log = LoggerFactory.getLogger(ReducedBoLChunkData.class);
    private long primaryKey = -1L;
    private TSURL fromSURL;
    private TReturnStatus status;

    public ReducedBoLChunkData(TSURL fromSURL, TReturnStatus status) throws InvalidReducedBoLChunkDataAttributesException {
        boolean ok;
        boolean bl = ok = status != null && fromSURL != null;
        if (!ok) {
            throw new InvalidReducedBoLChunkDataAttributesException(fromSURL, status);
        }
        this.fromSURL = fromSURL;
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReducedBoLChunkData)) {
            return false;
        }
        ReducedBoLChunkData cd = (ReducedBoLChunkData)o;
        return this.primaryKey == cd.primaryKey && this.fromSURL.equals(cd.fromSURL) && this.status.equals(cd.status);
    }

    @Override
    public TSURL fromSURL() {
        return this.fromSURL;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + new Long(this.primaryKey).hashCode();
        hash = 37 * hash + this.fromSURL.hashCode();
        hash = 37 * hash + this.status.hashCode();
        return hash;
    }

    @Override
    public boolean isPinned() {
        return this.status.getStatusCode() == TStatusCode.SRM_SUCCESS;
    }

    @Override
    public long primaryKey() {
        return this.primaryKey;
    }

    @Override
    public void setPrimaryKey(long l) {
        this.primaryKey = l;
    }

    @Override
    public TReturnStatus status() {
        return this.status;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReducedBoLChunkData\n");
        sb.append("primaryKey=");
        sb.append(this.primaryKey);
        sb.append("; ");
        sb.append("fromSURL=");
        sb.append(this.fromSURL);
        sb.append("; ");
        sb.append("status=");
        sb.append(this.status);
        sb.append(".");
        return sb.toString();
    }
}

