/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.IdentityPtPData;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidPtPDataAttributesException;
import it.grid.storm.catalogs.InvalidPtPPersistentChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PersistentChunkData;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;

public class PtPPersistentChunkData
extends IdentityPtPData
implements PersistentChunkData {
    private long primaryKey = -1L;
    private final TRequestToken requestToken;

    public PtPPersistentChunkData(GridUserInterface auth, TRequestToken requestToken, TSURL toSURL, TLifeTimeInSeconds pinLifetime, TLifeTimeInSeconds fileLifetime, TFileStorageType fileStorageType, TSpaceToken spaceToken, TSizeInBytes expectedFileSize, TURLPrefix transferProtocols, TOverwriteMode overwriteOption, TReturnStatus status, TTURL transferURL) throws InvalidPtPPersistentChunkDataAttributesException, InvalidPtPDataAttributesException, InvalidFileTransferDataAttributesException, InvalidSurlRequestDataAttributesException {
        super(auth, toSURL, pinLifetime, fileLifetime, fileStorageType, spaceToken, expectedFileSize, transferProtocols, overwriteOption, status, transferURL);
        if (requestToken == null) {
            throw new InvalidPtPPersistentChunkDataAttributesException(requestToken, toSURL, pinLifetime, fileLifetime, fileStorageType, spaceToken, expectedFileSize, transferProtocols, overwriteOption, status, transferURL);
        }
        this.requestToken = requestToken;
    }

    @Override
    public long getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(long l) {
        this.primaryKey = l;
    }

    @Override
    public TRequestToken getRequestToken() {
        return this.requestToken;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public long getIdentifier() {
        return this.getPrimaryKey();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.primaryKey ^ this.primaryKey >>> 32);
        result = 31 * result + (this.requestToken == null ? 0 : this.requestToken.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PtPPersistentChunkData other = (PtPPersistentChunkData)obj;
        if (this.primaryKey != other.primaryKey) {
            return false;
        }
        return !(this.requestToken == null ? other.requestToken != null : !this.requestToken.equals(other.requestToken));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PtPPersistentChunkData [primaryKey=");
        builder.append(this.primaryKey);
        builder.append(", requestToken=");
        builder.append(this.requestToken);
        builder.append(", spaceToken=");
        builder.append(this.spaceToken);
        builder.append(", pinLifetime=");
        builder.append(this.pinLifetime);
        builder.append(", fileLifetime=");
        builder.append(this.fileLifetime);
        builder.append(", fileStorageType=");
        builder.append(this.fileStorageType);
        builder.append(", overwriteOption=");
        builder.append(this.overwriteOption);
        builder.append(", expectedFileSize=");
        builder.append(this.expectedFileSize);
        builder.append(", transferProtocols=");
        builder.append(this.transferProtocols);
        builder.append(", SURL=");
        builder.append(this.SURL);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", transferURL=");
        builder.append(this.transferURL);
        builder.append("]");
        return builder.toString();
    }
}

