/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.FileStorageTypeConverter;
import it.grid.storm.catalogs.OverwriteModeConverter;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.catalogs.TransferProtocolListConverter;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.config.Configuration;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TStatusCode;
import java.sql.Timestamp;
import java.util.List;

public class PtPChunkDataTO {
    private static final String FQAN_SEPARATOR = "#";
    private long primaryKey = -1L;
    private String toSURL = " ";
    private long expectedFileSize = 0L;
    private String normalizedStFN = null;
    private Integer surlUniqueID = null;
    private String requestToken = " ";
    private int pinLifetime = -1;
    private int fileLifetime = -1;
    private String fileStorageType = FileStorageTypeConverter.getInstance().toDB(TFileStorageType.getTFileStorageType(Configuration.getInstance().getDefaultFileStorageType()));
    private String spaceToken = " ";
    private List<String> protocolList = null;
    private String overwriteOption = null;
    private int status;
    private String errString = " ";
    private String turl = " ";
    private Timestamp timeStamp = null;
    private String clientDN = null;
    private String vomsAttributes = null;

    public PtPChunkDataTO() {
        TURLPrefix protocolPreferences = new TURLPrefix();
        protocolPreferences.addProtocol(Protocol.GSIFTP);
        this.protocolList = TransferProtocolListConverter.toDB(protocolPreferences);
        this.overwriteOption = OverwriteModeConverter.getInstance().toDB(TOverwriteMode.NEVER);
        this.status = StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED);
    }

    public long primaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(long n) {
        this.primaryKey = n;
    }

    public String requestToken() {
        return this.requestToken;
    }

    public void setRequestToken(String s) {
        this.requestToken = s;
    }

    public Timestamp timeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Timestamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String toSURL() {
        return this.toSURL;
    }

    public void setToSURL(String s) {
        this.toSURL = s;
    }

    public String normalizedStFN() {
        return this.normalizedStFN;
    }

    public void setNormalizedStFN(String normalizedStFN) {
        this.normalizedStFN = normalizedStFN;
    }

    public Integer surlUniqueID() {
        return this.surlUniqueID;
    }

    public void setSurlUniqueID(Integer surlUniqueID) {
        this.surlUniqueID = surlUniqueID;
    }

    public int pinLifetime() {
        return this.pinLifetime;
    }

    public void setPinLifetime(int n) {
        this.pinLifetime = n;
    }

    public int fileLifetime() {
        return this.fileLifetime;
    }

    public void setFileLifetime(int n) {
        this.fileLifetime = n;
    }

    public String fileStorageType() {
        return this.fileStorageType;
    }

    public void setFileStorageType(String s) {
        if (s != null) {
            this.fileStorageType = s;
        }
    }

    public String spaceToken() {
        return this.spaceToken;
    }

    public void setSpaceToken(String s) {
        this.spaceToken = s;
    }

    public long expectedFileSize() {
        return this.expectedFileSize;
    }

    public void setExpectedFileSize(long l) {
        this.expectedFileSize = l;
    }

    public List<String> protocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<String> l) {
        if (l != null && !l.isEmpty()) {
            this.protocolList = l;
        }
    }

    public String overwriteOption() {
        return this.overwriteOption;
    }

    public void setOverwriteOption(String s) {
        if (s != null) {
            this.overwriteOption = s;
        }
    }

    public int status() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String errString() {
        return this.errString;
    }

    public void setErrString(String s) {
        this.errString = s;
    }

    public String transferURL() {
        return this.turl;
    }

    public void setTransferURL(String s) {
        this.turl = s;
    }

    public String clientDN() {
        return this.clientDN;
    }

    public void setClientDN(String s) {
        this.clientDN = s;
    }

    public String vomsAttributes() {
        return this.vomsAttributes;
    }

    public void setVomsAttributes(String s) {
        this.vomsAttributes = s;
    }

    public void setVomsAttributes(String[] fqaNsAsString) {
        this.vomsAttributes = "";
        for (int i = 0; i < fqaNsAsString.length; ++i) {
            this.vomsAttributes = this.vomsAttributes + fqaNsAsString[i];
            if (i >= fqaNsAsString.length - 1) continue;
            this.vomsAttributes = this.vomsAttributes + FQAN_SEPARATOR;
        }
    }

    public String[] vomsAttributesArray() {
        return this.vomsAttributes.split(FQAN_SEPARATOR);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.primaryKey);
        sb.append(" ");
        sb.append(this.requestToken);
        sb.append(" ");
        sb.append(this.toSURL);
        sb.append(" ");
        sb.append(this.normalizedStFN);
        sb.append(" ");
        sb.append(this.surlUniqueID);
        sb.append(" ");
        sb.append(this.pinLifetime);
        sb.append(" ");
        sb.append(this.fileLifetime);
        sb.append(" ");
        sb.append(this.fileStorageType);
        sb.append(" ");
        sb.append(this.spaceToken);
        sb.append(" ");
        sb.append(this.expectedFileSize);
        sb.append(" ");
        sb.append(this.protocolList);
        sb.append(" ");
        sb.append(this.overwriteOption);
        sb.append(" ");
        sb.append(this.status);
        sb.append(" ");
        sb.append(this.errString);
        sb.append(" ");
        sb.append(this.turl);
        return sb.toString();
    }
}

