/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.PtPChunkDataTO;
import it.grid.storm.catalogs.ReducedPtPChunkDataTO;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtPChunkDAO {
    private static final Logger log = LoggerFactory.getLogger(PtPChunkDAO.class);
    private final String driver = Configuration.getInstance().getDBDriver();
    private final String url = Configuration.getInstance().getDBURL();
    private final String password = Configuration.getInstance().getDBPassword();
    private final String name = Configuration.getInstance().getDBUserName();
    private Connection con = null;
    private static final PtPChunkDAO dao = new PtPChunkDAO();
    private Timer clock = null;
    private TimerTask clockTask = null;
    private long period = Configuration.getInstance().getDBReconnectPeriod() * 1000L;
    private long delay = Configuration.getInstance().getDBReconnectDelay() * 1000L;
    private boolean reconnect = false;

    private PtPChunkDAO() {
        this.setUpConnection();
        this.clock = new Timer();
        this.clockTask = new TimerTask(){

            @Override
            public void run() {
                PtPChunkDAO.this.reconnect = true;
            }
        };
        this.clock.scheduleAtFixedRate(this.clockTask, this.delay, this.period);
    }

    public static PtPChunkDAO getInstance() {
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(PtPChunkDataTO to) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: update - unable to get a valid connection!");
            return;
        }
        PreparedStatement updatePut = null;
        try {
            updatePut = this.con.prepareStatement("UPDATE request_queue rq JOIN (status_Put sp, request_Put rp) ON (rq.ID=rp.request_queueID AND sp.request_PutID=rp.ID) SET sp.transferURL=?, sp.statusCode=?, sp.explanation=?, rq.pinLifetime=?, rq.fileLifetime=?, rq.config_FileStorageTypeID=?, rq.config_OverwriteID=?, rp.normalized_targetSURL_StFN=?, rp.targetSURL_uniqueID=? WHERE rp.ID=?");
            this.logWarnings(this.con.getWarnings());
            updatePut.setString(1, to.transferURL());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setInt(2, to.status());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setString(3, to.errString());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setInt(4, to.pinLifetime());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setInt(5, to.fileLifetime());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setString(6, to.fileStorageType());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setString(7, to.overwriteOption());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setString(8, to.normalizedStFN());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setInt(9, to.surlUniqueID());
            this.logWarnings(updatePut.getWarnings());
            updatePut.setLong(10, to.primaryKey());
            this.logWarnings(updatePut.getWarnings());
            log.trace("PtP CHUNK DAO - update method: " + updatePut.toString());
            updatePut.executeUpdate();
            this.logWarnings(updatePut.getWarnings());
        }
        catch (SQLException e) {
            log.error("PtP CHUNK DAO: Unable to complete update! " + e);
        }
        finally {
            this.close(updatePut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateIncomplete(ReducedPtPChunkDataTO chunkTO) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: updateIncomplete - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE request_Put SET normalized_targetSURL_StFN=?, targetSURL_uniqueID=? WHERE ID=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, chunkTO.normalizedStFN());
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, chunkTO.surlUniqueID());
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(3, chunkTO.primaryKey());
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - update incomplete: " + stmt.toString());
            stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
        }
        catch (SQLException e) {
            log.error("PtP CHUNK DAO: Unable to complete update incomplete! " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PtPChunkDataTO refresh(long primary_key) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: refresh - unable to get a valid connection!");
            return null;
        }
        String prot = "SELECT tp.config_ProtocolsID FROM request_TransferProtocols tp WHERE tp.request_queueID IN (SELECT rp.request_queueID FROM request_Put rp WHERE rp.ID=?)";
        String refresh = "SELECT rq.config_FileStorageTypeID, rq.config_OverwriteID, rq.timeStamp, rq.pinLifetime, rq.fileLifetime, rq.s_token, rq.r_token, rq.client_dn, rq.proxy, rp.ID, rp.targetSURL, rp.expectedFileSize, rp.normalized_targetSURL_StFN, rp.targetSURL_uniqueID, sp.statusCode, sp.transferURL FROM request_queue rq JOIN (request_Put rp, status_Put sp) ON (rq.ID=rp.request_queueID AND sp.request_PutID=rp.ID) WHERE rp.ID=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PtPChunkDataTO chunkDataTO = null;
        try {
            stmt = this.con.prepareStatement(prot);
            this.logWarnings(this.con.getWarnings());
            ArrayList<String> protocols = new ArrayList<String>();
            stmt.setLong(1, primary_key);
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - refresh method: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            while (rs.next()) {
                protocols.add(rs.getString("tp.config_ProtocolsID"));
            }
            this.close(rs);
            this.close(stmt);
            stmt = this.con.prepareStatement(refresh);
            this.logWarnings(this.con.getWarnings());
            stmt.setLong(1, primary_key);
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - refresh method: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            if (rs.next()) {
                chunkDataTO = new PtPChunkDataTO();
                chunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                chunkDataTO.setOverwriteOption(rs.getString("rq.config_OverwriteID"));
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setPinLifetime(rs.getInt("rq.pinLifetime"));
                chunkDataTO.setFileLifetime(rs.getInt("rq.fileLifetime"));
                chunkDataTO.setSpaceToken(rs.getString("rq.s_token"));
                chunkDataTO.setRequestToken(rs.getString("rq.r_token"));
                chunkDataTO.setPrimaryKey(rs.getLong("rp.ID"));
                chunkDataTO.setToSURL(rs.getString("rp.targetSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rp.normalized_targetSURL_StFN"));
                int uniqueID = rs.getInt("rp.targetSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setExpectedFileSize(rs.getLong("rp.expectedFileSize"));
                chunkDataTO.setProtocolList(protocols);
                chunkDataTO.setStatus(rs.getInt("sp.statusCode"));
                chunkDataTO.setTransferURL(rs.getString("sp.transferURL"));
                chunkDataTO.setClientDN(rs.getString("rq.client_dn"));
                Blob blob = rs.getBlob("rq.proxy");
                if (!rs.wasNull() && blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    chunkDataTO.setVomsAttributes(new String(bdata));
                }
                if (rs.next()) {
                    log.warn("ATTENTION in PtP CHUNK DAO! Possible DB corruption! refresh method invoked for specific chunk with id " + primary_key + ", but found more than one such chunks!");
                }
            } else {
                log.warn("ATTENTION in PtP CHUNK DAO! Possible DB corruption! refresh method invoked for specific chunk with id " + primary_key + ", but chunk NOT found in persistence!");
            }
            this.close(rs);
            this.close(stmt);
        }
        catch (SQLException e) {
            log.error("PtP CHUNK DAO! Unable to refresh chunk! " + e);
            chunkDataTO = null;
        }
        finally {
            this.close(rs);
            this.close(stmt);
        }
        return chunkDataTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<PtPChunkDataTO> find(TRequestToken requestToken) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: find - unable to get a valid connection!");
            return null;
        }
        String strToken = requestToken.toString();
        String str = null;
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            str = "SELECT tp.config_ProtocolsID FROM request_TransferProtocols tp JOIN request_queue rq ON tp.request_queueID=rq.ID WHERE rq.r_token=?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<String> protocols = new ArrayList<String>();
            find.setString(1, strToken);
            this.logWarnings(find.getWarnings());
            log.trace("PtP CHUNK DAO - find method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            while (rs.next()) {
                protocols.add(rs.getString("tp.config_ProtocolsID"));
            }
            this.close(rs);
            this.close(find);
            str = "SELECT rq.config_FileStorageTypeID, rq.config_OverwriteID, rq.timeStamp, rq.pinLifetime, rq.fileLifetime, rq.s_token, rq.client_dn, rq.proxy, rp.ID, rp.targetSURL, rp.expectedFileSize, rp.normalized_targetSURL_StFN, rp.targetSURL_uniqueID, sp.statusCode FROM request_queue rq JOIN (request_Put rp, status_Put sp) ON (rp.request_queueID=rq.ID AND sp.request_PutID=rp.ID) WHERE rq.r_token=? AND sp.statusCode<>?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<PtPChunkDataTO> list = new ArrayList<PtPChunkDataTO>();
            find.setString(1, strToken);
            this.logWarnings(find.getWarnings());
            find.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
            this.logWarnings(find.getWarnings());
            log.trace("PtP CHUNK DAO - find method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            PtPChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new PtPChunkDataTO();
                chunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                chunkDataTO.setOverwriteOption(rs.getString("rq.config_OverwriteID"));
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setPinLifetime(rs.getInt("rq.pinLifetime"));
                chunkDataTO.setFileLifetime(rs.getInt("rq.fileLifetime"));
                chunkDataTO.setSpaceToken(rs.getString("rq.s_token"));
                chunkDataTO.setClientDN(rs.getString("rq.client_dn"));
                Blob blob = rs.getBlob("rq.proxy");
                if (!rs.wasNull() && blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    chunkDataTO.setVomsAttributes(new String(bdata));
                }
                chunkDataTO.setPrimaryKey(rs.getLong("rp.ID"));
                chunkDataTO.setToSURL(rs.getString("rp.targetSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rp.normalized_targetSURL_StFN"));
                int uniqueID = rs.getInt("rp.targetSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setExpectedFileSize(rs.getLong("rp.expectedFileSize"));
                chunkDataTO.setProtocolList(protocols);
                chunkDataTO.setRequestToken(strToken);
                chunkDataTO.setStatus(rs.getInt("sp.statusCode"));
                list.add(chunkDataTO);
            }
            ArrayList<PtPChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTP CHUNK DAO: " + e);
            ArrayList<PtPChunkDataTO> arrayList = new ArrayList<PtPChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ReducedPtPChunkDataTO> findReduced(String reqtoken, Collection<TSURL> surls) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: findReduced - unable to get a valid connection!");
            return new ArrayList<ReducedPtPChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        boolean addInClause = surls != null && !surls.isEmpty();
        try {
            String str = "SELECT rq.fileLifetime, rq.config_FileStorageTypeID, rp.ID, rp.targetSURL, rp.normalized_targetSURL_StFN, rp.targetSURL_uniqueID, sp.statusCode FROM request_queue rq JOIN (request_Put rp, status_Put sp) ON (rp.request_queueID=rq.ID AND sp.request_PutID=rp.ID) WHERE rq.r_token=?";
            if (addInClause) {
                str = str + " AND rp.targetSURL_uniqueID IN (?)";
            }
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<ReducedPtPChunkDataTO> list = new ArrayList<ReducedPtPChunkDataTO>();
            find.setString(1, reqtoken);
            this.logWarnings(find.getWarnings());
            if (addInClause) {
                String surlUniqueIdSequence = "";
                Iterator<TSURL> iterator = surls.iterator();
                while (iterator.hasNext()) {
                    TSURL surl = iterator.next();
                    surlUniqueIdSequence = surlUniqueIdSequence + " " + surl.uniqueId() + " ";
                    if (!iterator.hasNext()) continue;
                    surlUniqueIdSequence = surlUniqueIdSequence + ",";
                }
                find.setString(2, surlUniqueIdSequence);
            }
            this.logWarnings(find.getWarnings());
            log.trace("PtP CHUNK DAO! findReduced with request token; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            ReducedPtPChunkDataTO reducedChunkDataTO = null;
            while (rs.next()) {
                reducedChunkDataTO = new ReducedPtPChunkDataTO();
                reducedChunkDataTO.setFileLifetime(rs.getInt("rq.fileLifetime"));
                reducedChunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                reducedChunkDataTO.setPrimaryKey(rs.getLong("rp.ID"));
                reducedChunkDataTO.setToSURL(rs.getString("rp.targetSURL"));
                reducedChunkDataTO.setNormalizedStFN(rs.getString("rp.normalized_targetSURL_StFN"));
                int uniqueID = rs.getInt("rp.targetSURL_uniqueID");
                if (!rs.wasNull()) {
                    reducedChunkDataTO.setSurlUniqueID(uniqueID);
                }
                reducedChunkDataTO.setStatus(rs.getInt("sp.statusCode"));
                list.add(reducedChunkDataTO);
            }
            ArrayList<ReducedPtPChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                log.error("PTP CHUNK DAO: " + e);
                ArrayList<ReducedPtPChunkDataTO> arrayList = new ArrayList<ReducedPtPChunkDataTO>();
                this.close(rs);
                this.close(find);
                return arrayList;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(find);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ReducedPtPChunkDataTO> findReduced(List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            if (!this.checkConnection()) {
                log.error("PtP CHUNK DAO: findReduced - unable to get a valid connection!");
                return new ArrayList<ReducedPtPChunkDataTO>();
            }
            PreparedStatement find = null;
            ResultSet rs = null;
            try {
                String str = "SELECT rq.fileLifetime, rq.config_FileStorageTypeID, rp.ID, rp.targetSURL, rp.normalized_targetSURL_StFN, rp.targetSURL_uniqueID, sp.statusCode FROM request_queue rq JOIN (request_Put rp, status_Put sp) ON (rp.request_queueID=rq.ID AND sp.request_PutID=rp.ID) WHERE rp.ID IN " + this.makeWhereString(ids);
                find = this.con.prepareStatement(str);
                this.logWarnings(this.con.getWarnings());
                ArrayList<ReducedPtPChunkDataTO> list = new ArrayList<ReducedPtPChunkDataTO>();
                log.trace("PtP CHUNK DAO! fetchReduced; " + find.toString());
                rs = find.executeQuery();
                this.logWarnings(find.getWarnings());
                ReducedPtPChunkDataTO reducedChunkDataTO = null;
                while (rs.next()) {
                    reducedChunkDataTO = new ReducedPtPChunkDataTO();
                    reducedChunkDataTO.setFileLifetime(rs.getInt("rq.fileLifetime"));
                    reducedChunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                    reducedChunkDataTO.setPrimaryKey(rs.getLong("rp.ID"));
                    reducedChunkDataTO.setToSURL(rs.getString("rp.targetSURL"));
                    reducedChunkDataTO.setNormalizedStFN(rs.getString("rp.normalized_targetSURL_StFN"));
                    int uniqueID = rs.getInt("rp.targetSURL_uniqueID");
                    if (!rs.wasNull()) {
                        reducedChunkDataTO.setSurlUniqueID(uniqueID);
                    }
                    reducedChunkDataTO.setStatus(rs.getInt("sp.statusCode"));
                    list.add(reducedChunkDataTO);
                }
                ArrayList<ReducedPtPChunkDataTO> arrayList = list;
                this.close(rs);
                this.close(find);
                return arrayList;
            }
            catch (SQLException e) {
                try {
                    log.error("PTP CHUNK DAO: " + e);
                    ArrayList<ReducedPtPChunkDataTO> arrayList = new ArrayList<ReducedPtPChunkDataTO>();
                    this.close(rs);
                    this.close(find);
                    return arrayList;
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.close(find);
                    throw throwable;
                }
            }
        }
        log.warn("ATTENTION in PtP CHUNK DAO! fetchReduced invoked with null or empty list of IDs!");
        return new ArrayList<ReducedPtPChunkDataTO>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalMalformedPtPChunk(PtPChunkDataTO auxTO) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: signalMalformedPtPChunk - unable to get a valid connection!");
            return;
        }
        String signalSQL = "UPDATE status_Put sp SET sp.statusCode=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE) + ", sp.explanation=? " + "WHERE sp.request_PutID=" + auxTO.primaryKey();
        PreparedStatement signal = null;
        try {
            signal = this.con.prepareStatement(signalSQL);
            this.logWarnings(this.con.getWarnings());
            signal.setString(1, "This chunk of the request is malformed!");
            this.logWarnings(signal.getWarnings());
            log.trace("PtP CHUNK DAO - signalMalformedPtPChunk method: " + signal.toString());
            signal.executeUpdate();
            this.logWarnings(signal.getWarnings());
        }
        catch (SQLException e) {
            log.error("PtPChunkDAO! Unable to signal in DB that a chunk of the request was malformed! Request: " + auxTO.toString() + "; Exception: " + e.toString());
        }
        finally {
            this.close(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int numberInSRM_SPACE_AVAILABLE(int surlUniqueID) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: numberInSRM_SPACE_AVAILABLE - unable to get a valid connection!");
            return 0;
        }
        String str = "SELECT COUNT(rp.ID) FROM status_Put sp JOIN request_Put rp ON (sp.request_PutID=rp.ID) WHERE rp.targetSURL_uniqueID=? AND sp.statusCode=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, surlUniqueID);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_SPACE_AVAILABLE));
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - numberInSRM_SPACE_AVAILABLE method: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            int numberSpaceAvailable = 0;
            if (rs.next()) {
                numberSpaceAvailable = rs.getInt(1);
            }
            int n = numberSpaceAvailable;
            this.close(rs);
            this.close(stmt);
            return n;
        }
        catch (SQLException e) {
            log.error("PtPChunkDAO! Unable to determine numberInSRM_SPACE_AVAILABLE! Returning 0! " + e);
            int n = 0;
            return n;
        }
        finally {
            this.close(rs);
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> getExpiredSRM_SPACE_AVAILABLE() {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: getExpiredSRM_SPACE_AVAILABLE - unable to get a valid connection!");
            return new ArrayList<Long>();
        }
        String idsstr = "SELECT rp.ID FROM status_Put sp JOIN (request_Put rp, request_queue rq) ON sp.request_PutID=rp.ID AND rp.request_queueID=rq.ID WHERE sp.statusCode=? AND UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(rq.timeStamp) >= rq.pinLifetime ";
        ArrayList<Long> ids = new ArrayList<Long>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(idsstr);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_SPACE_AVAILABLE));
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - transitExpiredSRM_SPACE_AVAILABLE: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            while (rs.next()) {
                ids.add(new Long(rs.getLong("rp.ID")));
            }
            this.close(rs);
            this.close(stmt);
        }
        catch (SQLException e) {
            log.error("PtPChunkDAO! Unable to select expired SRM_SPACE_AVAILABLE chunks of PtP requests.", (Throwable)e);
            ids = new ArrayList();
        }
        finally {
            this.close(rs);
            this.close(stmt);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transitSRM_SPACE_AVAILABLEtoSRM_SUCCESS(List<Long> ids) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: transitSRM_SPACE_AVAILABLEtoSRM_SUCCESS - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Put sp JOIN (request_Put rp, request_queue rq) ON sp.request_PutID=rp.ID AND rp.request_queueID=rq.ID SET sp.statusCode=? WHERE sp.statusCode=? AND rp.ID IN " + this.makeWhereString(ids);
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_SUCCESS));
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_SPACE_AVAILABLE));
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - transitSRM_SPACE_AVAILABLEtoSRM_SUCCESS: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("PtPChunkDAO! No chunk of PtP request was transited from SRM_SPACE_AVAILABLE to SRM_SUCCESS.");
            } else {
                log.info("PtPChunkDAO! " + count + " chunks of PtP requests were transited " + "from SRM_SPACE_AVAILABLE to SRM_SUCCESS.");
            }
        }
        catch (SQLException e) {
            log.error("PtPChunkDAO! Unable to transit chunks from SRM_SPACE_AVAILABLE to SRM_SUCCESS! " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transitSRM_SPACE_AVAILABLEtoSRM_ABORTED(int surlUniqueID, String surl, String explanation) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: transitSRM_SPACE_AVAILABLEtoSRM_ABORTED - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Put sp JOIN (request_Put rp, request_queue rq) ON sp.request_PutID=rp.ID AND rp.request_queueID=rq.ID SET sp.statusCode=?, sp.explanation=?, sp.transferURL=NULL WHERE sp.statusCode=? AND (rp.targetSURL_uniqueID=? OR rp.targetSURL=?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
            this.logWarnings(stmt.getWarnings());
            stmt.setString(2, explanation);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(3, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_SPACE_AVAILABLE));
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(4, surlUniqueID);
            this.logWarnings(stmt.getWarnings());
            stmt.setString(5, surl);
            this.logWarnings(stmt.getWarnings());
            log.trace("PtP CHUNK DAO - transitSRM_SPACE_AVAILABLEtoSRM_ABORTED: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count > 0) {
                log.info("PtP CHUNK DAO! " + count + " chunks were transited from " + "SRM_SPACE_AVAILABLE to SRM_ABORTED.");
            } else {
                log.trace("PtP CHUNK DAO! No chunks were transited from SRM_SPACE_AVAILABLE to SRM_ABORTED.");
            }
        }
        catch (SQLException e) {
            log.error("PtP CHUNK DAO! Unable to transitSRM_SPACE_AVAILABLEtoSRM_ABORTED! " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error("PTP CHUNK DAO! Unable to close Statement " + stmt.toString() + " - Exception: " + e);
            }
        }
    }

    private void close(ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error("PTP CHUNK DAO! Unable to close ResultSet! Exception: " + e);
            }
        }
    }

    private void logWarnings(SQLWarning w) {
        if (w != null) {
            log.debug("PTP CHUNK DAO: " + w.toString());
            while ((w = w.getNextWarning()) != null) {
                log.debug("PTP CHUNK DAO: " + w.toString());
            }
        }
    }

    private String makeWhereString(List<Long> rowids) {
        StringBuffer sb = new StringBuffer("(");
        Iterator<Long> i = rowids.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean setUpConnection() {
        boolean response = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.name, this.password);
            if (this.con == null) {
                log.error("PTP CHUNK DAO! DriverManager returned a null connection!");
            } else {
                this.logWarnings(this.con.getWarnings());
                response = this.con.isValid(0);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("PTP CHUNK DAO! Exception in setUpConenction! " + e);
        }
        catch (SQLException e) {
            log.error("PTP CHUNK DAO! Exception in setUpConnection! " + e);
        }
        return response;
    }

    private boolean checkConnection() {
        boolean response = true;
        if (this.reconnect) {
            log.debug("PTP CHUNK DAO! Reconnecting to DB! ");
            this.takeDownConnection();
            response = this.setUpConnection();
            if (response) {
                this.reconnect = false;
            }
        }
        return response;
    }

    private void takeDownConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                log.error("PTP CHUNK DAO! Exception in takeDownConnection method - could not close connection! " + e);
            }
        }
    }

    public synchronized void updateStatus(int[] surlsUniqueIDs, String[] surls, TStatusCode statusCode, String explanation) throws IllegalArgumentException {
        if (explanation == null) {
            throw new IllegalArgumentException("Unable to perform the updateStatus, invalid arguments: explanation=" + explanation);
        }
        this.doUpdateStatus(null, surlsUniqueIDs, surls, statusCode, explanation, false, true);
    }

    public synchronized void updateStatus(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surls, TStatusCode statusCode, String explanation) throws IllegalArgumentException {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || explanation == null) {
            throw new IllegalArgumentException("Unable to perform the updateStatus, invalid arguments: requestToken=" + requestToken + " explanation=" + explanation);
        }
        this.doUpdateStatus(requestToken, surlsUniqueIDs, surls, statusCode, explanation, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateStatus(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surls, TStatusCode statusCode, String explanation, boolean withRequestToken, boolean withExplaination) throws IllegalArgumentException {
        if (withRequestToken && requestToken == null || withExplaination && explanation == null) {
            throw new IllegalArgumentException("Unable to perform the updateStatus, invalid arguments: withRequestToken=" + withRequestToken + " requestToken=" + requestToken + " withExplaination=" + withExplaination + " explaination=" + explanation);
        }
        if (!this.checkConnection()) {
            log.error("PTP CHUNK DAO: updateStatus - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Put sp JOIN (request_Put rp, request_queue rq) ON sp.request_PutID=rp.ID AND rp.request_queueID=rq.ID SET sp.statusCode=? ";
        if (withExplaination) {
            str = str + " , " + this.buildExpainationSet(explanation);
        }
        str = str + " WHERE ";
        if (withRequestToken) {
            str = str + this.buildTokenWhereClause(requestToken) + " AND ";
        }
        str = str + " ( rp.targetSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rp.targetSURL IN " + this.makeSurlString(surls) + " ) ";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(statusCode));
            this.logWarnings(stmt.getWarnings());
            log.trace("PTP CHUNK DAO - updateStatus: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("PTP CHUNK DAO! No chunk of PTP request was updated to " + (Object)((Object)statusCode) + ".");
            } else {
                log.info("PTP CHUNK DAO! " + count + " chunks of PTP requests were updated to " + (Object)((Object)statusCode) + ".");
            }
        }
        catch (SQLException e) {
            log.error("PTP CHUNK DAO! Unable to updated from to " + (Object)((Object)statusCode) + " !" + e);
        }
        finally {
            this.close(stmt);
        }
    }

    public synchronized void updateStatusOnMatchingStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || explanation == null) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: requestToken=" + requestToken + " explanation=" + explanation);
        }
        this.doUpdateStatusOnMatchingStatus(requestToken, null, null, expectedStatusCode, newStatusCode, explanation, true, false, true);
    }

    public synchronized void updateStatusOnMatchingStatus(int[] surlsUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surls == null || explanation == null || surlsUniqueIDs.length == 0 || surls.length == 0 || surlsUniqueIDs.length != surls.length) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surls=" + surls + " explanation=" + explanation);
        }
        this.doUpdateStatusOnMatchingStatus(null, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode, explanation, false, true, true);
    }

    public synchronized void updateStatusOnMatchingStatus(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode) throws IllegalArgumentException {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || surlsUniqueIDs == null || surls == null || surlsUniqueIDs.length == 0 || surls.length == 0 || surlsUniqueIDs.length != surls.length) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: requestToken=" + requestToken + "surlsUniqueIDs=" + surlsUniqueIDs + " surls=" + surls);
        }
        this.doUpdateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode, null, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateStatusOnMatchingStatus(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation, boolean withRequestToken, boolean withSurls, boolean withExplanation) throws IllegalArgumentException {
        if (withRequestToken && requestToken == null || withExplanation && explanation == null || withSurls && (surlsUniqueIDs == null || surls == null)) {
            throw new IllegalArgumentException("Unable to perform the doUpdateStatusOnMatchingStatus, invalid arguments: withRequestToken=" + withRequestToken + " requestToken=" + requestToken + " withSurls=" + withSurls + " surlsUniqueIDs=" + surlsUniqueIDs + " surls=" + surls + " withExplaination=" + withExplanation + " explanation=" + explanation);
        }
        if (!this.checkConnection()) {
            log.error("PTP CHUNK DAO: updateStatusOnMatchingStatus - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Put sp JOIN (request_Put rp, request_queue rq) ON sp.request_PutID=rp.ID AND rp.request_queueID=rq.ID SET sp.statusCode=? ";
        if (withExplanation) {
            str = str + " , " + this.buildExpainationSet(explanation);
        }
        str = str + " WHERE sp.statusCode=? ";
        if (withRequestToken) {
            str = str + " AND " + this.buildTokenWhereClause(requestToken);
        }
        if (withSurls) {
            str = str + " AND " + this.buildSurlsWhereClause(surlsUniqueIDs, surls);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(newStatusCode));
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, StatusCodeConverter.getInstance().toDB(expectedStatusCode));
            this.logWarnings(stmt.getWarnings());
            log.trace("PTP CHUNK DAO - updateStatusOnMatchingStatus: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("PTP CHUNK DAO! No chunk of PTP request was updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + ".");
            } else {
                log.debug("PTP CHUNK DAO! " + count + " chunks of PTP requests were updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + ".");
            }
        }
        catch (SQLException e) {
            log.error("PTP CHUNK DAO! Unable to updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + " !" + e);
        }
        finally {
            this.close(stmt);
        }
    }

    public Collection<PtPChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray, String dn) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0 || dn == null) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray + " dn=" + dn);
        }
        return this.find(surlsUniqueIDs, surlsArray, dn, true);
    }

    public Collection<PtPChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray);
        }
        return this.find(surlsUniqueIDs, surlsArray, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection<PtPChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray, String dn, boolean withDn) throws IllegalArgumentException {
        if (withDn && dn == null || surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray + " withDn=" + withDn + " dn=" + dn);
        }
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<PtPChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            String str = "SELECT rq.ID, rq.r_token, rq.config_FileStorageTypeID, rq.config_OverwriteID, rq.timeStamp, rq.pinLifetime, rq.fileLifetime, rq.s_token, rq.client_dn, rq.proxy, rp.ID, rp.targetSURL, rp.expectedFileSize, rp.normalized_targetSURL_StFN, rp.targetSURL_uniqueID, sp.statusCode FROM request_queue rq JOIN (request_Put rp, status_Put sp) ON (rp.request_queueID=rq.ID AND sp.request_PutID=rp.ID) WHERE ( rp.targetSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rp.targetSURL IN " + this.makeSurlString(surlsArray) + " )";
            if (withDn) {
                str = str + " AND rq.client_dn='" + dn + "'";
            }
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<PtPChunkDataTO> list = new ArrayList<PtPChunkDataTO>();
            log.trace("PtP CHUNK DAO - find method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            PtPChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new PtPChunkDataTO();
                chunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                chunkDataTO.setOverwriteOption(rs.getString("rq.config_OverwriteID"));
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setPinLifetime(rs.getInt("rq.pinLifetime"));
                chunkDataTO.setFileLifetime(rs.getInt("rq.fileLifetime"));
                chunkDataTO.setSpaceToken(rs.getString("rq.s_token"));
                chunkDataTO.setClientDN(rs.getString("rq.client_dn"));
                Blob blob = rs.getBlob("rq.proxy");
                if (!rs.wasNull() && blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    chunkDataTO.setVomsAttributes(new String(bdata));
                }
                chunkDataTO.setPrimaryKey(rs.getLong("rp.ID"));
                chunkDataTO.setToSURL(rs.getString("rp.targetSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rp.normalized_targetSURL_StFN"));
                int uniqueID = rs.getInt("rp.targetSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setExpectedFileSize(rs.getLong("rp.expectedFileSize"));
                chunkDataTO.setProtocolList(this.findProtocols(rs.getLong("rq.ID")));
                chunkDataTO.setRequestToken(rs.getString("rq.r_token"));
                chunkDataTO.setStatus(rs.getInt("sp.statusCode"));
                list.add(chunkDataTO);
            }
            ArrayList<PtPChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTP CHUNK DAO: " + e);
            ArrayList<PtPChunkDataTO> arrayList = new ArrayList<PtPChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> findProtocols(long requestQueueId) {
        if (!this.checkConnection()) {
            log.error("PtP CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<String>();
        }
        String str = null;
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            str = "SELECT tp.config_ProtocolsID FROM request_TransferProtocols tp WHERE tp.request_queueID=?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<String> protocols = new ArrayList<String>();
            find.setLong(1, requestQueueId);
            this.logWarnings(find.getWarnings());
            log.trace("PtP CHUNK DAO - findProtocols method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            while (rs.next()) {
                protocols.add(rs.getString("tp.config_ProtocolsID"));
            }
            ArrayList<String> arrayList = protocols;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTP CHUNK DAO: " + e);
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    private String buildExpainationSet(String explanation) {
        return " sp.explanation='" + explanation + "' ";
    }

    private String buildTokenWhereClause(TRequestToken requestToken) {
        return " rq.r_token='" + requestToken.toString() + "' ";
    }

    private String buildSurlsWhereClause(int[] surlsUniqueIDs, String[] surls) {
        return " ( rp.targetSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rp.targetSURL IN " + this.makeSurlString(surls) + " ) ";
    }

    private String makeSURLUniqueIDWhere(int[] surlUniqueIDs) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < surlUniqueIDs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(surlUniqueIDs[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    private String makeSurlString(String[] surls) {
        StringBuffer sb = new StringBuffer("(");
        int n = surls.length;
        for (int i = 0; i < n; ++i) {
            sb.append("'");
            sb.append(surls[i]);
            sb.append("'");
            if (i >= n - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

