/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.FileLifetimeConverter;
import it.grid.storm.catalogs.FileStorageTypeConverter;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidPtPDataAttributesException;
import it.grid.storm.catalogs.InvalidPtPPersistentChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidReducedPtPChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.OverwriteModeConverter;
import it.grid.storm.catalogs.PinLifetimeConverter;
import it.grid.storm.catalogs.PtPChunkDAO;
import it.grid.storm.catalogs.PtPChunkDataTO;
import it.grid.storm.catalogs.PtPPersistentChunkData;
import it.grid.storm.catalogs.ReducedPtPChunkData;
import it.grid.storm.catalogs.ReducedPtPChunkDataTO;
import it.grid.storm.catalogs.SizeInBytesIntConverter;
import it.grid.storm.catalogs.SpaceTokenStringConverter;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.catalogs.TURLConverter;
import it.grid.storm.catalogs.TransferProtocolListConverter;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import it.grid.storm.synchcall.command.datatransfer.PutDoneCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtPChunkCatalog {
    private static final Logger log = LoggerFactory.getLogger(PtPChunkCatalog.class);
    private static final PtPChunkCatalog cat = new PtPChunkCatalog();
    private final PtPChunkDAO dao = PtPChunkDAO.getInstance();
    private final Timer transiter = new Timer();
    private final long delay = Configuration.getInstance().getTransitInitialDelay() * 1000L;
    private final long period = Configuration.getInstance().getTransitTimeInterval() * 1000L;

    private PtPChunkCatalog() {
        TimerTask transitTask = new TimerTask(){

            @Override
            public void run() {
                List<Long> ids = PtPChunkCatalog.this.getExpiredSRM_SPACE_AVAILABLE();
                if (ids.isEmpty()) {
                    return;
                }
                Collection<ReducedPtPChunkData> reduced = PtPChunkCatalog.this.lookupReducedPtPChunkData(ids.toArray(new Long[ids.size()]));
                if (reduced.isEmpty()) {
                    log.error("ATTENTION in PtP CHUNK CATALOG! Attempt to handle physical files for transited expired entries failed! No data could be translated from persitence for PtP Chunks with ID " + ids);
                }
                ArrayList<TSURL> surls = new ArrayList<TSURL>(reduced.size());
                for (ReducedPtPChunkData data : reduced) {
                    surls.add(data.toSURL());
                }
                PutDoneCommand.executePutDone(surls, null);
            }
        };
        this.transiter.scheduleAtFixedRate(transitTask, this.delay, this.period);
    }

    public static PtPChunkCatalog getInstance() {
        return cat;
    }

    public synchronized void update(PtPPersistentChunkData chunkData) {
        PtPChunkDataTO to = new PtPChunkDataTO();
        to.setPrimaryKey(chunkData.getPrimaryKey());
        to.setStatus(StatusCodeConverter.getInstance().toDB(chunkData.getStatus().getStatusCode()));
        to.setErrString(chunkData.getStatus().getExplanation());
        to.setTransferURL(TURLConverter.getInstance().toDB(chunkData.getTransferURL().toString()));
        to.setPinLifetime(PinLifetimeConverter.getInstance().toDB(chunkData.pinLifetime().value()));
        to.setFileLifetime(FileLifetimeConverter.getInstance().toDB(chunkData.fileLifetime().value()));
        to.setFileStorageType(FileStorageTypeConverter.getInstance().toDB(chunkData.fileStorageType()));
        to.setOverwriteOption(OverwriteModeConverter.getInstance().toDB(chunkData.overwriteOption()));
        to.setNormalizedStFN(chunkData.getSURL().normalizedStFN());
        to.setSurlUniqueID(new Integer(chunkData.getSURL().uniqueId()));
        to.setClientDN(chunkData.getUser().getDn());
        if (chunkData.getUser() instanceof AbstractGridUser && ((AbstractGridUser)chunkData.getUser()).hasVoms()) {
            to.setVomsAttributes(((AbstractGridUser)chunkData.getUser()).getFQANsAsString());
        }
        this.dao.update(to);
    }

    public synchronized PtPPersistentChunkData refreshStatus(PtPPersistentChunkData inputChunk) {
        PtPChunkDataTO auxTO = this.dao.refresh(inputChunk.getPrimaryKey());
        log.debug("PtP CHUNK CATALOG refreshStatus: retrieved data " + auxTO);
        if (auxTO == null) {
            log.warn("PtP CHUNK CATALOG! Empty TO found in persistence for specified request: " + inputChunk.getPrimaryKey());
            return null;
        }
        PtPPersistentChunkData data = this.makeOne(auxTO, inputChunk.getRequestToken());
        return data;
    }

    public synchronized Collection<PtPPersistentChunkData> lookup(TRequestToken rt) {
        Collection<PtPChunkDataTO> chunkTOs = this.dao.find(rt);
        log.debug("PtPChunkCatalog: retrieved data " + chunkTOs);
        return this.buildChunkDataList(chunkTOs);
    }

    private PtPPersistentChunkData makeOne(PtPChunkDataTO auxTO, TRequestToken rt) {
        TURLPrefix transferProtocols;
        StringBuffer errorSb = new StringBuffer();
        TSURL toSURL = null;
        try {
            toSURL = TSURL.makeFromStringValidate(auxTO.toSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (auxTO.normalizedStFN() != null) {
            toSURL.setNormalizedStFN(auxTO.normalizedStFN());
        }
        if (auxTO.surlUniqueID() != null) {
            toSURL.setUniqueID(auxTO.surlUniqueID());
        }
        TLifeTimeInSeconds pinLifetime = null;
        try {
            long pinLifeTime = PinLifetimeConverter.getInstance().toStoRM(auxTO.pinLifetime());
            long max = Configuration.getInstance().getPinLifetimeMaximum();
            if (pinLifeTime > max) {
                log.warn("PinLifeTime is greater than the max value allowed. Drop the value to the max = " + max + " seconds");
                pinLifeTime = max;
            }
            pinLifetime = TLifeTimeInSeconds.make(pinLifeTime, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TLifeTimeInSeconds fileLifetime = null;
        try {
            fileLifetime = TLifeTimeInSeconds.make(FileLifetimeConverter.getInstance().toStoRM(auxTO.fileLifetime()), TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        TFileStorageType fileStorageType = FileStorageTypeConverter.getInstance().toSTORM(auxTO.fileStorageType());
        if (fileStorageType == TFileStorageType.EMPTY) {
            errorSb.append("\nTFileStorageType could not be translated from its String representation! String: " + auxTO.fileStorageType());
            fileStorageType = TFileStorageType.getTFileStorageType(Configuration.getInstance().getDefaultFileStorageType());
            errorSb.append("\nUsed the default TFileStorageType as defined in StoRM config.: " + fileStorageType);
        }
        TSizeInBytes expectedFileSize = null;
        TSizeInBytes emptySize = TSizeInBytes.makeEmpty();
        long sizeTranslation = SizeInBytesIntConverter.getInstance().toStoRM(auxTO.expectedFileSize());
        if (emptySize.value() == sizeTranslation) {
            expectedFileSize = emptySize;
        } else {
            try {
                expectedFileSize = TSizeInBytes.make(auxTO.expectedFileSize(), SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        TSpaceToken spaceToken = null;
        TSpaceToken emptyToken = TSpaceToken.makeEmpty();
        String spaceTokenTranslation = SpaceTokenStringConverter.getInstance().toStoRM(auxTO.spaceToken());
        if (emptyToken.toString().equals(spaceTokenTranslation)) {
            spaceToken = emptyToken;
        } else {
            try {
                spaceToken = TSpaceToken.make(spaceTokenTranslation);
            }
            catch (InvalidTSpaceTokenAttributesException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        TOverwriteMode overwriteOption = OverwriteModeConverter.getInstance().toSTORM(auxTO.overwriteOption());
        if (overwriteOption == TOverwriteMode.EMPTY) {
            errorSb.append("\nTOverwriteMode could not be translated from its String representation! String: " + auxTO.overwriteOption());
            overwriteOption = null;
        }
        if ((transferProtocols = TransferProtocolListConverter.toSTORM(auxTO.protocolList())).size() == 0) {
            errorSb.append("\nEmpty list of TransferProtocols or could not translate TransferProtocols!");
            transferProtocols = null;
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(auxTO.status());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + auxTO.status());
        } else {
            try {
                status = new TReturnStatus(code, auxTO.errString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        GridUserInterface gridUser = null;
        try {
            gridUser = auxTO.vomsAttributes() != null && !auxTO.vomsAttributes().trim().equals("") ? GridUserManager.makeVOMSGridUser(auxTO.clientDN(), auxTO.vomsAttributesArray()) : GridUserManager.makeGridUser(auxTO.clientDN());
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected error on voms grid user creation. Contact StoRM Support : IllegalArgumentException " + e.getMessage());
        }
        TTURL transferURL = TTURL.makeEmpty();
        PtPPersistentChunkData aux = null;
        try {
            aux = new PtPPersistentChunkData(gridUser, rt, toSURL, pinLifetime, fileLifetime, fileStorageType, spaceToken, expectedFileSize, transferProtocols, overwriteOption, status, transferURL);
            aux.setPrimaryKey(auxTO.primaryKey());
        }
        catch (InvalidPtPPersistentChunkDataAttributesException e) {
            this.dao.signalMalformedPtPChunk(auxTO);
            log.warn("PtP CHUNK CATALOG! Retrieved malformed PtP chunk data from persistence. Dropping chunk from request: " + rt);
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        catch (InvalidPtPDataAttributesException e) {
            this.dao.signalMalformedPtPChunk(auxTO);
            log.warn("PtP CHUNK CATALOG! Retrieved malformed PtP chunk data from persistence. Dropping chunk from request: " + rt);
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        catch (InvalidFileTransferDataAttributesException e) {
            this.dao.signalMalformedPtPChunk(auxTO);
            log.warn("PtP CHUNK CATALOG! Retrieved malformed PtP chunk data from persistence. Dropping chunk from request: " + rt);
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        catch (InvalidSurlRequestDataAttributesException e) {
            this.dao.signalMalformedPtPChunk(auxTO);
            log.warn("PtP CHUNK CATALOG! Retrieved malformed PtP chunk data from persistence. Dropping chunk from request: " + rt);
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        return aux;
    }

    private void completeTO(ReducedPtPChunkDataTO chunkTO, ReducedPtPChunkData chunk) {
        chunkTO.setNormalizedStFN(chunk.toSURL().normalizedStFN());
        chunkTO.setSurlUniqueID(new Integer(chunk.toSURL().uniqueId()));
    }

    private ReducedPtPChunkDataTO completeTO(PtPChunkDataTO chunkTO, PtPPersistentChunkData chunk) throws InvalidReducedPtPChunkDataAttributesException {
        ReducedPtPChunkDataTO reducedChunkTO = this.reduce(chunkTO);
        this.completeTO(reducedChunkTO, this.reduce(chunk));
        return reducedChunkTO;
    }

    private ReducedPtPChunkData reduce(PtPPersistentChunkData chunk) throws InvalidReducedPtPChunkDataAttributesException {
        ReducedPtPChunkData reducedChunk = new ReducedPtPChunkData(chunk.getSURL(), chunk.getStatus(), chunk.fileStorageType(), chunk.fileLifetime());
        reducedChunk.setPrimaryKey(chunk.getPrimaryKey());
        return reducedChunk;
    }

    private ReducedPtPChunkDataTO reduce(PtPChunkDataTO chunkTO) {
        ReducedPtPChunkDataTO reducedChunkTO = new ReducedPtPChunkDataTO();
        reducedChunkTO.setPrimaryKey(chunkTO.primaryKey());
        reducedChunkTO.setToSURL(chunkTO.toSURL());
        reducedChunkTO.setNormalizedStFN(chunkTO.normalizedStFN());
        reducedChunkTO.setSurlUniqueID(chunkTO.surlUniqueID());
        reducedChunkTO.setStatus(chunkTO.status());
        reducedChunkTO.setErrString(chunkTO.errString());
        return reducedChunkTO;
    }

    private boolean isComplete(PtPChunkDataTO chunkTO) {
        return chunkTO.normalizedStFN() != null && chunkTO.surlUniqueID() != null;
    }

    private boolean isComplete(ReducedPtPChunkDataTO reducedChunkTO) {
        return reducedChunkTO.normalizedStFN() != null && reducedChunkTO.surlUniqueID() != null;
    }

    public synchronized Collection<ReducedPtPChunkData> lookupReducedPtPChunkData(TRequestToken rt) {
        return this.lookupReducedPtPChunkData(rt, new ArrayList<TSURL>(0));
    }

    public Collection<ReducedPtPChunkData> lookupReducedPtPChunkData(TRequestToken requestToken, Collection<TSURL> surls) {
        Collection<ReducedPtPChunkDataTO> reducedChunkDataTOs = this.dao.findReduced(requestToken.getValue(), surls);
        log.debug("PtP CHUNK CATALOG: retrieved data " + reducedChunkDataTOs);
        return this.buildReducedChunkDataList(reducedChunkDataTOs);
    }

    public Collection<PtPPersistentChunkData> lookupPtPChunkData(TSURL surl) {
        return this.lookupPtPChunkData(Arrays.asList(surl));
    }

    public Collection<PtPPersistentChunkData> lookupPtPChunkData(TSURL surl, GridUserInterface user) {
        return this.lookupPtPChunkData(Arrays.asList(surl), user);
    }

    private Collection<PtPPersistentChunkData> lookupPtPChunkData(List<TSURL> surls, GridUserInterface user) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<PtPChunkDataTO> chunkDataTOs = this.dao.find(surlsUniqueIDs, surlsArray, user.getDn());
        log.debug("PtP CHUNK CATALOG: retrieved data " + chunkDataTOs);
        return this.buildChunkDataList(chunkDataTOs);
    }

    public Collection<PtPPersistentChunkData> lookupPtPChunkData(List<TSURL> surls) {
        int[] surlsUniqueIDs = new int[surls.size()];
        String[] surlsArray = new String[surls.size()];
        int index = 0;
        for (TSURL tsurl : surls) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surlsArray[index] = tsurl.rawSurl();
            ++index;
        }
        Collection<PtPChunkDataTO> chunkDataTOs = this.dao.find(surlsUniqueIDs, surlsArray);
        log.debug("PtP CHUNK CATALOG: retrieved data " + chunkDataTOs);
        return this.buildChunkDataList(chunkDataTOs);
    }

    private Collection<PtPPersistentChunkData> buildChunkDataList(Collection<PtPChunkDataTO> chunkDataTOs) {
        ArrayList<PtPPersistentChunkData> list = new ArrayList<PtPPersistentChunkData>();
        for (PtPChunkDataTO chunkTO : chunkDataTOs) {
            PtPPersistentChunkData chunk = this.makeOne(chunkTO);
            if (chunk == null) continue;
            list.add(chunk);
            if (this.isComplete(chunkTO)) continue;
            try {
                this.dao.updateIncomplete(this.completeTO(chunkTO, chunk));
            }
            catch (InvalidReducedPtPChunkDataAttributesException e) {
                log.warn("PtG CHUNK CATALOG! unable to add missing informations on DB to the request: " + e);
            }
        }
        log.debug("PtPChunkCatalog: returning " + list + "\n\n");
        return list;
    }

    private PtPPersistentChunkData makeOne(PtPChunkDataTO chunkTO) {
        try {
            return this.makeOne(chunkTO, new TRequestToken(chunkTO.requestToken(), chunkTO.timeStamp()));
        }
        catch (InvalidTRequestTokenAttributesException e) {
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException in TRequestToken: " + e);
        }
    }

    private Collection<ReducedPtPChunkData> buildReducedChunkDataList(Collection<ReducedPtPChunkDataTO> chunkDataTOCollection) {
        ArrayList<ReducedPtPChunkData> list = new ArrayList<ReducedPtPChunkData>();
        for (ReducedPtPChunkDataTO reducedChunkDataTO : chunkDataTOCollection) {
            ReducedPtPChunkData reducedChunkData = this.makeOneReduced(reducedChunkDataTO);
            if (reducedChunkData == null) continue;
            list.add(reducedChunkData);
            if (this.isComplete(reducedChunkDataTO)) continue;
            this.completeTO(reducedChunkDataTO, reducedChunkData);
            this.dao.updateIncomplete(reducedChunkDataTO);
        }
        log.debug("PtP CHUNK CATALOG: returning " + list);
        return list;
    }

    public synchronized Collection<ReducedPtPChunkData> lookupReducedPtPChunkData(Long[] volids) {
        Collection<ReducedPtPChunkDataTO> reducedChunkDataTOs = this.dao.findReduced(Arrays.asList(volids));
        log.debug("PtP CHUNK CATALOG: fetched data " + reducedChunkDataTOs);
        return this.buildReducedChunkDataList(reducedChunkDataTOs);
    }

    private ReducedPtPChunkData makeOneReduced(ReducedPtPChunkDataTO reducedChunkDataTO) {
        StringBuffer errorSb = new StringBuffer();
        TSURL toSURL = null;
        try {
            toSURL = TSURL.makeFromStringValidate(reducedChunkDataTO.toSURL());
        }
        catch (InvalidTSURLAttributesException e) {
            errorSb.append(e);
        }
        if (reducedChunkDataTO.normalizedStFN() != null) {
            toSURL.setNormalizedStFN(reducedChunkDataTO.normalizedStFN());
        }
        if (reducedChunkDataTO.surlUniqueID() != null) {
            toSURL.setUniqueID(reducedChunkDataTO.surlUniqueID());
        }
        TReturnStatus status = null;
        TStatusCode code = StatusCodeConverter.getInstance().toSTORM(reducedChunkDataTO.status());
        if (code == TStatusCode.EMPTY) {
            errorSb.append("\nRetrieved StatusCode was not recognised: " + reducedChunkDataTO.status());
        } else {
            try {
                status = new TReturnStatus(code, reducedChunkDataTO.errString());
            }
            catch (InvalidTReturnStatusAttributeException e) {
                errorSb.append("\n");
                errorSb.append(e);
            }
        }
        TFileStorageType fileStorageType = FileStorageTypeConverter.getInstance().toSTORM(reducedChunkDataTO.fileStorageType());
        if (fileStorageType == TFileStorageType.EMPTY) {
            errorSb.append("\nTFileStorageType could not be translated from its String representation! String: " + reducedChunkDataTO.fileStorageType());
            fileStorageType = TFileStorageType.getTFileStorageType(Configuration.getInstance().getDefaultFileStorageType());
            errorSb.append("\nUsed the default TFileStorageType as defined in StoRM config.: " + fileStorageType);
        }
        TLifeTimeInSeconds fileLifetime = null;
        try {
            fileLifetime = TLifeTimeInSeconds.make(FileLifetimeConverter.getInstance().toStoRM(reducedChunkDataTO.fileLifetime()), TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            errorSb.append("\n");
            errorSb.append(e);
        }
        ReducedPtPChunkData aux = null;
        try {
            aux = new ReducedPtPChunkData(toSURL, status, fileStorageType, fileLifetime);
            aux.setPrimaryKey(reducedChunkDataTO.primaryKey());
        }
        catch (InvalidReducedPtPChunkDataAttributesException e) {
            log.warn("PtP CHUNK CATALOG! Retrieved malformed Reduced PtP chunk data from persistence: dropping reduced chunk...");
            log.warn(e.getMessage(), (Throwable)e);
            log.warn(errorSb.toString());
        }
        return aux;
    }

    public synchronized boolean isSRM_SPACE_AVAILABLE(TSURL surl) {
        return this.dao.numberInSRM_SPACE_AVAILABLE(surl.uniqueId()) > 0;
    }

    public synchronized List<Long> getExpiredSRM_SPACE_AVAILABLE() {
        return this.dao.getExpiredSRM_SPACE_AVAILABLE();
    }

    public synchronized void transitSRM_SPACE_AVAILABLEtoSRM_SUCCESS(TRequestToken token, List<TSURL> surls) {
        if (token == null || surls == null || surls.size() == 0) {
            return;
        }
        Collection<ReducedPtPChunkDataTO> tos = this.dao.findReduced(token.getValue(), null);
        LinkedList<Long> primaryKeys = new LinkedList<Long>();
        block0: for (ReducedPtPChunkDataTO to : tos) {
            for (TSURL surl : surls) {
                if (!to.toSURL().equals(surl)) continue;
                primaryKeys.add(to.primaryKey());
                continue block0;
            }
        }
        this.dao.transitSRM_SPACE_AVAILABLEtoSRM_SUCCESS(primaryKeys);
    }

    public synchronized void transitSRM_SPACE_AVAILABLEtoSRM_ABORTED(TSURL surl, String explanation) {
        if (surl == null) {
            log.error("ATTENTION in PtP CHUNK CATALOG! Attempt to invoke transitSRM_SPACE_AVAILABLEtoSRM_ABORTED with a null SURL!");
            return;
        }
        if (explanation == null) {
            explanation = "";
        }
        this.dao.transitSRM_SPACE_AVAILABLEtoSRM_ABORTED(surl.uniqueId(), surl.toString(), explanation);
    }

    public void updateStatus(TRequestToken requestToken, TSURL surl, TStatusCode statusCode, String explanation) {
        this.dao.updateStatus(requestToken, new int[]{surl.uniqueId()}, new String[]{surl.rawSurl()}, statusCode, explanation);
    }

    public void updateStatus(TSURL surl, TStatusCode statusCode, String explanation) {
        this.dao.updateStatus(new int[]{surl.uniqueId()}, new String[]{surl.rawSurl()}, statusCode, explanation);
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        this.dao.updateStatusOnMatchingStatus(requestToken, expectedStatusCode, newStatusCode, explanation);
    }

    public void updateFromPreviousStatus(TRequestToken requestToken, List<TSURL> surlList, TStatusCode expectedStatusCode, TStatusCode newStatusCode) {
        int[] surlsUniqueIDs = new int[surlList.size()];
        String[] surls = new String[surlList.size()];
        int index = 0;
        for (TSURL tsurl : surlList) {
            surlsUniqueIDs[index] = tsurl.uniqueId();
            surls[index] = tsurl.rawSurl();
            ++index;
        }
        this.dao.updateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode);
    }

    public void updateFromPreviousStatus(TSURL surl, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        this.dao.updateStatusOnMatchingStatus(new int[]{surl.uniqueId()}, new String[]{surl.rawSurl()}, expectedStatusCode, newStatusCode, explanation);
    }
}

