/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.IdentityPtGData;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidPtGDataAttributesException;
import it.grid.storm.catalogs.InvalidPtGPersistentChunkDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PersistentChunkData;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtGPersistentChunkData
extends IdentityPtGData
implements PersistentChunkData {
    private static final Logger log = LoggerFactory.getLogger(PtGPersistentChunkData.class);
    private long primaryKey = -1L;
    private TRequestToken requestToken;

    public PtGPersistentChunkData(GridUserInterface auth, TRequestToken requestToken, TSURL fromSURL, TLifeTimeInSeconds lifeTime, TDirOption dirOption, TURLPrefix desiredProtocols, TSizeInBytes fileSize, TReturnStatus status, TTURL transferURL) throws InvalidPtGDataAttributesException, InvalidPtGDataAttributesException, InvalidFileTransferDataAttributesException, InvalidSurlRequestDataAttributesException {
        super(auth, fromSURL, lifeTime, dirOption, desiredProtocols, fileSize, status, transferURL);
        if (requestToken == null) {
            throw new InvalidPtGPersistentChunkDataAttributesException(requestToken, fromSURL, lifeTime, dirOption, desiredProtocols, fileSize, status, transferURL);
        }
        this.requestToken = requestToken;
    }

    @Override
    public long getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(long l) {
        this.primaryKey = l;
    }

    @Override
    public TRequestToken getRequestToken() {
        return this.requestToken;
    }

    @Override
    public void changeStatusSRM_FILE_PINNED(String explanation) {
        this.setStatus(TStatusCode.SRM_FILE_PINNED, explanation);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.primaryKey ^ this.primaryKey >>> 32);
        result = 31 * result + (this.requestToken == null ? 0 : this.requestToken.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PtGPersistentChunkData other = (PtGPersistentChunkData)obj;
        if (this.primaryKey != other.primaryKey) {
            return false;
        }
        return !(this.requestToken == null ? other.requestToken != null : !this.requestToken.equals(other.requestToken));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PtGPersistentChunkData [primaryKey=");
        builder.append(this.primaryKey);
        builder.append(", requestToken=");
        builder.append(this.requestToken);
        builder.append(", pinLifeTime=");
        builder.append(this.pinLifeTime);
        builder.append(", dirOption=");
        builder.append(this.dirOption);
        builder.append(", fileSize=");
        builder.append(this.fileSize);
        builder.append(", transferProtocols=");
        builder.append(this.transferProtocols);
        builder.append(", SURL=");
        builder.append(this.SURL);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", transferURL=");
        builder.append(this.transferURL);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public long getIdentifier() {
        return this.getPrimaryKey();
    }
}

