/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.PtGChunkDataTO;
import it.grid.storm.catalogs.PtPChunkDAO;
import it.grid.storm.catalogs.ReducedPtGChunkDataTO;
import it.grid.storm.catalogs.RequestTypeConverter;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.config.Configuration;
import it.grid.storm.ea.StormEA;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtGChunkDAO {
    private static final Logger log = LoggerFactory.getLogger(PtGChunkDAO.class);
    private final String driver = Configuration.getInstance().getDBDriver();
    private final String url = Configuration.getInstance().getDBURL();
    private final String password = Configuration.getInstance().getDBPassword();
    private final String name = Configuration.getInstance().getDBUserName();
    private Connection con = null;
    private boolean reconnect = false;
    private static final PtGChunkDAO dao = new PtGChunkDAO();
    private Timer clock = null;
    private TimerTask clockTask = null;
    private long period = Configuration.getInstance().getDBReconnectPeriod() * 1000L;
    private long delay = Configuration.getInstance().getDBReconnectDelay() * 1000L;

    private PtGChunkDAO() {
        this.setUpConnection();
        this.clock = new Timer();
        this.clockTask = new TimerTask(){

            @Override
            public void run() {
                PtGChunkDAO.this.reconnect = true;
            }
        };
        this.clock.scheduleAtFixedRate(this.clockTask, this.delay, this.period);
    }

    public static PtGChunkDAO getInstance() {
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void addChild(PtGChunkDataTO to) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: addChild - unable to get a valid connection!");
            return;
        }
        String str = null;
        PreparedStatement id = null;
        ResultSet rsid = null;
        try {
            this.con.setAutoCommit(false);
            this.logWarnings(this.con.getWarnings());
            str = "SELECT rq.ID FROM request_queue rq WHERE rq.r_token=?";
            id = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            id.setString(1, to.requestToken());
            this.logWarnings(id.getWarnings());
            log.debug("PTG CHUNK DAO: addChild; " + id.toString());
            rsid = id.executeQuery();
            this.logWarnings(id.getWarnings());
            int request_id = this.extractID(rsid);
            int id_s = this.fillPtGTables(to, request_id);
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            to.setPrimaryKey(id_s);
            this.close(rsid);
            this.close(id);
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: unable to complete addChild! PtGChunkDataTO: " + to + "; exception received:" + e);
            this.rollback(this.con);
            this.close(rsid);
            this.close(id);
        }
        catch (Exception e2) {
            log.error("PTG CHUNK DAO: unable to complete addChild! PtGChunkDataTO: " + to + "; exception received:" + e2);
            this.rollback(this.con);
            this.close(rsid);
            this.close(id);
            {
                catch (Throwable throwable) {
                    this.close(rsid);
                    this.close(id);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void addNew(PtGChunkDataTO to, String client_dn) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: addNew - unable to get a valid connection!");
            return;
        }
        String str = null;
        ResultSet rs_new = null;
        PreparedStatement addNew = null;
        PreparedStatement addProtocols = null;
        try {
            this.con.setAutoCommit(false);
            this.logWarnings(this.con.getWarnings());
            str = "INSERT INTO request_queue (config_RequestTypeID,client_dn,pinLifetime,status,errstring,r_token,nbreqfiles,timeStamp) VALUES (?,?,?,?,?,?,?,?)";
            addNew = this.con.prepareStatement(str, 1);
            this.logWarnings(this.con.getWarnings());
            addNew.setString(1, RequestTypeConverter.getInstance().toDB(TRequestType.PREPARE_TO_GET));
            this.logWarnings(addNew.getWarnings());
            addNew.setString(2, client_dn);
            this.logWarnings(addNew.getWarnings());
            addNew.setInt(3, to.lifeTime());
            this.logWarnings(addNew.getWarnings());
            addNew.setInt(4, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_INPROGRESS));
            this.logWarnings(addNew.getWarnings());
            addNew.setString(5, "New PtG Request resulting from srmCopy invocation.");
            this.logWarnings(addNew.getWarnings());
            addNew.setString(6, to.requestToken());
            this.logWarnings(addNew.getWarnings());
            addNew.setInt(7, 1);
            this.logWarnings(addNew.getWarnings());
            addNew.setTimestamp(8, new Timestamp(new Date().getTime()));
            this.logWarnings(addNew.getWarnings());
            log.trace("PTG CHUNK DAO: addNew; " + addNew.toString());
            addNew.execute();
            this.logWarnings(addNew.getWarnings());
            rs_new = addNew.getGeneratedKeys();
            int id_new = this.extractID(rs_new);
            str = "INSERT INTO request_TransferProtocols (request_queueID,config_ProtocolsID) VALUES (?,?)";
            addProtocols = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            Iterator<String> i = to.protocolList().iterator();
            while (i.hasNext()) {
                addProtocols.setInt(1, id_new);
                this.logWarnings(addProtocols.getWarnings());
                addProtocols.setString(2, i.next());
                this.logWarnings(addProtocols.getWarnings());
                log.trace("PTG CHUNK DAO: addNew; " + addProtocols.toString());
                addProtocols.execute();
                this.logWarnings(addProtocols.getWarnings());
            }
            int id_s = this.fillPtGTables(to, id_new);
            this.con.commit();
            this.logWarnings(this.con.getWarnings());
            this.con.setAutoCommit(true);
            this.logWarnings(this.con.getWarnings());
            to.setPrimaryKey(id_s);
            this.close(rs_new);
            this.close(addNew);
            this.close(addProtocols);
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: Rolling back! Unable to complete addNew! PtGChunkDataTO: " + to + "; exception received:" + e);
            this.rollback(this.con);
            this.close(rs_new);
            this.close(addNew);
            this.close(addProtocols);
        }
        catch (Exception e2) {
            log.error("PTG CHUNK DAO: unable to complete addNew! PtGChunkDataTO: " + to + "; exception received:" + e2);
            this.rollback(this.con);
            this.close(rs_new);
            this.close(addNew);
            this.close(addProtocols);
            {
                catch (Throwable throwable) {
                    this.close(rs_new);
                    this.close(addNew);
                    this.close(addProtocols);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int fillPtGTables(PtGChunkDataTO to, int requestQueueID) throws SQLException, Exception {
        String str = null;
        ResultSet rs_do = null;
        ResultSet rs_g = null;
        ResultSet rs_s = null;
        PreparedStatement addDirOption = null;
        PreparedStatement addGet = null;
        PreparedStatement addChild = null;
        try {
            str = "INSERT INTO request_DirOption (isSourceADirectory,allLevelRecursive,numOfLevels) VALUES (?,?,?)";
            addDirOption = this.con.prepareStatement(str, 1);
            this.logWarnings(this.con.getWarnings());
            addDirOption.setBoolean(1, to.dirOption());
            this.logWarnings(addDirOption.getWarnings());
            addDirOption.setBoolean(2, to.allLevelRecursive());
            this.logWarnings(addDirOption.getWarnings());
            addDirOption.setInt(3, to.numLevel());
            this.logWarnings(addDirOption.getWarnings());
            log.trace("PTG CHUNK DAO: addNew; " + addDirOption.toString());
            addDirOption.execute();
            this.logWarnings(addDirOption.getWarnings());
            rs_do = addDirOption.getGeneratedKeys();
            int id_do = this.extractID(rs_do);
            str = "INSERT INTO request_Get (request_DirOptionID,request_queueID,sourceSURL,normalized_sourceSURL_StFN,sourceSURL_uniqueID) VALUES (?,?,?,?,?)";
            addGet = this.con.prepareStatement(str, 1);
            this.logWarnings(this.con.getWarnings());
            addGet.setInt(1, id_do);
            this.logWarnings(addGet.getWarnings());
            addGet.setInt(2, requestQueueID);
            this.logWarnings(addGet.getWarnings());
            addGet.setString(3, to.fromSURL());
            this.logWarnings(addGet.getWarnings());
            addGet.setString(4, to.normalizedStFN());
            this.logWarnings(addGet.getWarnings());
            addGet.setInt(5, to.surlUniqueID());
            this.logWarnings(addGet.getWarnings());
            log.trace("PTG CHUNK DAO: addNew; " + addGet.toString());
            addGet.execute();
            this.logWarnings(addGet.getWarnings());
            rs_g = addGet.getGeneratedKeys();
            int id_g = this.extractID(rs_g);
            str = "INSERT INTO status_Get (request_GetID,statusCode,explanation) VALUES (?,?,?)";
            addChild = this.con.prepareStatement(str, 1);
            this.logWarnings(this.con.getWarnings());
            addChild.setInt(1, id_g);
            this.logWarnings(addChild.getWarnings());
            addChild.setInt(2, to.status());
            this.logWarnings(addChild.getWarnings());
            addChild.setString(3, to.errString());
            this.logWarnings(addChild.getWarnings());
            log.trace("PTG CHUNK DAO: addNew; " + addChild.toString());
            addChild.execute();
            this.logWarnings(addChild.getWarnings());
            int n = id_g;
            this.close(rs_do);
            this.close(rs_g);
            this.close(rs_s);
            this.close(addDirOption);
            this.close(addGet);
            this.close(addChild);
            return n;
        }
        catch (Throwable throwable) {
            this.close(rs_do);
            this.close(rs_g);
            this.close(rs_s);
            this.close(addDirOption);
            this.close(addGet);
            this.close(addChild);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(PtGChunkDataTO to) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: update - unable to get a valid connection!");
            return;
        }
        PreparedStatement updateFileReq = null;
        try {
            updateFileReq = this.con.prepareStatement("UPDATE request_queue rq JOIN (status_Get sg, request_Get rg) ON (rq.ID=rg.request_queueID AND sg.request_GetID=rg.ID) SET sg.fileSize=?, sg.transferURL=?, sg.statusCode=?, sg.explanation=?, rq.pinLifetime=?, rg.normalized_sourceSURL_StFN=?, rg.sourceSURL_uniqueID=? WHERE rg.ID=?");
            this.logWarnings(this.con.getWarnings());
            updateFileReq.setLong(1, to.fileSize());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(2, to.turl());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setInt(3, to.status());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(4, to.errString());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setInt(5, to.lifeTime());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(6, to.normalizedStFN());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setInt(7, to.surlUniqueID());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setLong(8, to.primaryKey());
            this.logWarnings(updateFileReq.getWarnings());
            log.trace("PTG CHUNK DAO: update method; " + updateFileReq.toString());
            updateFileReq.executeUpdate();
            this.logWarnings(updateFileReq.getWarnings());
        }
        catch (SQLException e) {
            log.error("PtG CHUNK DAO: Unable to complete update! " + e);
        }
        finally {
            this.close(updateFileReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateIncomplete(ReducedPtGChunkDataTO chunkTO) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: updateIncomplete - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE request_Get rg SET rg.normalized_sourceSURL_StFN=?, rg.sourceSURL_uniqueID=? WHERE rg.ID=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, chunkTO.normalizedStFN());
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, chunkTO.surlUniqueID());
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(3, chunkTO.primaryKey());
            this.logWarnings(stmt.getWarnings());
            log.trace("PtG CHUNK DAO - update incomplete: " + stmt.toString());
            stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
        }
        catch (SQLException e) {
            log.error("PtG CHUNK DAO: Unable to complete update incomplete! " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PtGChunkDataTO refresh(long primary_key) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: refresh - unable to get a valid connection!");
            return null;
        }
        String queryString = null;
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            queryString = "SELECT  sg.statusCode, sg.transferURL FROM status_Get sg WHERE sg.request_GetID=?";
            find = this.con.prepareStatement(queryString);
            this.logWarnings(this.con.getWarnings());
            find.setLong(1, primary_key);
            this.logWarnings(find.getWarnings());
            log.trace("PTG CHUNK DAO: refresh status method; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            PtGChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new PtGChunkDataTO();
                chunkDataTO.setStatus(rs.getInt("sg.statusCode"));
                chunkDataTO.setTurl(rs.getString("sg.transferURL"));
            }
            PtGChunkDataTO ptGChunkDataTO = chunkDataTO;
            this.close(rs);
            this.close(find);
            return ptGChunkDataTO;
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: " + e);
            PtGChunkDataTO ptGChunkDataTO = null;
            return ptGChunkDataTO;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<PtGChunkDataTO> find(TRequestToken requestToken) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<PtGChunkDataTO>();
        }
        String strToken = requestToken.toString();
        String str = null;
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            str = "SELECT tp.config_ProtocolsID FROM request_TransferProtocols tp JOIN request_queue rq ON tp.request_queueID=rq.ID WHERE rq.r_token=?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<String> protocols = new ArrayList<String>();
            find.setString(1, strToken);
            this.logWarnings(find.getWarnings());
            log.trace("PTG CHUNK DAO: find method; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            while (rs.next()) {
                protocols.add(rs.getString("tp.config_ProtocolsID"));
            }
            this.close(rs);
            this.close(find);
            str = "SELECT sg.statusCode, rq.pinLifetime, rg.ID, rq.timeStamp, rq.client_dn, rq.proxy, rg.sourceSURL, rg.normalized_sourceSURL_StFN, rg.sourceSURL_uniqueID, d.isSourceADirectory, d.allLevelRecursive, d.numOfLevels FROM request_queue rq JOIN (request_Get rg, status_Get sg) ON (rg.request_queueID=rq.ID AND sg.request_GetID=rg.ID) LEFT JOIN request_DirOption d ON rg.request_DirOptionID=d.ID WHERE rq.r_token=? AND sg.statusCode<>?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<PtGChunkDataTO> list = new ArrayList<PtGChunkDataTO>();
            find.setString(1, strToken);
            this.logWarnings(find.getWarnings());
            find.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
            this.logWarnings(find.getWarnings());
            log.trace("PTG CHUNK DAO: find method; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            while (rs.next()) {
                PtGChunkDataTO chunkDataTO = new PtGChunkDataTO();
                chunkDataTO.setStatus(rs.getInt("sg.statusCode"));
                chunkDataTO.setRequestToken(strToken);
                chunkDataTO.setPrimaryKey(rs.getLong("rg.ID"));
                chunkDataTO.setFromSURL(rs.getString("rg.sourceSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rg.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rg.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setClientDN(rs.getString("rq.client_dn"));
                Blob blob = rs.getBlob("rq.proxy");
                if (!rs.wasNull() && blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    chunkDataTO.setVomsAttributes(new String(bdata));
                }
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setLifeTime(rs.getInt("rq.pinLifetime"));
                chunkDataTO.setDirOption(rs.getBoolean("d.isSourceADirectory"));
                chunkDataTO.setAllLevelRecursive(rs.getBoolean("d.allLevelRecursive"));
                chunkDataTO.setNumLevel(rs.getInt("d.numOfLevels"));
                chunkDataTO.setProtocolList(protocols);
                list.add(chunkDataTO);
            }
            ArrayList<PtGChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: " + e);
            ArrayList<PtGChunkDataTO> arrayList = new ArrayList<PtGChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ReducedPtGChunkDataTO> findReduced(String reqtoken) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: findReduced - unable to get a valid connection!");
            return new ArrayList<ReducedPtGChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            String str = "SELECT sg.statusCode, rg.ID, rg.sourceSURL, rg.normalized_sourceSURL_StFN, rg.sourceSURL_uniqueID FROM request_queue rq JOIN (request_Get rg, status_Get sg) ON (rg.request_queueID=rq.ID AND sg.request_GetID=rg.ID) WHERE rq.r_token=?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<ReducedPtGChunkDataTO> list = new ArrayList<ReducedPtGChunkDataTO>();
            find.setString(1, reqtoken);
            this.logWarnings(find.getWarnings());
            log.trace("PtG CHUNK DAO! findReduced with request token; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            ReducedPtGChunkDataTO reducedChunkDataTO = null;
            while (rs.next()) {
                reducedChunkDataTO = new ReducedPtGChunkDataTO();
                reducedChunkDataTO.setStatus(rs.getInt("sg.statusCode"));
                reducedChunkDataTO.setPrimaryKey(rs.getLong("rg.ID"));
                reducedChunkDataTO.setFromSURL(rs.getString("rg.sourceSURL"));
                reducedChunkDataTO.setNormalizedStFN(rs.getString("rg.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rg.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    reducedChunkDataTO.setSurlUniqueID(uniqueID);
                }
                list.add(reducedChunkDataTO);
            }
            ArrayList<ReducedPtGChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: " + e);
            ArrayList<ReducedPtGChunkDataTO> arrayList = new ArrayList<ReducedPtGChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ReducedPtGChunkDataTO> findReduced(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surlsArray) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: findReduced - unable to get a valid connection!");
            return new ArrayList<ReducedPtGChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            String str = "SELECT sg.statusCode, rg.ID, rg.sourceSURL, rg.normalized_sourceSURL_StFN, rg.sourceSURL_uniqueID FROM request_queue rq JOIN (request_Get rg, status_Get sg) ON (rg.request_queueID=rq.ID AND sg.request_GetID=rg.ID) WHERE rq.r_token=? AND ( rg.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rg.sourceSURL IN " + this.makeSurlString(surlsArray) + " ) ";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<ReducedPtGChunkDataTO> list = new ArrayList<ReducedPtGChunkDataTO>();
            find.setString(1, requestToken.getValue());
            this.logWarnings(find.getWarnings());
            log.trace("PtG CHUNK DAO! findReduced with griduser+surlarray; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            ReducedPtGChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new ReducedPtGChunkDataTO();
                chunkDataTO.setStatus(rs.getInt("sg.statusCode"));
                chunkDataTO.setPrimaryKey(rs.getLong("rg.ID"));
                chunkDataTO.setFromSURL(rs.getString("rg.sourceSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rg.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rg.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(uniqueID);
                }
                list.add(chunkDataTO);
            }
            ArrayList<ReducedPtGChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: " + e);
            ArrayList<ReducedPtGChunkDataTO> arrayList = new ArrayList<ReducedPtGChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<ReducedPtGChunkDataTO> findReduced(String griduser, int[] surlUniqueIDs, String[] surls) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: findReduced - unable to get a valid connection!");
            return new ArrayList<ReducedPtGChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            String str = "SELECT sg.statusCode, rg.ID, rg.sourceSURL, rg.normalized_sourceSURL_StFN, rg.sourceSURL_uniqueID FROM request_queue rq JOIN (request_Get rg, status_Get sg) ON (rg.request_queueID=rq.ID AND sg.request_GetID=rg.ID) WHERE rq.client_dn=? AND ( rg.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlUniqueIDs) + " OR rg.sourceSURL IN " + this.makeSurlString(surls) + " ) ";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<ReducedPtGChunkDataTO> list = new ArrayList<ReducedPtGChunkDataTO>();
            find.setString(1, griduser);
            this.logWarnings(find.getWarnings());
            log.trace("PtG CHUNK DAO! findReduced with griduser+surlarray; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            ReducedPtGChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new ReducedPtGChunkDataTO();
                chunkDataTO.setStatus(rs.getInt("sg.statusCode"));
                chunkDataTO.setPrimaryKey(rs.getLong("rg.ID"));
                chunkDataTO.setFromSURL(rs.getString("rg.sourceSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rg.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rg.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(uniqueID);
                }
                list.add(chunkDataTO);
            }
            ArrayList<ReducedPtGChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: " + e);
            ArrayList<ReducedPtGChunkDataTO> arrayList = new ArrayList<ReducedPtGChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalMalformedPtGChunk(PtGChunkDataTO auxTO) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: signalMalformedPtGChunk - unable to get a valid connection!");
            return;
        }
        String signalSQL = "UPDATE status_Get SET statusCode=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE) + ", explanation=? WHERE request_GetID=" + auxTO.primaryKey();
        PreparedStatement signal = null;
        try {
            signal = this.con.prepareStatement(signalSQL);
            this.logWarnings(this.con.getWarnings());
            signal.setString(1, "Request is malformed!");
            this.logWarnings(signal.getWarnings());
            log.trace("PTG CHUNK DAO: signalMalformed; " + signal.toString());
            signal.executeUpdate();
            this.logWarnings(signal.getWarnings());
        }
        catch (SQLException e) {
            log.error("PtGChunkDAO! Unable to signal in DB that the request was malformed! Request: " + auxTO.toString() + "; Exception: " + e.toString());
        }
        finally {
            this.close(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int numberInSRM_FILE_PINNED(int surlUniqueID) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: numberInSRM_FILE_PINNED - unable to get a valid connection!");
            return 0;
        }
        String str = "SELECT COUNT(rg.ID) FROM status_Get sg JOIN request_Get rg ON (sg.request_GetID=rg.ID) WHERE rg.sourceSURL_uniqueID=? AND sg.statusCode=?";
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            find.setInt(1, surlUniqueID);
            this.logWarnings(find.getWarnings());
            find.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FILE_PINNED));
            this.logWarnings(find.getWarnings());
            log.trace("PtG CHUNK DAO - numberInSRM_FILE_PINNED method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            int numberFilePinned = 0;
            if (rs.next()) {
                numberFilePinned = rs.getInt(1);
            }
            int n = numberFilePinned;
            this.close(rs);
            this.close(find);
            return n;
        }
        catch (SQLException e) {
            log.error("PtG CHUNK DAO! Unable to determine numberInSRM_FILE_PINNED! Returning 0! " + e);
            int n = 0;
            return n;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<TSURL> transitExpiredSRM_FILE_PINNED() {
        Serializable uniqueID;
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: transitExpiredSRM_FILE_PINNED - unable to get a valid connection!");
            return new ArrayList<TSURL>();
        }
        HashMap<Object, Integer> expiredSurlMap = new HashMap<Object, Integer>();
        String str = null;
        Statement statement = null;
        try {
            Object sourceSURL;
            this.con.setAutoCommit(false);
            statement = this.con.createStatement();
            str = "SELECT rg.sourceSURL , rg.sourceSURL_uniqueID FROM request_Get rg JOIN (status_Get sg, request_queue rq) ON sg.request_GetID=rg.ID AND rg.request_queueID=rq.ID WHERE sg.statusCode=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FILE_PINNED) + " AND UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(rq.timeStamp) >= rq.pinLifetime ";
            ResultSet res = statement.executeQuery(str);
            this.logWarnings(statement.getWarnings());
            while (res.next()) {
                sourceSURL = res.getString("rg.sourceSURL");
                uniqueID = new Integer(res.getInt("rg.sourceSURL_uniqueID"));
                if (res.wasNull()) {
                    try {
                        TSURL tsurl = TSURL.makeFromStringWellFormed((String)sourceSURL);
                        uniqueID = tsurl.uniqueId();
                    }
                    catch (InvalidTSURLAttributesException e) {
                        log.warn("PtGChunkDAO! unable to build the TSURL from " + (String)sourceSURL + " : InvalidTSURLAttributesException " + e);
                    }
                }
                expiredSurlMap.put(sourceSURL, (Integer)uniqueID);
            }
            if (expiredSurlMap.isEmpty()) {
                this.commit(this.con);
                log.trace("PtGChunkDAO! No chunk of PtG request was transited from SRM_FILE_PINNED to SRM_RELEASED.");
                sourceSURL = new ArrayList();
                this.close(statement);
                return sourceSURL;
            }
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                log.error("PtGChunkDAO! SQLException." + e);
                this.rollback(this.con);
                ArrayList<TSURL> sourceSURL = new ArrayList<TSURL>();
                this.close(statement);
                return sourceSURL;
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = null;
        try {
            str = "UPDATE status_Get sg JOIN (request_Get rg, request_queue rq) ON sg.request_GetID=rg.ID AND rg.request_queueID=rq.ID SET sg.statusCode=? WHERE sg.statusCode=? AND UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(rq.timeStamp) >= rq.pinLifetime ";
            preparedStatement = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            preparedStatement.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_RELEASED));
            this.logWarnings(preparedStatement.getWarnings());
            preparedStatement.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FILE_PINNED));
            this.logWarnings(preparedStatement.getWarnings());
            log.trace("PtG CHUNK DAO - transitExpiredSRM_FILE_PINNED method: " + preparedStatement.toString());
            int count = preparedStatement.executeUpdate();
            this.logWarnings(preparedStatement.getWarnings());
            if (count == 0) {
                log.trace("PtGChunkDAO! No chunk of PtG request was transited from SRM_FILE_PINNED to SRM_RELEASED.");
            } else {
                log.info("PtGChunkDAO! " + count + " chunks of PtG requests were transited from" + " SRM_FILE_PINNED to SRM_RELEASED.");
            }
            this.close(preparedStatement);
        }
        catch (SQLException e) {
            try {
                log.error("PtGChunkDAO! Unable to transit expired SRM_FILE_PINNED chunks of PtG requests, to SRM_RELEASED! " + e);
                this.rollback(this.con);
                uniqueID = new ArrayList();
                this.close(preparedStatement);
                return uniqueID;
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                throw throwable;
            }
        }
        HashSet<Integer> pinnedSurlSet = new HashSet<Integer>();
        try {
            TSURL tsurl;
            Integer uniqueID2;
            String sourceSURL;
            statement = this.con.createStatement();
            str = "SELECT rg.sourceSURL , rg.sourceSURL_uniqueID FROM request_Get rg JOIN (status_Get sg, request_queue rq) ON sg.request_GetID=rg.ID AND rg.request_queueID=rq.ID WHERE sg.statusCode=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FILE_PINNED) + " AND UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(rq.timeStamp) < rq.pinLifetime ";
            ResultSet res = statement.executeQuery(str);
            this.logWarnings(statement.getWarnings());
            while (res.next()) {
                sourceSURL = res.getString("rg.sourceSURL");
                uniqueID2 = new Integer(res.getInt("rg.sourceSURL_uniqueID"));
                if (res.wasNull()) {
                    try {
                        tsurl = TSURL.makeFromStringWellFormed(sourceSURL);
                        uniqueID2 = tsurl.uniqueId();
                    }
                    catch (InvalidTSURLAttributesException e) {
                        log.warn("PtGChunkDAO! unable to build the TSURL from " + sourceSURL + " : InvalidTSURLAttributesException " + e);
                    }
                }
                pinnedSurlSet.add(uniqueID2);
            }
            str = "SELECT rb.sourceSURL , rb.sourceSURL_uniqueID FROM request_BoL rb JOIN (status_BoL sb, request_queue rq) ON sb.request_BoLID=rb.ID AND rb.request_queueID=rq.ID WHERE sb.statusCode=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_SUCCESS) + " AND UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(rq.timeStamp) < rq.pinLifetime ";
            res = statement.executeQuery(str);
            this.logWarnings(statement.getWarnings());
            while (res.next()) {
                sourceSURL = res.getString("rb.sourceSURL");
                uniqueID2 = new Integer(res.getInt("rb.sourceSURL_uniqueID"));
                if (res.wasNull()) {
                    try {
                        tsurl = TSURL.makeFromStringWellFormed(sourceSURL);
                        uniqueID2 = tsurl.uniqueId();
                    }
                    catch (InvalidTSURLAttributesException e) {
                        log.warn("PtGChunkDAO! unable to build the TSURL from " + sourceSURL + " : InvalidTSURLAttributesException " + e);
                    }
                }
                pinnedSurlSet.add(uniqueID2);
            }
            this.commit(this.con);
        }
        catch (SQLException e) {
            log.error("PtGChunkDAO! SQLException." + e);
            this.rollback(this.con);
        }
        finally {
            this.close(statement);
        }
        ArrayList<TSURL> expiredSurlList = new ArrayList<TSURL>();
        for (Map.Entry surlEntry : expiredSurlMap.entrySet()) {
            StoRI stori;
            TSURL surl;
            if (pinnedSurlSet.contains(surlEntry.getValue())) continue;
            try {
                surl = TSURL.makeFromStringValidate((String)surlEntry.getKey());
            }
            catch (InvalidTSURLAttributesException e) {
                log.error("Invalid SURL, cannot release the pin (Extended Attribute): " + (String)surlEntry.getKey());
                continue;
            }
            expiredSurlList.add(surl);
            try {
                stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl);
            }
            catch (UnapprochableSurlException e) {
                log.error("Invalid SURL " + (String)surlEntry.getKey() + " cannot release the pin. UnapprochableSurlException: " + e.getMessage());
                continue;
            }
            if (!stori.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) continue;
            StormEA.removePinned(stori.getAbsolutePath());
        }
        return expiredSurlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transitSRM_FILE_PINNEDtoSRM_RELEASED(long[] ids) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: transitSRM_FILE_PINNEDtoSRM_RELEASED - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Get sg SET sg.statusCode=? WHERE sg.statusCode=? AND sg.request_GetID IN " + this.makeWhereString(ids);
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_RELEASED));
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FILE_PINNED));
            this.logWarnings(stmt.getWarnings());
            log.trace("PtG CHUNK DAO - transitSRM_FILE_PINNEDtoSRM_RELEASED: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("PtG CHUNK DAO! No chunk of PtG request was transited from SRM_FILE_PINNED to SRM_RELEASED.");
            } else {
                log.info("PtG CHUNK DAO! " + count + " chunks of PtG requests were transited " + "from SRM_FILE_PINNED to SRM_RELEASED.");
            }
        }
        catch (SQLException e) {
            log.error("PtG CHUNK DAO! Unable to transit chunks from SRM_FILE_PINNED to SRM_RELEASED! " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transitSRM_FILE_PINNEDtoSRM_RELEASED(long[] ids, TRequestToken token) {
        if (token == null) {
            this.transitSRM_FILE_PINNEDtoSRM_RELEASED(ids);
        } else {
            if (!this.checkConnection()) {
                log.error("PTG CHUNK DAO: transitSRM_FILE_PINNEDtoSRM_RELEASED - unable to get a valid connection!");
                return;
            }
            String str = "UPDATE status_Get sg JOIN (request_Get rg, request_queue rq) ON sg.request_GetID=rg.ID AND rg.request_queueID=rq.ID SET sg.statusCode=? WHERE sg.statusCode=? AND rq.r_token='" + token.toString() + "' AND rg.ID IN " + this.makeWhereString(ids);
            PreparedStatement stmt = null;
            try {
                stmt = this.con.prepareStatement(str);
                this.logWarnings(this.con.getWarnings());
                stmt.setInt(1, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_RELEASED));
                this.logWarnings(stmt.getWarnings());
                stmt.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FILE_PINNED));
                this.logWarnings(stmt.getWarnings());
                log.trace("PtG CHUNK DAO - transitSRM_FILE_PINNEDtoSRM_RELEASED: " + stmt.toString());
                int count = stmt.executeUpdate();
                this.logWarnings(stmt.getWarnings());
                if (count == 0) {
                    log.trace("PtG CHUNK DAO! No chunk of PtG request was transited from SRM_FILE_PINNED to SRM_RELEASED.");
                } else {
                    log.info("PtG CHUNK DAO! " + count + " chunks of PtG requests were transited from " + "SRM_FILE_PINNED to SRM_RELEASED.");
                }
            }
            catch (SQLException e) {
                log.error("PtG CHUNK DAO! Unable to transit chunks from SRM_FILE_PINNED to SRM_RELEASED! " + e);
            }
            finally {
                this.close(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateStatus(TRequestToken requestToken, int[] surlUniqueIDs, String[] surls, TStatusCode statusCode, String explanation) {
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: updateStatus - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Get sg JOIN (request_Get rg, request_queue rq) ON sg.request_GetID=rg.ID AND rg.request_queueID=rq.ID SET sg.statusCode=? , sg.explanation=? WHERE rq.r_token='" + requestToken.toString() + "' AND ( rg.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlUniqueIDs) + " OR rg.sourceSURL IN " + this.makeSurlString(surls) + " ) ";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(statusCode));
            this.logWarnings(stmt.getWarnings());
            stmt.setString(2, explanation != null ? explanation : "");
            this.logWarnings(stmt.getWarnings());
            log.trace("PtG CHUNK DAO - updateStatus: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("PtG CHUNK DAO! No chunk of PtG request was updated to " + (Object)((Object)statusCode) + ".");
            } else {
                log.info("PtG CHUNK DAO! " + count + " chunks of PtG requests were updated to " + (Object)((Object)statusCode) + ".");
            }
        }
        catch (SQLException e) {
            log.error("PtG CHUNK DAO! Unable to updated to " + (Object)((Object)statusCode) + " !" + e);
        }
        finally {
            this.close(stmt);
        }
    }

    public synchronized void updateStatusOnMatchingStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || explanation == null) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: requestToken=" + requestToken + " explanation=" + explanation);
        }
        this.doUpdateStatusOnMatchingStatus(requestToken, null, null, expectedStatusCode, newStatusCode, explanation, true, false, true);
    }

    public synchronized void updateStatusOnMatchingStatus(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode) throws IllegalArgumentException {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || surlsUniqueIDs == null || surls == null || surlsUniqueIDs.length == 0 || surls.length == 0 || surlsUniqueIDs.length != surls.length) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: requestToken=" + requestToken + "surlsUniqueIDs=" + surlsUniqueIDs + " surls=" + surls);
        }
        this.doUpdateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode, null, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doUpdateStatusOnMatchingStatus(TRequestToken requestToken, int[] surlUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation, boolean withRequestToken, boolean withSurls, boolean withExplanation) throws IllegalArgumentException {
        if (withRequestToken && requestToken == null || withExplanation && explanation == null || withSurls && (surlUniqueIDs == null || surls == null)) {
            throw new IllegalArgumentException("Unable to perform the doUpdateStatusOnMatchingStatus, invalid arguments: withRequestToken=" + withRequestToken + " requestToken=" + requestToken + " withSurls=" + withSurls + " surlUniqueIDs=" + surlUniqueIDs + " surls=" + surls + " withExplaination=" + withExplanation + " explanation=" + explanation);
        }
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: updateStatusOnMatchingStatus - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE status_Get sg JOIN (request_Get rg, request_queue rq) ON sg.request_GetID=rg.ID AND rg.request_queueID=rq.ID SET sg.statusCode=? ";
        if (withExplanation) {
            str = str + " , " + this.buildExpainationSet(explanation);
        }
        str = str + " WHERE sg.statusCode=? ";
        if (withRequestToken) {
            str = str + " AND " + this.buildTokenWhereClause(requestToken);
        }
        if (withSurls) {
            str = str + " AND " + this.buildSurlsWhereClause(surlUniqueIDs, surls);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(newStatusCode));
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, StatusCodeConverter.getInstance().toDB(expectedStatusCode));
            this.logWarnings(stmt.getWarnings());
            log.trace("PtG CHUNK DAO - updateStatusOnMatchingStatus: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("PtG CHUNK DAO! No chunk of PtG request was updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + ".");
            } else {
                log.debug("PtG CHUNK DAO! " + count + " chunks of PtG requests were updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + ".");
            }
        }
        catch (SQLException e) {
            log.error("PtG CHUNK DAO! Unable to updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + " !" + e);
        }
        finally {
            this.close(stmt);
        }
    }

    private void close(ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error("PTG CHUNK DAO! Unable to close ResultSet! Exception: " + e);
            }
        }
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error("PTG CHUNK DAO! Unable to close Statement " + stmt.toString() + " - Exception: " + e);
            }
        }
    }

    private void commit(Connection con) {
        if (con != null) {
            try {
                con.commit();
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error("PtG, SQL EXception", (Throwable)e);
            }
        }
    }

    private void rollback(Connection con) {
        if (con != null) {
            try {
                con.rollback();
                con.setAutoCommit(true);
                log.error("PTG CHUNK DAO: roll back successful!");
            }
            catch (SQLException e2) {
                log.error("PTG CHUNK DAO: roll back failed! " + e2);
            }
        }
    }

    private int extractID(ResultSet rs) throws Exception {
        if (rs == null) {
            throw new Exception("PTG CHUNK DAO! Null ResultSet!");
        }
        if (rs.next()) {
            return rs.getInt(1);
        }
        log.error("PTG CHUNK DAO! It was not possible to establish the assigned autoincrement primary key!");
        throw new Exception("PTG CHUNK DAO! It was not possible to establish the assigned autoincrement primary key!");
    }

    private void logWarnings(SQLWarning w) {
        if (w != null) {
            log.debug("PTG CHUNK DAO: " + w.toString());
            while ((w = w.getNextWarning()) != null) {
                log.debug("PTG CHUNK DAO: " + w.toString());
            }
        }
    }

    private String makeWhereString(long[] rowids) {
        StringBuffer sb = new StringBuffer("(");
        int n = rowids.length;
        for (int i = 0; i < n; ++i) {
            sb.append(rowids[i]);
            if (i >= n - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String makeSURLUniqueIDWhere(int[] surlUniqueIDs) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < surlUniqueIDs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(surlUniqueIDs[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    private String makeSurlString(String[] surls) {
        StringBuffer sb = new StringBuffer("(");
        int n = surls.length;
        for (int i = 0; i < n; ++i) {
            sb.append("'");
            sb.append(surls[i]);
            sb.append("'");
            if (i >= n - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean setUpConnection() {
        boolean response = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.name, this.password);
            if (this.con == null) {
                log.error("PTG CHUNK DAO! Exception in setUpConnection! DriverManager could not create connection!");
            } else {
                this.logWarnings(this.con.getWarnings());
                response = this.con.isValid(0);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("PTG CHUNK DAO! Exception in setUpConnection! " + e);
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO! Exception in setUpConenction! " + e);
        }
        return response;
    }

    private boolean checkConnection() {
        boolean response = true;
        if (this.reconnect) {
            log.debug("PTG CHUNK DAO! Reconnecting to DB! ");
            this.takeDownConnection();
            response = this.setUpConnection();
            if (response) {
                this.reconnect = false;
            }
        }
        return response;
    }

    private void takeDownConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                log.error("PTG CHUNK DAO! Exception in takeDownConnection method: " + e);
            }
        }
    }

    public Collection<PtGChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray, String dn) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0 || dn == null) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray + " dn=" + dn);
        }
        return this.find(surlsUniqueIDs, surlsArray, dn, true);
    }

    public Collection<PtGChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray);
        }
        return this.find(surlsUniqueIDs, surlsArray, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection<PtGChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray, String dn, boolean withDn) throws IllegalArgumentException {
        if (withDn && dn == null || surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray + " withDn=" + withDn + " dn=" + dn);
        }
        if (!this.checkConnection()) {
            log.error("PTG CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<PtGChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            String str = "SELECT rq.ID, rq.r_token, sg.statusCode, rq.pinLifetime, rg.ID, rq.timeStamp, rq.client_dn, rq.proxy, rg.sourceSURL, rg.normalized_sourceSURL_StFN, rg.sourceSURL_uniqueID, d.isSourceADirectory, d.allLevelRecursive,  d.numOfLevels FROM request_queue rq JOIN (request_Get rg, status_Get sg) ON (rg.request_queueID=rq.ID AND sg.request_GetID=rg.ID) LEFT JOIN request_DirOption d ON rg.request_DirOptionID=d.ID WHERE ( rg.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rg.sourceSURL IN " + this.makeSurlString(surlsArray) + " )";
            if (withDn) {
                str = str + " AND rq.client_dn='" + dn + "'";
            }
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<PtGChunkDataTO> list = new ArrayList<PtGChunkDataTO>();
            log.trace("PTG CHUNK DAO - find method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            PtGChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new PtGChunkDataTO();
                chunkDataTO.setStatus(rs.getInt("sg.statusCode"));
                chunkDataTO.setRequestToken(rs.getString("rq.r_token"));
                chunkDataTO.setPrimaryKey(rs.getLong("rg.ID"));
                chunkDataTO.setFromSURL(rs.getString("rg.sourceSURL"));
                chunkDataTO.setNormalizedStFN(rs.getString("rg.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rg.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setLifeTime(rs.getInt("rq.pinLifetime"));
                chunkDataTO.setClientDN(rs.getString("rq.client_dn"));
                Blob blob = rs.getBlob("rq.proxy");
                if (!rs.wasNull() && blob != null) {
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    chunkDataTO.setVomsAttributes(new String(bdata));
                }
                chunkDataTO.setDirOption(rs.getBoolean("d.isSourceADirectory"));
                chunkDataTO.setAllLevelRecursive(rs.getBoolean("d.allLevelRecursive"));
                chunkDataTO.setNumLevel(rs.getInt("d.numOfLevels"));
                chunkDataTO.setProtocolList(PtPChunkDAO.getInstance().findProtocols(rs.getLong("rq.ID")));
                list.add(chunkDataTO);
            }
            ArrayList<PtGChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("PTG CHUNK DAO: " + e);
            ArrayList<PtGChunkDataTO> arrayList = new ArrayList<PtGChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    private String buildExpainationSet(String explanation) {
        return " sg.explanation='" + explanation + "' ";
    }

    private String buildTokenWhereClause(TRequestToken requestToken) {
        return " rq.r_token='" + requestToken.toString() + "' ";
    }

    private String buildSurlsWhereClause(int[] surlsUniqueIDs, String[] surls) {
        return " ( rg.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rg.sourceSURL IN " + this.makeSurlString(surls) + " ) ";
    }
}

