/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TFileStorageType;
import java.util.HashMap;
import java.util.Map;

class FileStorageTypeConverter {
    private Map<String, TFileStorageType> DBtoSTORM = new HashMap<String, TFileStorageType>();
    private Map<TFileStorageType, String> STORMtoDB = new HashMap<TFileStorageType, String>();
    private static FileStorageTypeConverter c = new FileStorageTypeConverter();

    private FileStorageTypeConverter() {
        this.DBtoSTORM.put("V", TFileStorageType.VOLATILE);
        this.DBtoSTORM.put("P", TFileStorageType.PERMANENT);
        this.DBtoSTORM.put("D", TFileStorageType.DURABLE);
        for (String aux : this.DBtoSTORM.keySet()) {
            this.STORMtoDB.put(this.DBtoSTORM.get(aux), aux);
        }
    }

    public static FileStorageTypeConverter getInstance() {
        return c;
    }

    public String toDB(TFileStorageType fst) {
        String aux = this.STORMtoDB.get(fst);
        if (aux == null) {
            return "";
        }
        return aux;
    }

    public TFileStorageType toSTORM(String s) {
        TFileStorageType aux = this.DBtoSTORM.get(s);
        if (aux == null) {
            aux = this.DBtoSTORM.get(Configuration.getInstance().getDefaultFileStorageType());
        }
        if (aux == null) {
            return TFileStorageType.EMPTY;
        }
        return aux;
    }

    public String toString() {
        return "FileStorageTypeConverter.\nDBtoSTORM map:" + this.DBtoSTORM + "\nSTORMtoDB map:" + this.STORMtoDB;
    }
}

