/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.CopyChunkDataTO;
import it.grid.storm.catalogs.ReducedCopyChunkDataTO;
import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TStatusCode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyChunkDAO {
    private static final Logger log = LoggerFactory.getLogger(CopyChunkDAO.class);
    private final String driver = Configuration.getInstance().getDBDriver();
    private final String url = Configuration.getInstance().getDBURL();
    private final String password = Configuration.getInstance().getDBPassword();
    private final String name = Configuration.getInstance().getDBUserName();
    private Connection con = null;
    private boolean reconnect = false;
    private static final CopyChunkDAO dao = new CopyChunkDAO();
    private Timer clock = null;
    private TimerTask clockTask = null;
    private long period = Configuration.getInstance().getDBReconnectPeriod() * 1000L;
    private long delay = Configuration.getInstance().getDBReconnectDelay() * 1000L;

    private CopyChunkDAO() {
        this.setUpConnection();
        this.clock = new Timer();
        this.clockTask = new TimerTask(){

            @Override
            public void run() {
                CopyChunkDAO.this.reconnect = true;
            }
        };
        this.clock.scheduleAtFixedRate(this.clockTask, this.delay, this.period);
    }

    public static CopyChunkDAO getInstance() {
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(CopyChunkDataTO to) {
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: update - unable to get a valid connection!");
            return;
        }
        PreparedStatement updateFileReq = null;
        try {
            updateFileReq = this.con.prepareStatement("UPDATE request_queue rq JOIN (status_Copy sc, request_Copy rc) ON (rq.ID=rc.request_queueID AND sc.request_CopyID=rc.ID) SET sc.statusCode=?, sc.explanation=?, rq.fileLifetime=?, rq.config_FileStorageTypeID=?, rq.config_OverwriteID=?, rc.normalized_sourceSURL_StFN=?, rc.sourceSURL_uniqueID=?, rc.normalized_targetSURL_StFN=?, rc.targetSURL_uniqueID=? WHERE rc.ID=?");
            this.logWarnings(this.con.getWarnings());
            updateFileReq.setInt(1, to.status());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(2, to.errString());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setInt(3, to.lifeTime());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(4, to.fileStorageType());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(5, to.overwriteOption());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(6, to.normalizedSourceStFN());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setInt(7, to.sourceSurlUniqueID());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setString(8, to.normalizedTargetStFN());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setInt(9, to.targetSurlUniqueID());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.setLong(10, to.primaryKey());
            this.logWarnings(updateFileReq.getWarnings());
            updateFileReq.executeUpdate();
            this.logWarnings(updateFileReq.getWarnings());
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO: Unable to complete update! " + e);
        }
        finally {
            this.close(updateFileReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateIncomplete(ReducedCopyChunkDataTO chunkTO) {
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: updateIncomplete - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE request_Copy SET normalized_sourceSURL_StFN=?, sourceSURL_uniqueID=?, normalized_targetSURL_StFN=?, targetSURL_uniqueID=? WHERE ID=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, chunkTO.normalizedSourceStFN());
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, chunkTO.sourceSurlUniqueID());
            this.logWarnings(stmt.getWarnings());
            stmt.setString(3, chunkTO.normalizedTargetStFN());
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(4, chunkTO.targetSurlUniqueID());
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(5, chunkTO.primaryKey());
            this.logWarnings(stmt.getWarnings());
            log.trace("COPY CHUNK DAO - update incomplete: " + stmt.toString());
            stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO: Unable to complete update incomplete! " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<CopyChunkDataTO> find(TRequestToken requestToken) {
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<CopyChunkDataTO>();
        }
        String strToken = requestToken.toString();
        String str = null;
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            str = "SELECT rq.s_token, rq.config_FileStorageTypeID, rq.config_OverwriteID, rq.fileLifetime, rc.ID, rc.sourceSURL, rc.targetSURL, rc.normalized_sourceSURL_StFN, rc.sourceSURL_uniqueID, rc.normalized_targetSURL_StFN, rc.targetSURL_uniqueID, d.isSourceADirectory, d.allLevelRecursive, d.numOfLevels FROM request_queue rq JOIN (request_Copy rc, status_Copy sc) ON (rc.request_queueID=rq.ID AND sc.request_CopyID=rc.ID) LEFT JOIN request_DirOption d ON rc.request_DirOptionID=d.ID WHERE rq.r_token=? AND sc.statusCode<>?";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<CopyChunkDataTO> list = new ArrayList<CopyChunkDataTO>();
            find.setString(1, strToken);
            this.logWarnings(find.getWarnings());
            find.setInt(2, StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_ABORTED));
            this.logWarnings(find.getWarnings());
            log.debug("COPY CHUNK DAO: find method; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            while (rs.next()) {
                CopyChunkDataTO chunkDataTO = new CopyChunkDataTO();
                chunkDataTO.setRequestToken(strToken);
                chunkDataTO.setSpaceToken(rs.getString("rq.s_token"));
                chunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                chunkDataTO.setOverwriteOption(rs.getString("rq.config_OverwriteID"));
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setLifeTime(rs.getInt("rq.fileLifetime"));
                chunkDataTO.setPrimaryKey(rs.getLong("rc.ID"));
                chunkDataTO.setFromSURL(rs.getString("rc.sourceSURL"));
                chunkDataTO.setNormalizedSourceStFN(rs.getString("rc.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rc.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSourceSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setToSURL(rs.getString("rc.targetSURL"));
                chunkDataTO.setNormalizedTargetStFN(rs.getString("rc.normalized_sourceSURL_StFN"));
                uniqueID = rs.getInt("rc.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setTargetSurlUniqueID(new Integer(uniqueID));
                }
                list.add(chunkDataTO);
            }
            ArrayList<CopyChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO: " + e);
            ArrayList<CopyChunkDataTO> arrayList = new ArrayList<CopyChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<CopyChunkDataTO> find(TRequestToken requestToken, int[] surlUniqueIDs, String[] surls) {
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<CopyChunkDataTO>();
        }
        String strToken = requestToken.toString();
        String str = null;
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            str = "SELECT rq.s_token, rq.config_FileStorageTypeID, rq.config_OverwriteID, rq.fileLifetime, rc.ID, rc.sourceSURL, rc.targetSURL, rc.normalized_sourceSURL_StFN, rc.sourceSURL_uniqueID, rc.normalized_targetSURL_StFN, rc.targetSURL_uniqueID, d.isSourceADirectory, d.allLevelRecursive, d.numOfLevels FROM request_queue rq JOIN (request_Copy rc, status_Copy sc) ON (rc.request_queueID=rq.ID AND sc.request_CopyID=rc.ID) LEFT JOIN request_DirOption d ON rc.request_DirOptionID=d.ID WHERE rq.r_token=? AND ( rc.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlUniqueIDs) + " OR rc.sourceSURL IN " + this.makeSurlString(surls) + " ) ";
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<CopyChunkDataTO> list = new ArrayList<CopyChunkDataTO>();
            find.setString(1, strToken);
            this.logWarnings(find.getWarnings());
            log.debug("COPY CHUNK DAO: find method; " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            while (rs.next()) {
                CopyChunkDataTO chunkDataTO = new CopyChunkDataTO();
                chunkDataTO.setRequestToken(strToken);
                chunkDataTO.setSpaceToken(rs.getString("rq.s_token"));
                chunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                chunkDataTO.setOverwriteOption(rs.getString("rq.config_OverwriteID"));
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setLifeTime(rs.getInt("rq.fileLifetime"));
                chunkDataTO.setPrimaryKey(rs.getLong("rc.ID"));
                chunkDataTO.setFromSURL(rs.getString("rc.sourceSURL"));
                chunkDataTO.setNormalizedSourceStFN(rs.getString("rc.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rc.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSourceSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setToSURL(rs.getString("rc.targetSURL"));
                chunkDataTO.setNormalizedTargetStFN(rs.getString("rc.normalized_sourceSURL_StFN"));
                uniqueID = rs.getInt("rc.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setTargetSurlUniqueID(new Integer(uniqueID));
                }
                list.add(chunkDataTO);
            }
            ArrayList<CopyChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO: " + e);
            ArrayList<CopyChunkDataTO> arrayList = new ArrayList<CopyChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalMalformedCopyChunk(CopyChunkDataTO auxTO) {
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: signalMalformedCopyChunk - unable to get a valid connection!");
            return;
        }
        String signalSQL = "UPDATE status_Copy SET statusCode=" + StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_FAILURE) + ", explanation=? WHERE request_CopyID=" + auxTO.primaryKey();
        PreparedStatement signal = null;
        try {
            signal = this.con.prepareStatement(signalSQL);
            this.logWarnings(this.con.getWarnings());
            signal.setString(1, "Request is malformed!");
            this.logWarnings(signal.getWarnings());
            signal.executeUpdate();
            this.logWarnings(signal.getWarnings());
        }
        catch (SQLException e) {
            log.error("CopyChunkDAO! Unable to signal in DB that therequest was malformed! Request: " + auxTO.toString() + "; Exception: " + e.toString());
        }
        finally {
            this.close(signal);
        }
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error("COPY CHUNK DAO! Unable to close Statement " + stmt.toString() + " - Exception: " + e);
            }
        }
    }

    private void close(ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error("COPY CHUNK DAO! Unable to close ResultSet! Exception: " + e);
            }
        }
    }

    private void logWarnings(SQLWarning w) {
        if (w != null) {
            log.debug("COPY CHUNK DAO: " + w.toString());
            while ((w = w.getNextWarning()) != null) {
                log.debug("COPY CHUNK DAO: " + w.toString());
            }
        }
    }

    private boolean setUpConnection() {
        boolean response = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.name, this.password);
            if (this.con == null) {
                log.error("COPY CHUNK DAO! DriverManager returned a _null_ connection!");
            } else {
                this.logWarnings(this.con.getWarnings());
                response = this.con.isValid(0);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("COPY CHUNK DAO! Exception in setUpConnection! " + e);
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO! Exception in setUpConnection! " + e);
        }
        return response;
    }

    private synchronized boolean checkConnection() {
        boolean response = true;
        if (this.reconnect) {
            log.debug("COPY CHUNK DAO! Reconnecting to DB! ");
            this.takeDownConnection();
            response = this.setUpConnection();
            if (response) {
                this.reconnect = false;
            }
        }
        return response;
    }

    private void takeDownConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                log.error("COPY CHUNK DAO! Exception in takeDownConnection method: " + e);
            }
        }
    }

    public synchronized void updateStatusOnMatchingStatus(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || explanation == null) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: requestToken=" + requestToken + " explanation=" + explanation);
        }
        this.doUpdateStatusOnMatchingStatus(requestToken, null, null, expectedStatusCode, newStatusCode, explanation, true, false, true);
    }

    public synchronized void updateStatusOnMatchingStatus(TRequestToken requestToken, int[] surlsUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode) throws IllegalArgumentException {
        if (requestToken == null || requestToken.getValue().trim().isEmpty() || surlsUniqueIDs == null || surls == null || surlsUniqueIDs.length == 0 || surls.length == 0 || surlsUniqueIDs.length != surls.length) {
            throw new IllegalArgumentException("Unable to perform the updateStatusOnMatchingStatus, invalid arguments: requestToken=" + requestToken + "surlsUniqueIDs=" + surlsUniqueIDs + " surls=" + surls);
        }
        this.doUpdateStatusOnMatchingStatus(requestToken, surlsUniqueIDs, surls, expectedStatusCode, newStatusCode, null, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doUpdateStatusOnMatchingStatus(TRequestToken requestToken, int[] surlUniqueIDs, String[] surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation, boolean withRequestToken, boolean withSurls, boolean withExplanation) throws IllegalArgumentException {
        if (withRequestToken && requestToken == null || withExplanation && explanation == null || withSurls && (surlUniqueIDs == null || surls == null)) {
            throw new IllegalArgumentException("Unable to perform the doUpdateStatusOnMatchingStatus, invalid arguments: withRequestToken=" + withRequestToken + " requestToken=" + requestToken + " withSurls=" + withSurls + " surlUniqueIDs=" + surlUniqueIDs + " surls=" + surls + " withExplaination=" + withExplanation + " explanation=" + explanation);
        }
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: updateStatusOnMatchingStatus - unable to get a valid connection!");
            return;
        }
        String str = "UPDATE request_queue rq JOIN (status_Copy sc, request_Copy rc) ON (rq.ID=rc.request_queueID AND sc.request_CopyID=rc.ID) SET sc.statusCode=? ";
        if (withExplanation) {
            str = str + " , " + this.buildExpainationSet(explanation);
        }
        str = str + " WHERE sc.statusCode=? ";
        if (withRequestToken) {
            str = str + " AND " + this.buildTokenWhereClause(requestToken);
        }
        if (withSurls) {
            str = str + " AND " + this.buildSurlsWhereClause(surlUniqueIDs, surls);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            stmt.setInt(1, StatusCodeConverter.getInstance().toDB(newStatusCode));
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, StatusCodeConverter.getInstance().toDB(expectedStatusCode));
            this.logWarnings(stmt.getWarnings());
            log.trace("COPY CHUNK DAO - updateStatusOnMatchingStatus: " + stmt.toString());
            int count = stmt.executeUpdate();
            this.logWarnings(stmt.getWarnings());
            if (count == 0) {
                log.trace("COPY CHUNK DAO! No chunk of COPY request was updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + ".");
            } else {
                log.debug("COPY CHUNK DAO! " + count + " chunks of COPY requests were updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + ".");
            }
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO! Unable to updated from " + (Object)((Object)expectedStatusCode) + " to " + (Object)((Object)newStatusCode) + " !" + e);
        }
        finally {
            this.close(stmt);
        }
    }

    private String makeSURLUniqueIDWhere(int[] surlUniqueIDs) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < surlUniqueIDs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(surlUniqueIDs[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    private String makeSurlString(String[] surls) {
        StringBuffer sb = new StringBuffer("(");
        int n = surls.length;
        for (int i = 0; i < n; ++i) {
            sb.append("'");
            sb.append(surls[i]);
            sb.append("'");
            if (i >= n - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public synchronized Collection<CopyChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray, String dn) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0 || dn == null) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray + " dn=" + dn);
        }
        return this.find(surlsUniqueIDs, surlsArray, dn, true);
    }

    public synchronized Collection<CopyChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray) throws IllegalArgumentException {
        if (surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray);
        }
        return this.find(surlsUniqueIDs, surlsArray, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection<CopyChunkDataTO> find(int[] surlsUniqueIDs, String[] surlsArray, String dn, boolean withDn) throws IllegalArgumentException {
        if (withDn && dn == null || surlsUniqueIDs == null || surlsUniqueIDs.length == 0 || surlsArray == null || surlsArray.length == 0) {
            throw new IllegalArgumentException("Unable to perform the find, invalid arguments: surlsUniqueIDs=" + surlsUniqueIDs + " surlsArray=" + surlsArray + " withDn=" + withDn + " dn=" + dn);
        }
        if (!this.checkConnection()) {
            log.error("COPY CHUNK DAO: find - unable to get a valid connection!");
            return new ArrayList<CopyChunkDataTO>();
        }
        PreparedStatement find = null;
        ResultSet rs = null;
        try {
            String str = "SELECT rq.r_token, rq.s_token, rq.config_FileStorageTypeID, rq.config_OverwriteID, rq.fileLifetime, rc.ID, rc.sourceSURL, rc.targetSURL, rc.normalized_sourceSURL_StFN, rc.sourceSURL_uniqueID, rc.normalized_targetSURL_StFN, rc.targetSURL_uniqueID, d.isSourceADirectory, d.allLevelRecursive, d.numOfLevels FROM request_queue rq JOIN (request_Copy rc, status_Copy sc) ON (rc.request_queueID=rq.ID AND sc.request_CopyID=rc.ID) LEFT JOIN request_DirOption d ON rc.request_DirOptionID=d.ID WHERE ( rc.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rc.sourceSURL IN " + this.makeSurlString(surlsArray) + " )";
            if (withDn) {
                str = str + " AND rq.client_dn='" + dn + "'";
            }
            find = this.con.prepareStatement(str);
            this.logWarnings(this.con.getWarnings());
            ArrayList<CopyChunkDataTO> list = new ArrayList<CopyChunkDataTO>();
            log.trace("COPY CHUNK DAO - find method: " + find.toString());
            rs = find.executeQuery();
            this.logWarnings(find.getWarnings());
            CopyChunkDataTO chunkDataTO = null;
            while (rs.next()) {
                chunkDataTO = new CopyChunkDataTO();
                chunkDataTO.setRequestToken(rs.getString("rq.r_token"));
                chunkDataTO.setSpaceToken(rs.getString("rq.s_token"));
                chunkDataTO.setFileStorageType(rs.getString("rq.config_FileStorageTypeID"));
                chunkDataTO.setOverwriteOption(rs.getString("rq.config_OverwriteID"));
                chunkDataTO.setTimeStamp(rs.getTimestamp("rq.timeStamp"));
                chunkDataTO.setLifeTime(rs.getInt("rq.fileLifetime"));
                chunkDataTO.setPrimaryKey(rs.getLong("rc.ID"));
                chunkDataTO.setFromSURL(rs.getString("rc.sourceSURL"));
                chunkDataTO.setNormalizedSourceStFN(rs.getString("rc.normalized_sourceSURL_StFN"));
                int uniqueID = rs.getInt("rc.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setSourceSurlUniqueID(new Integer(uniqueID));
                }
                chunkDataTO.setToSURL(rs.getString("rc.targetSURL"));
                chunkDataTO.setNormalizedTargetStFN(rs.getString("rc.normalized_sourceSURL_StFN"));
                uniqueID = rs.getInt("rc.sourceSURL_uniqueID");
                if (!rs.wasNull()) {
                    chunkDataTO.setTargetSurlUniqueID(new Integer(uniqueID));
                }
                list.add(chunkDataTO);
            }
            ArrayList<CopyChunkDataTO> arrayList = list;
            this.close(rs);
            this.close(find);
            return arrayList;
        }
        catch (SQLException e) {
            log.error("COPY CHUNK DAO: " + e);
            ArrayList<CopyChunkDataTO> arrayList = new ArrayList<CopyChunkDataTO>();
            return arrayList;
        }
        finally {
            this.close(rs);
            this.close(find);
        }
    }

    private String buildExpainationSet(String explanation) {
        return " sc.explanation='" + explanation + "' ";
    }

    private String buildTokenWhereClause(TRequestToken requestToken) {
        return " rq.r_token='" + requestToken.toString() + "' ";
    }

    private String buildSurlsWhereClause(int[] surlsUniqueIDs, String[] surls) {
        return " ( rc.sourceSURL_uniqueID IN " + this.makeSURLUniqueIDWhere(surlsUniqueIDs) + " OR rc.sourceSURL IN " + this.makeSurlString(surls) + " ) ";
    }
}

