/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.StatusCodeConverter;
import it.grid.storm.catalogs.TransferProtocolListConverter;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.srm.types.TStatusCode;
import java.sql.Timestamp;
import java.util.List;

public class BoLChunkDataTO {
    private long primaryKey = -1L;
    private String fromSURL = " ";
    private boolean dirOption;
    private String normalizedStFN = null;
    private Integer surlUniqueID = null;
    private String requestToken = " ";
    private int lifetime = 0;
    private boolean allLevelRecursive;
    private int numLevel;
    private List<String> protocolList = null;
    private long filesize = 0L;
    private int status;
    private String errString = " ";
    private int deferredStartTime = -1;
    private Timestamp timeStamp = null;

    public BoLChunkDataTO() {
        TURLPrefix protocolPreferences = new TURLPrefix();
        protocolPreferences.addProtocol(Protocol.GSIFTP);
        this.protocolList = TransferProtocolListConverter.toDB(protocolPreferences);
        this.status = StatusCodeConverter.getInstance().toDB(TStatusCode.SRM_REQUEST_QUEUED);
        this.dirOption = false;
        this.allLevelRecursive = false;
        this.numLevel = 0;
    }

    public boolean getAllLevelRecursive() {
        return this.allLevelRecursive;
    }

    public int getDeferredStartTime() {
        return this.deferredStartTime;
    }

    public boolean getDirOption() {
        return this.dirOption;
    }

    public String getErrString() {
        return this.errString;
    }

    public long getFileSize() {
        return this.filesize;
    }

    public String getFromSURL() {
        return this.fromSURL;
    }

    public int getLifeTime() {
        return this.lifetime;
    }

    public int getNumLevel() {
        return this.numLevel;
    }

    public long getPrimaryKey() {
        return this.primaryKey;
    }

    public List<String> getProtocolList() {
        return this.protocolList;
    }

    public String getRequestToken() {
        return this.requestToken;
    }

    public Timestamp getTimeStamp() {
        return this.timeStamp;
    }

    public int getStatus() {
        return this.status;
    }

    public void setAllLevelRecursive(boolean b) {
        this.allLevelRecursive = b;
    }

    public void setDeferredStartTime(int deferredStartTime) {
        this.deferredStartTime = deferredStartTime;
    }

    public void setDirOption(boolean b) {
        this.dirOption = b;
    }

    public void setErrString(String s) {
        this.errString = s;
    }

    public void setFileSize(long n) {
        this.filesize = n;
    }

    public void setFromSURL(String s) {
        this.fromSURL = s;
    }

    public void setLifeTime(int n) {
        this.lifetime = n;
    }

    public void setNumLevel(int n) {
        this.numLevel = n;
    }

    public void setPrimaryKey(long n) {
        this.primaryKey = n;
    }

    public void setProtocolList(List<String> l) {
        if (l != null && !l.isEmpty()) {
            this.protocolList = l;
        }
    }

    public void setRequestToken(String s) {
        this.requestToken = s;
    }

    public void setTimeStamp(Timestamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setNormalizedStFN(String normalizedStFN) {
        this.normalizedStFN = normalizedStFN;
    }

    public String normalizedStFN() {
        return this.normalizedStFN;
    }

    public void setSurlUniqueID(Integer surlUniqueID) {
        this.surlUniqueID = surlUniqueID;
    }

    public Integer sulrUniqueID() {
        return this.surlUniqueID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.primaryKey);
        sb.append(" ");
        sb.append(this.requestToken);
        sb.append(" ");
        sb.append(this.fromSURL);
        sb.append(" ");
        sb.append(this.normalizedStFN);
        sb.append(" ");
        sb.append(this.surlUniqueID);
        sb.append(" ");
        sb.append(this.lifetime);
        sb.append(" ");
        sb.append(this.dirOption);
        sb.append(" ");
        sb.append(this.allLevelRecursive);
        sb.append(" ");
        sb.append(this.numLevel);
        sb.append(" ");
        sb.append(this.protocolList);
        sb.append(" ");
        sb.append(this.filesize);
        sb.append(" ");
        sb.append(this.status);
        sb.append(" ");
        sb.append(this.errString);
        return sb.toString();
    }
}

