/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.AnonymousFileTransferData;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidPtPDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PtPData;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousPtPData
extends AnonymousFileTransferData
implements PtPData {
    static final Logger log = LoggerFactory.getLogger(AnonymousPtPData.class);
    protected TSpaceToken spaceToken;
    protected TLifeTimeInSeconds pinLifetime;
    protected TLifeTimeInSeconds fileLifetime;
    protected TFileStorageType fileStorageType;
    protected TOverwriteMode overwriteOption;
    protected TSizeInBytes expectedFileSize;

    public AnonymousPtPData(TSURL toSURL, TLifeTimeInSeconds pinLifetime, TLifeTimeInSeconds fileLifetime, TFileStorageType fileStorageType, TSpaceToken spaceToken, TSizeInBytes expectedFileSize, TURLPrefix transferProtocols, TOverwriteMode overwriteOption, TReturnStatus status, TTURL transferURL) throws InvalidPtPDataAttributesException, InvalidFileTransferDataAttributesException, InvalidSurlRequestDataAttributesException {
        super(toSURL, transferProtocols, status, transferURL);
        if (pinLifetime == null || fileLifetime == null || spaceToken == null || fileStorageType == null || expectedFileSize == null || overwriteOption == null) {
            throw new InvalidPtPDataAttributesException(toSURL, pinLifetime, fileLifetime, fileStorageType, spaceToken, expectedFileSize, transferProtocols, overwriteOption, status, transferURL);
        }
        this.spaceToken = spaceToken;
        this.pinLifetime = pinLifetime;
        this.fileLifetime = fileLifetime;
        this.fileStorageType = fileStorageType;
        this.expectedFileSize = expectedFileSize;
        this.overwriteOption = overwriteOption;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public final TSpaceToken getSpaceToken() {
        return this.spaceToken;
    }

    @Override
    public TLifeTimeInSeconds pinLifetime() {
        return this.pinLifetime;
    }

    @Override
    public TLifeTimeInSeconds fileLifetime() {
        return this.fileLifetime;
    }

    @Override
    public TFileStorageType fileStorageType() {
        return this.fileStorageType;
    }

    @Override
    public TSizeInBytes expectedFileSize() {
        return this.expectedFileSize;
    }

    @Override
    public TOverwriteMode overwriteOption() {
        return this.overwriteOption;
    }

    @Override
    public void changeStatusSRM_SPACE_AVAILABLE(String explanation) {
        this.setStatus(TStatusCode.SRM_SPACE_AVAILABLE, explanation);
    }

    @Override
    public void changeStatusSRM_DUPLICATION_ERROR(String explanation) {
        this.setStatus(TStatusCode.SRM_DUPLICATION_ERROR, explanation);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PtPChunkData\n");
        sb.append("toSURL=");
        sb.append(this.SURL);
        sb.append("; ");
        sb.append("pinLifetime=");
        sb.append(this.pinLifetime);
        sb.append("; ");
        sb.append("fileLifetime=");
        sb.append(this.fileLifetime);
        sb.append("; ");
        sb.append("fileStorageType=");
        sb.append(this.fileStorageType);
        sb.append("; ");
        sb.append("spaceToken=");
        sb.append(this.spaceToken);
        sb.append("; ");
        sb.append("expectedFileSize=");
        sb.append(this.expectedFileSize);
        sb.append("; ");
        sb.append("transferProtocols=");
        sb.append(this.transferProtocols);
        sb.append("; ");
        sb.append("overwriteOption=");
        sb.append(this.overwriteOption);
        sb.append("; ");
        sb.append("status=");
        sb.append(this.status);
        sb.append("; ");
        sb.append("transferURL=");
        sb.append(this.transferURL);
        sb.append("; ");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.SURL.hashCode();
        hash = 37 * hash + this.pinLifetime.hashCode();
        hash = 37 * hash + this.fileLifetime.hashCode();
        hash = 37 * hash + this.fileStorageType.hashCode();
        hash = 37 * hash + this.spaceToken.hashCode();
        hash = 37 * hash + this.expectedFileSize.hashCode();
        hash = 37 * hash + this.transferProtocols.hashCode();
        hash = 37 * hash + this.overwriteOption.hashCode();
        hash = 37 * hash + this.status.hashCode();
        hash = 37 * hash + this.transferURL.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnonymousPtPData)) {
            return false;
        }
        AnonymousPtPData cd = (AnonymousPtPData)o;
        return this.SURL.equals(cd.SURL) && this.pinLifetime.equals(cd.pinLifetime) && this.fileLifetime.equals(cd.fileLifetime) && this.fileStorageType.equals(cd.fileStorageType) && this.spaceToken.equals(cd.spaceToken) && this.expectedFileSize.equals(cd.expectedFileSize) && this.transferProtocols.equals(cd.transferProtocols) && this.overwriteOption.equals(cd.overwriteOption) && this.status.equals(cd.status) && this.transferURL.equals(cd.transferURL);
    }
}

