/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.AnonymousFileTransferData;
import it.grid.storm.catalogs.InvalidFileTransferDataAttributesException;
import it.grid.storm.catalogs.InvalidPtGDataAttributesException;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.PtGData;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousPtGData
extends AnonymousFileTransferData
implements PtGData {
    private static final Logger log = LoggerFactory.getLogger(AnonymousPtGData.class);
    protected TLifeTimeInSeconds pinLifeTime;
    protected TDirOption dirOption;
    protected TSizeInBytes fileSize;

    public AnonymousPtGData(TSURL SURL2, TLifeTimeInSeconds lifeTime, TDirOption dirOption, TURLPrefix desiredProtocols, TSizeInBytes fileSize, TReturnStatus status, TTURL transferURL) throws InvalidPtGDataAttributesException, InvalidFileTransferDataAttributesException, InvalidSurlRequestDataAttributesException {
        super(SURL2, desiredProtocols, status, transferURL);
        if (lifeTime == null || dirOption == null || fileSize == null) {
            throw new InvalidPtGDataAttributesException(SURL2, lifeTime, dirOption, desiredProtocols, fileSize, status, transferURL);
        }
        this.pinLifeTime = lifeTime;
        this.dirOption = dirOption;
        this.fileSize = fileSize;
    }

    @Override
    public TLifeTimeInSeconds getPinLifeTime() {
        return this.pinLifeTime;
    }

    @Override
    public TDirOption getDirOption() {
        return this.dirOption;
    }

    @Override
    public TSizeInBytes getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(TSizeInBytes size) {
        if (size != null) {
            this.fileSize = size;
        }
    }

    @Override
    public void changeStatusSRM_FILE_PINNED(String explanation) {
        this.setStatus(TStatusCode.SRM_FILE_PINNED, explanation);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PtGChunkData [pinLifeTime=");
        builder.append(this.pinLifeTime);
        builder.append(", dirOption=");
        builder.append(this.dirOption);
        builder.append(", fileSize=");
        builder.append(this.fileSize);
        builder.append(", transferProtocols=");
        builder.append(this.transferProtocols);
        builder.append(", SURL=");
        builder.append(this.SURL);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", transferURL=");
        builder.append(this.transferURL);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dirOption == null ? 0 : this.dirOption.hashCode());
        result = 31 * result + (this.fileSize == null ? 0 : this.fileSize.hashCode());
        result = 31 * result + (this.pinLifeTime == null ? 0 : this.pinLifeTime.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnonymousPtGData other = (AnonymousPtGData)obj;
        if (this.dirOption == null ? other.dirOption != null : !this.dirOption.equals(other.dirOption)) {
            return false;
        }
        if (this.fileSize == null ? other.fileSize != null : !this.fileSize.equals(other.fileSize)) {
            return false;
        }
        return !(this.pinLifeTime == null ? other.pinLifeTime != null : !this.pinLifeTime.equals(other.pinLifeTime));
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

