/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer.ftp;

import it.grid.storm.balancer.ftp.GridFtpConnectionStatus;
import it.grid.storm.balancer.ftp.TelnetClientPipelineFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetClient {
    private static final Logger logger = LoggerFactory.getLogger(TelnetClient.class);
    private static final int maxStatusUpdateRetryAttempts = 3;
    private static final long statusUpdateMaxWait = 1L;

    public static boolean check(InetSocketAddress address) throws Exception {
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        HandlerObserver observer = new HandlerObserver();
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new TelnetClientPipelineFactory(observer));
        bootstrap.setOption("connectTimeoutMillis", (Object)5000);
        logger.debug("Connecting to Gridftp at " + address.toString());
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)address);
        Channel channel = channelFuture.awaitUninterruptibly().getChannel();
        if (!channelFuture.isSuccess()) {
            logger.info("GridFTP Telnet connection to server " + address.toString() + "failed. Cause : " + channelFuture.getCause());
            bootstrap.releaseExternalResources();
            return false;
        }
        logger.debug("Channel created successfully");
        if (!channel.isConnected()) {
            logger.info("GridFTP Telnet connection failed " + address.toString() + "failed. Cause : " + channelFuture.getCause());
            bootstrap.releaseExternalResources();
            return false;
        }
        logger.debug("Connection succeeded");
        int failedAttempts = 0;
        boolean failed = false;
        boolean response = false;
        do {
            failed = false;
            try {
                observer.waitForUpdates(1L);
                if (observer.hasResponse()) {
                    response = observer.getResponse();
                    continue;
                }
                ++failedAttempts;
                failed = true;
            }
            catch (Exception e) {
                logger.warn("Unable to check handler response. Exception : " + e.getMessage());
                ++failedAttempts;
                failed = true;
            }
        } while (failed && failedAttempts <= 3);
        channel.close().awaitUninterruptibly();
        bootstrap.releaseExternalResources();
        return response;
    }

    private static class HandlerObserver
    implements Observer {
        private Boolean response = null;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition updated = this.lock.newCondition();

        private HandlerObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Observable o, Object arg) {
            this.lock.lock();
            try {
                logger.debug("Managing an update");
                GridFtpConnectionStatus s = (GridFtpConnectionStatus)o;
                this.response = s.isGridFtpConnectionValid();
                this.updated.signalAll();
            }
            catch (Exception e) {
                this.response = false;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForUpdates(long secondsToWait) {
            this.lock.lock();
            try {
                if (!this.hasResponse()) {
                    logger.debug("Waiting for updates");
                    this.updated.await(secondsToWait, TimeUnit.SECONDS);
                } else {
                    logger.debug("No need to wait, response available");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean hasResponse() {
            return this.response != null;
        }

        public boolean getResponse() throws IllegalStateException {
            if (this.response == null) {
                throw new IllegalStateException("Observer not yet modified, you have to wait");
            }
            return this.response;
        }
    }
}

