/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer.ftp;

public enum FtpReplyCode {
    GENERIC_PRELIMINARY(199),
    COMMAND_OK(200),
    SYSTEM_STATUS(211),
    SERVICE_READY(220),
    SERVICE_CLOSING(221),
    GENERIC_POSITIVE(299),
    GENERIC_POSITIVE_INTERMEDIATE(399),
    SERVICE_NOT_AVAILABLE(421),
    GENERIC_TRANSIENT_NEGATIVE(499),
    NOT_LOGGED_IN(530),
    GENERIC_PERMANENT_NEGATIVE(599),
    GENERIC_PROTECTED(699),
    UNKNOWN_ERROR(999);

    private final int code;

    private FtpReplyCode(int code) {
        this.code = code;
    }

    public int getValue() {
        return this.code;
    }

    public static boolean isPositivePreliminary(int code) {
        return code >= 100 && code < 200;
    }

    public static boolean isPositiveCompletion(int code) {
        return code >= 200 && code < 300;
    }

    public static boolean isPositiveIntermediate(int code) {
        return code >= 300 && code < 400;
    }

    public static boolean isTransientNegative(int code) {
        return code >= 400 && code < 500;
    }

    public static boolean isPermanentNegative(int code) {
        return code >= 500 && code < 600;
    }

    public static boolean isProtectedReply(int code) {
        return code >= 600 && code < 700;
    }

    public static FtpReplyCode find(int v) {
        for (FtpReplyCode code : FtpReplyCode.values()) {
            if (code.getValue() != v) continue;
            return code;
        }
        if (FtpReplyCode.isPositivePreliminary(v)) {
            return GENERIC_PRELIMINARY;
        }
        if (FtpReplyCode.isPositiveCompletion(v)) {
            return GENERIC_POSITIVE;
        }
        if (FtpReplyCode.isPositiveIntermediate(v)) {
            return GENERIC_POSITIVE_INTERMEDIATE;
        }
        if (FtpReplyCode.isTransientNegative(v)) {
            return GENERIC_TRANSIENT_NEGATIVE;
        }
        if (FtpReplyCode.isPermanentNegative(v)) {
            return GENERIC_PERMANENT_NEGATIVE;
        }
        return UNKNOWN_ERROR;
    }

    public String toString() {
        return this.name() + " (" + this.code + ")";
    }
}

