/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer.ftp;

import it.grid.storm.balancer.AbstractNode;
import it.grid.storm.balancer.ftp.CheckControlChannel;
import it.grid.storm.namespace.model.Protocol;
import java.net.InetSocketAddress;

public class FTPNode
extends AbstractNode {
    private static final String prefix = Protocol.GSIFTP.getProtocolPrefix();

    public FTPNode(String hostname, int port) {
        super(hostname, port);
    }

    public FTPNode(String hostname, int port, int weight) {
        super(hostname, port, weight);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(this.hostname);
        sb.append(":" + this.port);
        return sb.toString();
    }

    @Override
    public boolean checkServer() throws Exception {
        return CheckControlChannel.checkGFtpServer(new InetSocketAddress(this.hostname, this.port));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (prefix == null ? 0 : prefix.hashCode());
        return result;
    }
}

