/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import it.grid.storm.balancer.Node;
import it.grid.storm.balancer.RoundRobinStrategy;
import java.util.ArrayList;
import java.util.List;

public class WeightStrategy<E extends Node>
extends RoundRobinStrategy<E> {
    private ArrayList<Integer> weighedList = null;
    private int ind = 0;

    public WeightStrategy(List<E> pool) {
        super(pool);
        this.initializeList();
    }

    private void initializeList() {
        this.weighedList = new ArrayList();
        for (Node node : this.nodePool) {
            int weight = node.getWeight();
            for (int i = 0; i <= weight; ++i) {
                this.weighedList.add(this.nodePool.indexOf(node));
            }
        }
    }

    @Override
    public E getNextElement() {
        this.ind = this.ind >= this.weighedList.size() ? 0 : this.ind;
        return (E)((Node)this.nodePool.get(this.weighedList.get(this.ind++)));
    }

    @Override
    public void notifyChangeInPool() {
        this.initializeList();
    }
}

