/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import it.grid.storm.balancer.AbstractBalancingStrategy;
import it.grid.storm.balancer.BalancingStrategyException;
import it.grid.storm.balancer.CyclicCounter;
import it.grid.storm.balancer.Node;
import it.grid.storm.balancer.SmartRRManager;
import it.grid.storm.config.Configuration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartRoundRobinStrategy<E extends Node>
extends AbstractBalancingStrategy<E> {
    private static final Logger log = LoggerFactory.getLogger(SmartRoundRobinStrategy.class);
    private final CyclicCounter counter;

    public SmartRoundRobinStrategy(List<E> nodes) throws IllegalArgumentException {
        super(nodes);
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("Unable to build SmartRoundRobinStrategy, received null/empty node pool");
        }
        this.counter = new CyclicCounter(nodes.size() - 1);
        SmartRRManager manager = SmartRRManager.getInstance();
        for (Node node : nodes) {
            manager.add(node);
        }
        Long lifetime = Configuration.getInstance().getServerPoolStatusCheckTimeout();
        if (lifetime != null) {
            manager.setCacheEntryLifetime(lifetime);
        }
    }

    @Override
    public E getNextElement() throws BalancingStrategyException {
        int attempts = 0;
        SmartRRManager manager = SmartRRManager.getInstance();
        Node node = null;
        boolean responsiveFound = false;
        while (!responsiveFound) {
            ++attempts;
            node = (Node)this.nodePool.get(this.counter.next());
            try {
                responsiveFound = manager.isResponsive(node);
            }
            catch (Exception e) {
                log.warn("Unable to check the status of the The GFTP " + node.toString() + " . .Exception : " + e.getMessage());
                throw new BalancingStrategyException("Unable to check the status of the The GFTP");
            }
            if (responsiveFound || attempts < this.nodePool.size()) continue;
            log.warn("No one remote service is responsive!");
            throw new BalancingStrategyException("No remote services are responsive");
        }
        return (E)node;
    }

    @Override
    public void notifyChangeInPool() {
    }
}

