/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import it.grid.storm.balancer.Node;
import it.grid.storm.balancer.ResponsivenessCache;

public class SmartRRManager {
    private static SmartRRManager instance = new SmartRRManager();
    private long cacheEntryLifetime = 20000L;
    private final ResponsivenessCache cache = new ResponsivenessCache(this.cacheEntryLifetime);

    private SmartRRManager() {
    }

    public static SmartRRManager getInstance() {
        return instance;
    }

    public void add(Node node) {
        this.cache.addEntry(node);
    }

    public boolean isResponsive(Node node) throws Exception {
        return this.cache.getResponsiveness(node).equals((Object)ResponsivenessCache.Responsiveness.RESPONSIVE);
    }

    public void setCacheEntryLifetime(Long lifetime) {
        this.cacheEntryLifetime = lifetime;
    }
}

