/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.balancer;

import it.grid.storm.balancer.Node;

public abstract class AbstractNode
implements Node {
    protected int nodeId = 0;
    private final Integer weight;
    protected final String hostname;
    protected final int port;

    protected AbstractNode(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.weight = null;
    }

    protected AbstractNode(String hostname, int port, int weight) {
        this.hostname = hostname;
        this.port = port;
        this.weight = weight % 100;
    }

    @Override
    public int getWeight() throws IllegalStateException {
        if (this.weight != null) {
            return this.weight;
        }
        throw new IllegalStateException("No weight available for this node: " + this.toString());
    }

    public void setId(int id) {
        this.nodeId = id;
    }

    public int getId() {
        return this.nodeId;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractNode [nodeId=");
        builder.append(this.nodeId);
        builder.append(", weight=");
        builder.append(this.weight);
        builder.append(", hostname=");
        builder.append(this.hostname);
        builder.append(", port=");
        builder.append(this.port);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + this.nodeId;
        result = 31 * result + this.port;
        if (this.weight != null) {
            result = 31 * result + this.weight;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNode other = (AbstractNode)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.nodeId != other.nodeId) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.weight == other.weight;
    }
}

