/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.model;

import it.grid.storm.authz.sa.model.SpaceAccessMask;
import it.grid.storm.authz.sa.model.SpaceOperation;

public class SRMSpaceRequest {
    public static final SRMSpaceRequest PTP = new SRMSpaceRequest("srmPrepareToPut", "PTP", new SpaceOperation[]{SpaceOperation.WRITE_TO_SPACE});
    public static final SRMSpaceRequest PTG = new SRMSpaceRequest("srmPrepareToGet", "PTG", new SpaceOperation[]{SpaceOperation.READ_FROM_SPACE, SpaceOperation.REPLICATE_FROM_SPACE});
    public static final SRMSpaceRequest BOL = new SRMSpaceRequest("srmBringOnLine", "BOL", new SpaceOperation[]{SpaceOperation.STAGE_TO_SPACE, SpaceOperation.REPLICATE_FROM_SPACE});
    public static final SRMSpaceRequest CPto = new SRMSpaceRequest("srmCopy to", "CPto", new SpaceOperation[]{SpaceOperation.WRITE_TO_SPACE});
    public static final SRMSpaceRequest CPfrom = new SRMSpaceRequest("srmCopy from", "CPfrom", new SpaceOperation[]{SpaceOperation.READ_FROM_SPACE, SpaceOperation.REPLICATE_FROM_SPACE});
    public static final SRMSpaceRequest PFS = new SRMSpaceRequest("srmPurgeFromSpace", "PFS", new SpaceOperation[]{SpaceOperation.PURGE_FROM_SPACE});
    public static final SRMSpaceRequest RS = new SRMSpaceRequest("srmReleaseSpace", "RS", new SpaceOperation[]{SpaceOperation.RELEASE_SPACE});
    public static final SRMSpaceRequest QS = new SRMSpaceRequest("srmGetSpaceMetadata", "QS", new SpaceOperation[]{SpaceOperation.QUERY_SPACE, SpaceOperation.UPDATE_SPACE});
    public static final SRMSpaceRequest RM = new SRMSpaceRequest("srmRemove", "RM", new SpaceOperation[]{SpaceOperation.WRITE_TO_SPACE});
    public static final SRMSpaceRequest RMD = new SRMSpaceRequest("srmRemoveDir", "RMD", new SpaceOperation[]{SpaceOperation.WRITE_TO_SPACE});
    public static final SRMSpaceRequest MD = new SRMSpaceRequest("srmMakeDir", "MD", new SpaceOperation[]{SpaceOperation.WRITE_TO_SPACE});
    public static final SRMSpaceRequest LS = new SRMSpaceRequest("srmLS", "LS", new SpaceOperation[]{SpaceOperation.READ_FROM_SPACE});
    public static final SRMSpaceRequest MV = new SRMSpaceRequest("srmMove", "MV", new SpaceOperation[]{SpaceOperation.WRITE_TO_SPACE});
    private String description;
    private String srmOp;
    private SpaceAccessMask requestedSpaceOps;

    private SRMSpaceRequest(String description, String srmOp, SpaceOperation[] spaceOps) {
        this.description = description;
        this.srmOp = srmOp;
        this.requestedSpaceOps = new SpaceAccessMask();
        for (SpaceOperation spaceOp : spaceOps) {
            this.requestedSpaceOps.addSpaceOperation(spaceOp);
        }
    }

    public String toString() {
        String result = this.srmOp + " : " + this.description + " = " + this.requestedSpaceOps;
        return result;
    }
}

