/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.model;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.sa.AuthzDBInterface;
import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import it.grid.storm.authz.sa.model.SpaceACE;
import it.grid.storm.namespace.model.SAAuthzType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;

public class FileAuthzDB
implements AuthzDBInterface {
    private final Logger log = AuthzDirector.getLogger();
    private final PropertiesConfiguration authzDB;
    private final String acePrefix = "ace";
    private int majorVersion = -1;
    private int minorVersion = -1;
    private String versionDescription = "Unknown";
    private SAAuthzType authzDBType = SAAuthzType.UNKNOWN;
    private List<SpaceACE> spaceACL = null;

    public FileAuthzDB(PropertiesConfiguration authzDB) throws AuthzDBReaderException {
        this.authzDB = authzDB;
        this.populateHeader();
        this.spaceACL = this.populateACL();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersionDescription() {
        return this.versionDescription;
    }

    @Override
    public SAAuthzType getAuthzDBType() {
        return this.authzDBType;
    }

    public String getHeader() {
        return "" + this.getMajorVersion() + "." + this.getMinorVersion() + " - " + this.versionDescription + " [" + this.authzDBType + "]";
    }

    @Override
    public List<SpaceACE> getOrderedListOfACE() {
        return this.spaceACL;
    }

    private void populateHeader() {
        this.authzDBType = SAAuthzType.getSAType(this.authzDB.getString("Type"));
        String[] version = this.authzDB.getStringArray("Version");
        if (version != null) {
            String versionNr = version[0];
            StringTokenizer versionsNr = new StringTokenizer(versionNr, ".", false);
            if (versionsNr.countTokens() > 0) {
                this.majorVersion = Integer.parseInt(versionsNr.nextToken());
                this.minorVersion = Integer.parseInt(versionsNr.nextToken());
            }
            if (version.length > 1) {
                this.versionDescription = version[1];
            }
        }
    }

    private List<SpaceACE> populateACL() {
        this.spaceACL = new ArrayList<SpaceACE>();
        Iterator scanKeys = this.authzDB.getKeys("ace");
        while (scanKeys.hasNext()) {
            String key = (String)scanKeys.next();
            String value = this.authzDB.getString(key);
            this.log.debug("KEY:" + key + " VALUE:" + value);
        }
        return this.spaceACL;
    }
}

