/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.model;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import it.grid.storm.authz.sa.model.SubjectPattern;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.SubjectAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public abstract class FQANPattern
implements SubjectPattern {
    protected Logger log = AuthzDirector.getLogger();
    protected static final String ADMIT_ALL = ".*";
    protected String groupPatternString = null;
    protected String rolePatternString = null;
    protected Pattern groupPattern = null;
    protected Pattern rolePattern = null;

    @Override
    public abstract boolean isValidPattern() throws AuthzDBReaderException;

    @Override
    public boolean match(SubjectAttribute sa) {
        boolean result = false;
        if (sa instanceof FQAN) {
            FQAN fqan = (FQAN)sa;
            String groupSequence = fqan.getGroup();
            String roleSequence = fqan.getRole();
            Matcher groupMatcher = this.groupPattern.matcher(groupSequence);
            Matcher roleMatcher = this.rolePattern.matcher(roleSequence);
            result = groupMatcher.matches() && roleMatcher.matches();
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        result.append(" FQAN.GroupPatternMatchingRule = " + this.groupPatternString + sep);
        result.append(" FQAN.RolePatternMatchinRule = " + this.rolePatternString + sep);
        return result.toString();
    }
}

