/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.model;

import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import it.grid.storm.authz.sa.model.FQANPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EGEEFQANPattern
extends FQANPattern {
    private static Pattern fqanWildcardPattern = Pattern.compile("/[\\w-\\.]+(((/[\\w-\\.]+)*)(/\\u002A)?)(/Role=(([\\w-\\.]+)|(\\u002A)))?");
    private String fqanRE = null;
    private String voName = null;
    private final boolean checkValidity;

    public EGEEFQANPattern(String fqanRE) throws AuthzDBReaderException {
        this(fqanRE, true);
    }

    public EGEEFQANPattern(String fqanRE, boolean checkValidity) throws AuthzDBReaderException {
        this.checkValidity = checkValidity;
        this.fqanRE = fqanRE;
        if (this.isValidPattern()) {
            this.generatePattern();
        }
    }

    private void generatePattern() throws AuthzDBReaderException {
        String role = null;
        int roleIndex = this.fqanRE.indexOf("Role");
        if (roleIndex > 0) {
            role = this.fqanRE.substring(roleIndex);
            this.rolePatternString = role.substring(5);
        }
        String vogroup = null;
        vogroup = roleIndex > 0 ? this.fqanRE.substring(0, roleIndex) : this.fqanRE;
        String[] groups = vogroup.split("/");
        if (groups == null || groups.length == 1) {
            throw new AuthzDBReaderException("FQAN Pattern '" + this.fqanRE + "' does not contain VO Name and groups.");
        }
        this.voName = groups[1];
        if (groups.length > 2) {
            this.groupPatternString = "";
            for (int i = 2; i < groups.length; ++i) {
                this.groupPatternString = this.groupPatternString + "/" + groups[i];
            }
        }
        this.log.debug("voName = " + this.voName);
        this.log.debug("groupPattern = " + this.groupPatternString);
        this.log.debug("RolePattern = " + this.rolePatternString);
    }

    @Override
    public boolean isValidPattern() throws AuthzDBReaderException {
        Matcher m = fqanWildcardPattern.matcher(this.fqanRE);
        if (!m.matches()) {
            if (this.checkValidity) {
                throw new IllegalArgumentException("FQAN '" + this.fqanRE + "' is malformed (syntax: /VO[(/subgroup(s)|*)]][/Role=(role|*)])");
            }
            return false;
        }
        return true;
    }
}

