/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.model;

import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import it.grid.storm.authz.sa.model.SubjectPattern;
import it.grid.storm.griduser.DistinguishedName;
import it.grid.storm.griduser.SubjectAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DNPattern
implements SubjectPattern {
    private static final String ADMIT_ALL = ".*";
    private String dnPatternString = null;
    private String countryPatternString = null;
    private String organizationPatternString = null;
    private String organizationalUnitPatternString = null;
    private String localityPatternString = null;
    private String commonNamePatternString = null;
    private String domainComponentPatternString = null;
    private Pattern countryPattern = null;
    private Pattern organizationPattern = null;
    private Pattern organizationalUnitPattern = null;
    private Pattern localityPattern = null;
    private Pattern commonNamePattern = null;
    private Pattern domainComponentPattern = null;
    private static Pattern dnWildcardPattern = Pattern.compile("");
    protected boolean checkValidity;

    public DNPattern(String dnPatternString) throws AuthzDBReaderException {
        this(dnPatternString, true);
    }

    public DNPattern(String dnPatternString, boolean checkValidity) throws AuthzDBReaderException {
        this.dnPatternString = dnPatternString;
        this.checkValidity = checkValidity;
        if (this.isValidPattern()) {
            this.generatePattern();
        }
    }

    private void generatePattern() {
        if (this.dnPatternString == null || this.dnPatternString.equals("*")) {
            this.init("*", "*", "*", "*", "*", "*");
        } else {
            String[] rules = this.dnPatternString.split("/");
            if (rules != null) {
                int length = rules.length;
                for (int i = 0; i < length; ++i) {
                    if (rules[i].startsWith("C=")) {
                        this.countryPatternString = rules[i].substring(2, rules[i].length());
                    }
                    if (rules[i].startsWith("O=")) {
                        this.organizationPatternString = rules[i].substring(2, rules[i].length());
                    }
                    if (rules[i].startsWith("OU=")) {
                        this.organizationalUnitPatternString = rules[i].substring(3, rules[i].length());
                    }
                    if (rules[i].startsWith("L=")) {
                        this.localityPatternString = rules[i].substring(2, rules[i].length());
                    }
                    if (rules[i].startsWith("CN=")) {
                        this.commonNamePatternString = rules[i].substring(3, rules[i].length());
                    }
                    if (!rules[i].startsWith("DC=")) continue;
                    this.domainComponentPatternString = rules[i].substring(3, rules[i].length());
                }
            } else {
                this.countryPatternString = ADMIT_ALL;
                this.organizationPatternString = ADMIT_ALL;
                this.organizationalUnitPatternString = ADMIT_ALL;
                this.localityPatternString = ADMIT_ALL;
                this.commonNamePatternString = ADMIT_ALL;
                this.domainComponentPatternString = ADMIT_ALL;
            }
            this.init(this.countryPatternString, this.organizationPatternString, this.organizationalUnitPatternString, this.localityPatternString, this.commonNamePatternString, this.domainComponentPatternString);
        }
    }

    protected void init(String countryPatternString, String organizationPatternString, String organizationalUnitPatternString, String localityPatternString, String commonNamePatternString, String domainComponentPatternString) {
        this.countryPatternString = countryPatternString;
        this.organizationPatternString = organizationPatternString;
        this.organizationalUnitPatternString = organizationalUnitPatternString;
        this.localityPatternString = localityPatternString;
        this.commonNamePatternString = commonNamePatternString;
        this.domainComponentPatternString = domainComponentPatternString;
        if (countryPatternString != null) {
            if (countryPatternString.equals("*")) {
                this.countryPatternString = ADMIT_ALL;
            }
            this.countryPattern = Pattern.compile(this.countryPatternString);
        } else {
            countryPatternString = ADMIT_ALL;
            this.countryPattern = Pattern.compile(ADMIT_ALL);
        }
        if (organizationPatternString != null) {
            if (organizationPatternString.equals("*")) {
                this.organizationPatternString = ADMIT_ALL;
            }
            this.organizationPattern = Pattern.compile(this.organizationPatternString);
        } else {
            organizationPatternString = ADMIT_ALL;
            this.organizationPattern = Pattern.compile(ADMIT_ALL);
        }
        if (organizationalUnitPatternString != null) {
            if (organizationalUnitPatternString.equals("*")) {
                this.organizationalUnitPatternString = ADMIT_ALL;
            }
            this.organizationalUnitPattern = Pattern.compile(this.organizationalUnitPatternString);
        } else {
            organizationalUnitPatternString = ADMIT_ALL;
            this.organizationalUnitPattern = Pattern.compile(ADMIT_ALL);
        }
        if (localityPatternString != null) {
            if (localityPatternString.equals("*")) {
                this.localityPatternString = ADMIT_ALL;
            }
            this.localityPattern = Pattern.compile(this.localityPatternString);
        } else {
            localityPatternString = ADMIT_ALL;
            this.localityPattern = Pattern.compile(ADMIT_ALL);
        }
        if (commonNamePatternString != null) {
            if (commonNamePatternString.equals("*")) {
                this.commonNamePatternString = ADMIT_ALL;
            }
            this.commonNamePattern = Pattern.compile(this.commonNamePatternString);
        } else {
            commonNamePatternString = ADMIT_ALL;
            this.commonNamePattern = Pattern.compile(ADMIT_ALL);
        }
        if (domainComponentPatternString != null) {
            if (domainComponentPatternString.equals("*")) {
                this.domainComponentPatternString = ADMIT_ALL;
            }
            this.domainComponentPattern = Pattern.compile(this.domainComponentPatternString);
        } else {
            domainComponentPatternString = ADMIT_ALL;
            this.domainComponentPattern = Pattern.compile(ADMIT_ALL);
        }
    }

    @Override
    public boolean match(SubjectAttribute subjectAttribute) {
        boolean result = false;
        if (subjectAttribute instanceof DistinguishedName) {
            DistinguishedName dn = (DistinguishedName)subjectAttribute;
            boolean countryMatch = false;
            boolean organizationMatch = false;
            boolean localityMatch = false;
            boolean organizationalUnitMatch = false;
            boolean commonNameMatch = false;
            boolean domainComponentMatch = false;
            String countryName = dn.getCountryName();
            if (countryName != null) {
                CharSequence country = countryName.subSequence(0, countryName.length());
                Matcher countryMatcher = this.countryPattern.matcher(country);
                countryMatch = countryMatcher.find();
            } else {
                countryMatch = this.countryPatternString.equals(ADMIT_ALL);
            }
            if (!countryMatch) {
                return false;
            }
            String organizationName = dn.getOrganizationName();
            if (organizationName != null) {
                CharSequence organization = organizationName.subSequence(0, organizationName.length());
                Matcher organizationMatcher = this.organizationPattern.matcher(organization);
                organizationMatch = organizationMatcher.find();
            } else {
                organizationMatch = this.organizationPatternString.equals(ADMIT_ALL);
            }
            if (!organizationMatch) {
                return false;
            }
            String localityName = dn.getLocalityName();
            if (localityName != null) {
                CharSequence locality = localityName.subSequence(0, localityName.length());
                Matcher localityMatcher = this.localityPattern.matcher(locality);
                localityMatch = localityMatcher.find();
            } else {
                localityMatch = this.localityPatternString.equals(ADMIT_ALL);
            }
            if (!localityMatch) {
                return false;
            }
            ArrayList<String> organizationalUnitNames = dn.getOrganizationalUnitNames();
            if (organizationalUnitNames != null && !organizationalUnitNames.isEmpty()) {
                CharSequence organizationalUnit = null;
                String nameStr = null;
                Matcher organizationalUnitMatcher = null;
                Iterator<String> name = organizationalUnitNames.iterator();
                while (name.hasNext() && !(organizationalUnitMatch = (organizationalUnitMatcher = this.organizationalUnitPattern.matcher(organizationalUnit = (nameStr = name.next()).subSequence(0, nameStr.length()))).find())) {
                }
            } else {
                organizationalUnitMatch = this.organizationalUnitPatternString.equals(ADMIT_ALL);
            }
            if (!organizationalUnitMatch) {
                return false;
            }
            ArrayList<String> commonNames = dn.getCommonNames();
            if (commonNames != null && !commonNames.isEmpty()) {
                CharSequence commonName = null;
                String commonNameStr = null;
                Matcher commonNameMatcher = null;
                Iterator<String> scanCN = commonNames.iterator();
                while (scanCN.hasNext() && !(commonNameMatch = (commonNameMatcher = this.commonNamePattern.matcher(commonName = (commonNameStr = scanCN.next()).subSequence(0, commonNameStr.length()))).find())) {
                }
            } else {
                commonNameMatch = this.commonNamePatternString.equals(ADMIT_ALL);
            }
            if (!commonNameMatch) {
                return false;
            }
            ArrayList<String> domainComponents = dn.getDomainComponents();
            if (domainComponents != null && !domainComponents.isEmpty()) {
                CharSequence domainComponent = null;
                String domainComponentStr = null;
                Matcher domainComponentMatcher = null;
                Iterator<String> scanDC = domainComponents.iterator();
                while (scanDC.hasNext() && !(domainComponentMatch = (domainComponentMatcher = this.domainComponentPattern.matcher(domainComponent = (domainComponentStr = scanDC.next()).subSequence(0, domainComponentStr.length()))).find())) {
                }
            } else {
                domainComponentMatch = this.commonNamePatternString.equals(ADMIT_ALL);
            }
            if (!domainComponentMatch) {
                return false;
            }
            result = countryMatch && organizationMatch && organizationalUnitMatch && localityMatch && commonNameMatch && domainComponentMatch;
            return result;
        }
        return result;
    }

    @Override
    public boolean isValidPattern() throws AuthzDBReaderException {
        Matcher m = dnWildcardPattern.matcher(this.dnPatternString);
        if (!m.matches()) {
            if (this.checkValidity) {
                throw new IllegalArgumentException("DN '" + this.dnPatternString + "'");
            }
            return false;
        }
        return true;
    }
}

