/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.conf;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;

public class FileAuthzDBWatcher {
    private final Logger log = AuthzDirector.getLogger();
    private String authzDBPath;
    private Map<String, AuthzDBFileStatus> authzDBfiles;
    private final long delay = 1000L;
    private long period = -1L;
    private Timer timer = new Timer();
    private FileWatcher fWatcher = new FileWatcher();
    private FilenameFilter authzDBFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".authz");
        }
    };

    public FileAuthzDBWatcher(long period, String authzDBPath) throws AuthzDBReaderException {
        this.authzDBfiles = new HashMap<String, AuthzDBFileStatus>();
        AuthzDBFileStatus status = AuthzDBFileStatus.ERROR1;
        File authzPath = new File(authzDBPath);
        if (!authzPath.exists()) {
            throw new AuthzDBReaderException("AuthzDBPath '" + authzDBPath + "' does not exists!");
        }
        if (!authzPath.isDirectory()) {
            throw new AuthzDBReaderException("AuthzDBPath '" + authzDBPath + "' is not a directory!");
        }
        String[] authzDBs = authzPath.list(this.authzDBFileFilter);
        this.log.debug("Found " + authzDBs.length + " authzDBs in '" + authzDBPath + "' path.");
        for (String authzDB : authzDBs) {
            this.authzDBfiles.put(authzDB, status);
        }
        this.authzDBPath = authzDBPath;
        this.period = period;
    }

    public void watchAuthzDBFile(String dbFileName) throws AuthzDBReaderException {
        AuthzDBFileStatus status = null;
        File f = new File(dbFileName);
        status = f.exists() ? AuthzDBFileStatus.WARN : AuthzDBFileStatus.ERROR2;
        this.authzDBfiles.put(dbFileName, status);
        this.fWatcher.addFileToWatch(dbFileName);
    }

    public Map<String, AuthzDBFileStatus> getObservedAuthzDBFiles() {
        return this.authzDBfiles;
    }

    public void startWatching() {
        this.timer.schedule((TimerTask)this.fWatcher, 1000L, this.period);
        this.log.debug("AuthzDB-Watcher started.");
        this.log.debug(" and observing the files: " + this.authzDBfiles);
    }

    public void onChange(String dbFileName) {
        this.authzDBfiles.put(dbFileName, AuthzDBFileStatus.OK);
    }

    public void authzDBParsed(String dbFileName) {
        long parsingTime = System.currentTimeMillis();
        this.fWatcher.setParsingTime(dbFileName, parsingTime);
        this.log.debug("Authz DB '" + dbFileName + "' parsed");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        int count = 1;
        for (String element : this.authzDBfiles.keySet()) {
            sb.append(91 + count + "] - ");
            sb.append(element);
            sb.append('<');
            sb.append("Last Modification: ");
            File f = new File(element);
            Date dM = new Date(f.lastModified());
            sb.append(formatter.format(dM));
            sb.append(" - Parsed: ");
            Date dP = new Date(this.fWatcher.getParsingTime(element));
            sb.append(formatter.format(dP));
            sb.append('>');
            ++count;
        }
        return sb.toString();
    }

    private class FileWatcher
    extends TimerTask {
        private Map<String, Long> lastModification = new HashMap<String, Long>();

        public void addFileToWatch(String dbFileName) {
            this.lastModification.put(dbFileName, Long.MIN_VALUE);
        }

        public void setParsingTime(String dbFileName, long parsingTime) {
            this.lastModification.put(dbFileName, parsingTime);
            FileAuthzDBWatcher.this.log.debug("Watcher updated with the occurred parsing of '" + dbFileName + "'");
        }

        public long getParsingTime(String dbFileName) {
            if (this.lastModification.containsKey(dbFileName)) {
                return this.lastModification.get(dbFileName);
            }
            return -1L;
        }

        @Override
        public void run() {
            FileAuthzDBWatcher.this.log.debug("File Watcher is refreshing for AuthzDB files.");
            File authzPath = new File(FileAuthzDBWatcher.this.authzDBPath);
            String[] authzDBs = authzPath.list(FileAuthzDBWatcher.this.authzDBFileFilter);
            FileAuthzDBWatcher.this.log.debug("Found " + authzDBs.length + " authzDBs in '" + FileAuthzDBWatcher.this.authzDBPath + "' path.");
            for (String authzDB : authzDBs) {
                if (FileAuthzDBWatcher.this.authzDBfiles.containsKey(authzDB)) continue;
                FileAuthzDBWatcher.this.authzDBfiles.put(authzDB, AuthzDBFileStatus.ERROR1);
                FileAuthzDBWatcher.this.log.debug("Found a new authz files ('" + authzDB + "')in authzDB path.");
            }
            for (String fileName : this.lastModification.keySet()) {
                File f = new File(fileName);
                if (!f.exists()) {
                    FileAuthzDBWatcher.this.log.error("Unable to find the AuthzDB file '" + fileName + "' ");
                    FileAuthzDBWatcher.this.authzDBfiles.put(fileName, AuthzDBFileStatus.ERROR2);
                }
                if (f.lastModified() <= this.lastModification.get(fileName)) continue;
                FileAuthzDBWatcher.this.log.debug("Found authzDB '" + fileName + "' modified!");
                FileAuthzDBWatcher.this.onChange(fileName);
            }
        }
    }

    public static enum AuthzDBFileStatus {
        ERROR1("exists in path but it is not defined in Namespace."),
        ERROR2("exists in Namespace but it does not exists in path."),
        WARN("AuthzDB exists but it does not be parsed yet."),
        OK("AuthzDB exists and it was parsed.");

        private final String msg;

        private AuthzDBFileStatus(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return this.msg;
        }
    }
}

