/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.sa.conf;

import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.sa.AuthzDBInterface;
import it.grid.storm.authz.sa.AuthzDBReaderInterface;
import it.grid.storm.authz.sa.conf.AuthzDBReaderException;
import it.grid.storm.authz.sa.conf.FileAuthzDBWatcher;
import it.grid.storm.authz.sa.model.FileAuthzDB;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;

public class FileAuthzDBReader
implements AuthzDBReaderInterface {
    private final Logger log = AuthzDirector.getLogger();
    private long period = 5000L;
    private String authzDBPath;
    private final FileAuthzDBWatcher authzDBWatcher;
    private Map<String, FileAuthzDB> authzDBs;
    private Map<String, Long> parsedTime;

    public FileAuthzDBReader(long period, String authzDBPath) throws AuthzDBReaderException {
        this.authzDBPath = authzDBPath;
        this.authzDBWatcher = new FileAuthzDBWatcher(period, authzDBPath);
        this.authzDBs = new HashMap<String, FileAuthzDB>();
    }

    @Override
    public void addAuthzDB(String dbFileName) throws AuthzDBReaderException {
        this.authzDBWatcher.watchAuthzDBFile(this.getAbsoluteAuthzDBName(dbFileName));
    }

    @Override
    public AuthzDBInterface getAuthzDB(String dbFileName) throws AuthzDBReaderException {
        String authzDBName = this.getAuthzDBName(dbFileName);
        if (this.authzDBs.containsKey(authzDBName)) {
            return this.authzDBs.get(authzDBName);
        }
        throw new AuthzDBReaderException("Unable to retrieve '" + authzDBName + "'.");
    }

    @Override
    public List<String> getAuthzDBNames() {
        return new ArrayList<String>(this.authzDBs.keySet());
    }

    @Override
    public long getLastParsed(String dbFileName) throws AuthzDBReaderException {
        String authzDBFileName = this.getAbsoluteAuthzDBName(dbFileName);
        File authzFile = new File(authzDBFileName);
        authzFile.lastModified();
        return 0L;
    }

    @Override
    public void onChangeAuthzDB(String authzDBName) throws AuthzDBReaderException {
        try {
            PropertiesConfiguration authzdb = new PropertiesConfiguration(authzDBName);
            FileAuthzDB fileAuthzDB = new FileAuthzDB(authzdb);
            this.authzDBs.put(authzDBName, fileAuthzDB);
            long pTime = System.currentTimeMillis();
            this.parsedTime.put(authzDBName, new Long(pTime));
            this.log.debug("Bound FileAuthzDBReader with " + authzDBName);
        }
        catch (ConfigurationException ex) {
            ex.printStackTrace();
            throw new AuthzDBReaderException("Unable to parse the AuthzDB '" + authzDBName + "'.");
        }
        this.authzDBWatcher.authzDBParsed(authzDBName);
    }

    private String getAbsoluteAuthzDBName(String dbFileName) {
        String absoluteName = null;
        if (!dbFileName.contains(File.separator)) {
            if (this.authzDBPath == null || this.authzDBPath.equals("")) {
                this.authzDBPath = System.getProperty("user.dir") + File.separator + "etc";
            }
            dbFileName = this.authzDBPath + File.separator + dbFileName;
        }
        File f = new File(dbFileName);
        absoluteName = f.getAbsolutePath();
        return absoluteName;
    }

    private String getAuthzDBName(String dbFileName) {
        String authzName = dbFileName;
        if (dbFileName.contains(File.separator)) {
            authzName = dbFileName.substring(dbFileName.indexOf(File.separator));
        }
        return authzName;
    }
}

