/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.remote.resource;

import it.grid.storm.authz.path.model.PathOperation;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.remote.resource.PermissionEvaluator;
import it.grid.storm.authz.remote.resource.RequestParameters;
import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/authorization/1.1/{filePath}")
public class AuthorizationResource {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationResource.class);

    @GET
    @Path(value="/read/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserReadPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving read operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), PathOperation.READ_FILE).toString();
    }

    @GET
    @Path(value="/write/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserWritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving write operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), PathOperation.WRITE_FILE).toString();
    }

    @GET
    @Path(value="/ptp/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserPTPPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving prepareToPut operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.PTP).toString();
    }

    @GET
    @Path(value="/ptpOverwrite/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserPTPOverwritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving prepareToPut Overwrite operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return new Boolean(PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.PTP_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/ptg/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserPTGPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving prepareToGet operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.PTG).toString();
    }

    @GET
    @Path(value="/rm/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserRmPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving rm operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        File file = new File(parameters.getFilePathDecoded());
        if (file.isDirectory()) {
            return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.RMD).toString();
        }
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.RM).toString();
    }

    @GET
    @Path(value="/ls/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserLsPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving ls operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.LS).toString();
    }

    @GET
    @Path(value="/mkdir/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserMkdirPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving mkdir operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MD).toString();
    }

    @GET
    @Path(value="/cpFrom/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserCpFromPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving cpFrom operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.CPfrom).toString();
    }

    @GET
    @Path(value="/cpToOverwrite/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserCpToOverwritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving cpTo Overwrite operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return new Boolean(PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.CPto_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/cpTo/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserCpToPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving cpTo operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.CPto).toString();
    }

    @GET
    @Path(value="/moveFrom/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserMvFromPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving mvFrom operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MV_source).toString();
    }

    @GET
    @Path(value="/moveToOverwrite/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserMvToOverwritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving mvTo operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return new Boolean(PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MV_dest_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/moveTo/voms/user")
    @Produces(value={"text/plain"})
    public String evaluateVomsGridUserMvToPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN, @QueryParam(value="FQANS") String FQANS) throws WebApplicationException {
        log.info("Serving mvTo operation authorization on file '" + filePath + "' User provides a VOMS proxy");
        RequestParameters parameters = new RequestParameters(filePath, DN, FQANS);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MV_dest).toString();
    }

    @GET
    @Path(value="/read/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserReadPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving read operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), PathOperation.READ_FILE).toString();
    }

    @GET
    @Path(value="/write/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserWritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving write operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), PathOperation.WRITE_FILE).toString();
    }

    @GET
    @Path(value="/ptpOverwrite/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserPTPOverwritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving prepareToPut Overwrite operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return new Boolean(PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.PTP_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/ptp/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserPTPPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving prepareToPut operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.PTP).toString();
    }

    @GET
    @Path(value="/ptg/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserPTGPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving prepareToGet operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.PTG).toString();
    }

    @GET
    @Path(value="/rm/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserRmPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving rm operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        File file = new File(parameters.getFilePathDecoded());
        if (file.isDirectory()) {
            return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.RMD).toString();
        }
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.RM).toString();
    }

    @GET
    @Path(value="/ls/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserLsPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving ls operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.LS).toString();
    }

    @GET
    @Path(value="/mkdir/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserMkdirPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving mkdir operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MD).toString();
    }

    @GET
    @Path(value="/cpFrom/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserCpFromPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving cpFrom operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.CPfrom).toString();
    }

    @GET
    @Path(value="/cpToOverwrite/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserCpToOverwritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving cpTo Overwrite operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return new Boolean(PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.CPto_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/cpTo/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserCpToPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving cpTo operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.CPto).toString();
    }

    @GET
    @Path(value="/moveFrom/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserMvFromPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving mvFrom operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MV_source).toString();
    }

    @GET
    @Path(value="/moveToOverwrite/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserMvToOverwritePermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving mvTo operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return new Boolean(PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MV_dest_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/moveTo/plain/user")
    @Produces(value={"text/plain"})
    public String evaluateGridUserMvToPermission(@PathParam(value="filePath") String filePath, @QueryParam(value="DN") String DN) throws WebApplicationException {
        log.info("Serving mvTo operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath, DN);
        return PermissionEvaluator.evaluateVomsGridUserPermission(parameters.getDNDecoded(), parameters.getFQANSDecoded(), parameters.getFilePathDecoded(), SRMFileRequest.MV_dest).toString();
    }

    @GET
    @Path(value="/read")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousReadPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous read operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), PathOperation.READ_FILE).toString();
    }

    @GET
    @Path(value="/write")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousWritePermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous write operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), PathOperation.WRITE_FILE).toString();
    }

    @GET
    @Path(value="/ptpOverwrite")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousPTPOverwritePermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous prepareToPut Overwrite operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return new Boolean(PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.PTP_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/ptp")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousPTPPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous prepareToPut operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.PTP).toString();
    }

    @GET
    @Path(value="/ptg")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousPTGPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous prepareToGet operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.PTG).toString();
    }

    @GET
    @Path(value="/rm")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousRmPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous rm operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        File file = new File(parameters.getFilePathDecoded());
        if (file.isDirectory()) {
            return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.RMD).toString();
        }
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.RM).toString();
    }

    @GET
    @Path(value="/ls")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousLsPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous ls operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.LS).toString();
    }

    @GET
    @Path(value="/mkdir")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous mkdir operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.MD).toString();
    }

    @GET
    @Path(value="/cpFrom")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousCpFromPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous cpFrom operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.CPfrom).toString();
    }

    @GET
    @Path(value="/cpTo")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousCpToPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous cpTo operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.CPto).toString();
    }

    @GET
    @Path(value="/cpToOverwrite")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousCpToOverwritePermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous cpTo Overwrite operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return new Boolean(PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.CPto_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/moveFrom")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousMvFromPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous mvFrom operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.MV_source).toString();
    }

    @GET
    @Path(value="/moveToOverwrite")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousMvToOverwritePermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous mvTo operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return new Boolean(PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.MV_dest_Overwrite) != false && PermissionEvaluator.isOverwriteAllowed() != false).toString();
    }

    @GET
    @Path(value="/moveTo")
    @Produces(value={"text/plain"})
    public String evaluateAnonymousMvToPermission(@PathParam(value="filePath") String filePath) throws WebApplicationException {
        log.info("Serving Anonymous mvTo operation authorization on file '" + filePath + "'");
        RequestParameters parameters = new RequestParameters(filePath);
        return PermissionEvaluator.evaluateAnonymousPermission(parameters.getFilePathDecoded(), SRMFileRequest.MV_dest).toString();
    }
}

