/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.model;

public enum PathOperation {
    WRITE_FILE('W', "WRITE_FILE", "Write data"),
    READ_FILE('R', "READ_FILE", "Read data", true),
    RENAME('F', "RENAME", "Rename a file or a directory"),
    DELETE('D', "DELETE", "Delete a file or a directory"),
    LIST_DIRECTORY('L', "LIST_DIRECTORY", "Listing a directory", true),
    MAKE_DIRECTORY('M', "CREATE_DIRECTORY", "Create a directory"),
    CREATE_FILE('N', "CREATE_FILE", "Create a new file"),
    UNDEFINED('?', "UNDEFINED", "Undefined");

    private final char operation;
    private final String operationName;
    private final String operationDescription;
    private final boolean readonly;

    private PathOperation(char operation, String spaceOpName, String spaceOpDesc) {
        this.operation = operation;
        this.operationName = spaceOpName;
        this.operationDescription = spaceOpDesc;
        this.readonly = false;
    }

    private PathOperation(char operation, String spaceOpName, String spaceOpDesc, boolean readonly) {
        this.operation = operation;
        this.operationName = spaceOpName;
        this.operationDescription = spaceOpDesc;
        this.readonly = readonly;
    }

    public static PathOperation getSpaceOperation(char op) {
        switch (op) {
            case 'W': {
                return WRITE_FILE;
            }
            case 'R': {
                return READ_FILE;
            }
            case 'F': {
                return RENAME;
            }
            case 'D': {
                return DELETE;
            }
            case 'L': {
                return LIST_DIRECTORY;
            }
            case 'M': {
                return MAKE_DIRECTORY;
            }
            case 'N': {
                return CREATE_FILE;
            }
        }
        return UNDEFINED;
    }

    public String toString() {
        return String.valueOf(this.operationName);
    }

    public char getSpaceOperationValue() {
        return this.operation;
    }

    public PathOperation getSpaceOp(int ordinal) {
        PathOperation[] sp = PathOperation.values();
        if (ordinal >= 0 && ordinal < sp.length) {
            return sp[ordinal];
        }
        return UNDEFINED;
    }

    public int getNumberOfPathOp() {
        return PathOperation.values().length - 1;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }
}

