/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path.model;

import it.grid.storm.authz.path.model.PathOperation;
import java.util.ArrayList;
import java.util.List;

public class PathAccessMask {
    private final List<PathOperation> pathAccessMask;
    private static List<PathOperation> operations = new ArrayList<PathOperation>(){
        {
            this.add(PathOperation.READ_FILE);
            this.add(PathOperation.LIST_DIRECTORY);
        }
    };
    public static final PathAccessMask DEFAULT = new PathAccessMask(operations);

    public PathAccessMask() {
        this.pathAccessMask = new ArrayList<PathOperation>();
    }

    public PathAccessMask(List<PathOperation> operations) {
        this.pathAccessMask = operations;
    }

    public void addPathOperation(PathOperation pathOp) {
        this.pathAccessMask.add(pathOp);
    }

    public boolean containsPathOperation(PathOperation pathOp) {
        return this.pathAccessMask.contains((Object)pathOp);
    }

    public List<PathOperation> getPathOperations() {
        return this.pathAccessMask;
    }

    public int getSize() {
        return this.pathAccessMask != null ? this.pathAccessMask.size() : 0;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof PathAccessMask) {
            PathAccessMask pOther = (PathAccessMask)other;
            if (this.pathAccessMask.size() == pOther.getSize()) {
                result = true;
                for (PathOperation element : this.pathAccessMask) {
                    if (pOther.containsPathOperation(element)) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    public String toString() {
        String pathPermissionStr = "";
        for (PathOperation pathOp : PathOperation.values()) {
            if (pathOp.equals((Object)PathOperation.UNDEFINED)) continue;
            pathPermissionStr = this.pathAccessMask.contains((Object)pathOp) ? pathPermissionStr + pathOp.getSpaceOperationValue() : pathPermissionStr + "-";
        }
        return pathPermissionStr;
    }

    public int hashCode() {
        int result = 17;
        if (this.pathAccessMask != null) {
            for (PathOperation element : this.pathAccessMask) {
                result += 31 * result + element.hashCode();
            }
        }
        return result;
    }
}

