/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.authz.path;

import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.PathAuthzInterface;
import it.grid.storm.authz.path.conf.PathAuthzDB;
import it.grid.storm.authz.path.model.PathOperation;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.common.types.StFN;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.util.userinfo.LocalGroups;
import org.slf4j.Logger;

public class PathAuthz
implements PathAuthzInterface {
    private final Logger log = AuthzDirector.getLogger();
    private final PathAuthzDB pathAuthzDB;

    public PathAuthz(PathAuthzDB pathAuthzDB) {
        this.pathAuthzDB = pathAuthzDB;
    }

    @Override
    public AuthzDecision authorize(GridUserInterface guser, SRMFileRequest pathOperation, StoRI stori) {
        return this.authorize(guser, pathOperation, stori.getStFN());
    }

    @Override
    public AuthzDecision authorize(GridUserInterface guser, SRMFileRequest pathOperation, StFN fileStFN) {
        String groupName = null;
        try {
            groupName = LocalGroups.getInstance().getGroupName(guser.getLocalUser().getPrimaryGid());
        }
        catch (CannotMapUserException e) {
            this.log.error("Unable to retrieve the local group for '" + guser + "'");
            return AuthzDecision.INDETERMINATE;
        }
        this.log.debug("<PathAuthz> Compute authorization for groupName:'" + groupName + "', filename:'" + fileStFN + "', pathOperation:'" + (Object)((Object)pathOperation) + "'");
        return this.pathAuthzDB.evaluate(groupName, fileStFN, pathOperation);
    }

    @Override
    public AuthzDecision authorize(GridUserInterface guser, PathOperation pathOperation, StFN fileStFN) {
        String groupName = null;
        try {
            groupName = LocalGroups.getInstance().getGroupName(guser.getLocalUser().getPrimaryGid());
        }
        catch (CannotMapUserException e) {
            this.log.error("Unable to retrieve the local group for '" + guser + "'");
            return AuthzDecision.INDETERMINATE;
        }
        this.log.debug("<PathAuthz> Compute authorization for groupName:'" + groupName + "', filename:'" + fileStFN + "', pathOperation:'" + (Object)((Object)pathOperation) + "'");
        return this.pathAuthzDB.evaluate(groupName, fileStFN, pathOperation);
    }

    @Override
    public AuthzDecision authorizeAnonymous(PathOperation pathOperation, StFN fileStFN) {
        this.log.debug("<PathAuthz> Compute authorization for anonymous user on filename:'" + fileStFN + "', pathOperation:'" + (Object)((Object)pathOperation) + "'");
        return this.pathAuthzDB.evaluateAnonymous(fileStFN, pathOperation);
    }

    @Override
    public AuthzDecision authorizeAnonymous(SRMFileRequest srmPathOp, StFN fileStFN) {
        this.log.debug("<PathAuthz> Compute authorization for anonymous user on filename:'" + fileStFN + "', SRMFileRequest:'" + (Object)((Object)srmPathOp) + "'");
        return this.pathAuthzDB.evaluateAnonymous(fileStFN, srmPathOp);
    }

    @Override
    public AuthzDecision authorizeAnonymous(SRMFileRequest pathOperation, StoRI storiSource, StoRI storiDest) {
        AuthzDecision result = AuthzDecision.INDETERMINATE;
        StFN sourceFileName = storiSource.getStFN();
        StFN destFileName = storiDest.getStFN();
        switch (pathOperation) {
            case CPfrom: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluateAnonymous(sourceFileName, SRMFileRequest.CPfrom);
                AuthzDecision toDec = this.pathAuthzDB.evaluateAnonymous(destFileName, SRMFileRequest.CPto);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
            case CPto: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluateAnonymous(sourceFileName, SRMFileRequest.CPfrom);
                AuthzDecision toDec = this.pathAuthzDB.evaluateAnonymous(destFileName, SRMFileRequest.CPto);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
            case MV_dest: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluateAnonymous(sourceFileName, SRMFileRequest.MV_source);
                AuthzDecision toDec = this.pathAuthzDB.evaluateAnonymous(destFileName, SRMFileRequest.MV_dest);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
            case MV_source: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluateAnonymous(sourceFileName, SRMFileRequest.MV_source);
                AuthzDecision toDec = this.pathAuthzDB.evaluateAnonymous(destFileName, SRMFileRequest.MV_dest);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
        }
        return result;
    }

    @Override
    public AuthzDecision authorize(GridUserInterface guser, SRMFileRequest pathOperation, StoRI storiSource, StoRI storiDest) {
        AuthzDecision result = AuthzDecision.INDETERMINATE;
        String groupName = null;
        try {
            int localGroup = guser.getLocalUser().getPrimaryGid();
            groupName = LocalGroups.getInstance().getGroupName(localGroup);
        }
        catch (CannotMapUserException e) {
            this.log.error("Unable to retrieve the local group for '" + guser + "'");
            groupName = "unknown";
        }
        StFN sourceFileName = storiSource.getStFN();
        StFN destFileName = storiDest.getStFN();
        switch (pathOperation) {
            case CPfrom: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluate(groupName, sourceFileName, SRMFileRequest.CPfrom);
                AuthzDecision toDec = this.pathAuthzDB.evaluate(groupName, destFileName, SRMFileRequest.CPto);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
            case CPto: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluate(groupName, sourceFileName, SRMFileRequest.CPfrom);
                AuthzDecision toDec = this.pathAuthzDB.evaluate(groupName, destFileName, SRMFileRequest.CPto);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
            case MV_dest: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluate(groupName, sourceFileName, SRMFileRequest.MV_source);
                AuthzDecision toDec = this.pathAuthzDB.evaluate(groupName, destFileName, SRMFileRequest.MV_dest);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
            case MV_source: {
                AuthzDecision fromDec = this.pathAuthzDB.evaluate(groupName, sourceFileName, SRMFileRequest.MV_source);
                AuthzDecision toDec = this.pathAuthzDB.evaluate(groupName, destFileName, SRMFileRequest.MV_dest);
                if (fromDec.equals((Object)AuthzDecision.PERMIT) && toDec.equals((Object)AuthzDecision.PERMIT)) {
                    result = AuthzDecision.PERMIT;
                    break;
                }
                if (fromDec.equals((Object)AuthzDecision.DENY) || toDec.equals((Object)AuthzDecision.DENY)) {
                    result = AuthzDecision.DENY;
                    break;
                }
                if (!fromDec.equals((Object)AuthzDecision.NOT_APPLICABLE) && !toDec.equals((Object)AuthzDecision.NOT_APPLICABLE)) break;
                result = AuthzDecision.NOT_APPLICABLE;
                break;
            }
        }
        return result;
    }
}

