/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GridFTPTransferClient;
import it.grid.storm.asynch.GridFTPTransferClientException;
import it.grid.storm.common.types.TransferProtocol;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.TTURL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.globus.ftp.ByteRangeList;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.GridFTPRestartMarker;
import org.globus.ftp.Marker;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.Options;
import org.globus.ftp.PerfMarker;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.PerfMarkerException;
import org.globus.ftp.exception.ServerException;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartGridFTPTransferClient
implements GridFTPTransferClient {
    private static Logger log = LoggerFactory.getLogger(ThirdPartGridFTPTransferClient.class);

    @Override
    public void putFile(GridUserInterface gu, TTURL source, TTURL destination) throws GridFTPTransferClientException {
        boolean secondPart;
        log.debug(" --- Third part copy --- ");
        boolean firstPart = source.protocol() == TransferProtocol.GSIFTP;
        boolean bl = secondPart = destination.protocol() == TransferProtocol.GSIFTP;
        if (!firstPart || !secondPart) {
            throw new GridFTPTransferClientException("The third part gridFTP trasfer requires both TURL in GSIFTP protocol! (first =" + firstPart + ") second =" + secondPart + ")");
        }
        String fullSourceFile = "/" + source.tfn().pfn().getValue();
        String fullDestinationFile = "/" + destination.tfn().pfn().getValue();
        log.debug("source file: " + fullSourceFile);
        log.debug("destin file: " + fullDestinationFile);
        MarkerListenerImpl listener = new MarkerListenerImpl();
        try {
            ByteArrayInputStream proxy = new ByteArrayInputStream(((AbstractGridUser)gu).getUserCredentials().getBytes());
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(new GlobusCredential((InputStream)proxy), 0);
            log.debug("Created GSS Credential from proxy");
            String remoteSourceHost = source.tfn().machine().getValue();
            int remoteSourcePort = source.tfn().port().toInt();
            log.debug("remote source GridFTP : " + remoteSourceHost + ":" + remoteSourcePort);
            GridFTPClient sourceClient = new GridFTPClient(remoteSourceHost, remoteSourcePort);
            this.setParams(sourceClient, (GSSCredential)cred);
            String remoteDestinationHost = destination.tfn().machine().getValue();
            int remoteDestinationPort = destination.tfn().port().toInt();
            log.debug("remote destination GridFTP : " + remoteDestinationHost + ":" + remoteDestinationPort);
            GridFTPClient destClient = new GridFTPClient(remoteDestinationHost, remoteDestinationPort);
            this.setParams(destClient, (GSSCredential)cred);
            int parallelism = 6;
            sourceClient.setOptions((Options)new RetrieveOptions(parallelism));
            log.debug(" Transfer parallelism : " + parallelism);
            log.debug(" Starting transfer ... ");
            sourceClient.extendedTransfer(fullSourceFile, destClient, fullDestinationFile, (MarkerListener)listener);
            log.debug(" ... transfer ended.");
            sourceClient.close();
            destClient.close();
        }
        catch (IOException e) {
            log.warn("IO Except", (Throwable)e);
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (ServerException e) {
            log.warn("Server Except", (Throwable)e);
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (ClientException e) {
            log.warn("Client Except", (Throwable)e);
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (GlobusCredentialException e) {
            log.warn("Credential Except", (Throwable)e);
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (GSSException e) {
            log.warn("GSS Except", (Throwable)e);
            throw new GridFTPTransferClientException(e.toString());
        }
        catch (Exception e) {
            log.warn("Generic Except", (Throwable)e);
            throw new GridFTPTransferClientException("Unexpected runtime error in ThirdPartGridFTPTransferClient! " + e);
        }
    }

    void setParams(GridFTPClient client, GSSCredential cred) throws Exception {
        client.authenticate(cred);
        client.setProtectionBufferSize(16384);
        client.setType(1);
        client.setMode(3);
    }

    class MarkerListenerImpl
    implements MarkerListener {
        public ByteRangeList list = new ByteRangeList();

        public void markerArrived(Marker m) {
            if (m instanceof GridFTPRestartMarker) {
                this.restartMarkerArrived((GridFTPRestartMarker)m);
            } else if (m instanceof PerfMarker) {
                this.perfMarkerArrived((PerfMarker)m);
            } else {
                log.warn("Received unsupported marker type");
            }
        }

        private void restartMarkerArrived(GridFTPRestartMarker marker) {
            log.info("--> restart marker arrived:");
            this.list.merge(marker.toVector());
            log.info("Current transfer state: " + this.list.toFtpCmdArgument());
        }

        private void perfMarkerArrived(PerfMarker marker) {
            log.info("--> perf marker arrived");
            log.info("Timestamp = " + marker.getTimeStamp());
            if (marker.hasStripeIndex()) {
                try {
                    log.info("Stripe index =" + marker.getStripeIndex());
                }
                catch (PerfMarkerException e) {
                    log.warn(e.toString());
                }
            } else {
                log.info("Stripe index: not present");
            }
            if (marker.hasStripeBytesTransferred()) {
                try {
                    log.info("Stripe bytes transferred = " + marker.getStripeBytesTransferred());
                }
                catch (PerfMarkerException e) {
                    log.warn(e.toString());
                }
            } else {
                log.info("Stripe Bytes Transferred: not present");
            }
            if (marker.hasTotalStripeCount()) {
                try {
                    log.info("Total stripe count = " + marker.getTotalStripeCount());
                }
                catch (PerfMarkerException e) {
                    log.warn(e.toString());
                }
            } else {
                log.info("Total stripe count: not present");
            }
        }
    }
}

