/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.Copy;
import it.grid.storm.asynch.CopyVisitor;
import it.grid.storm.asynch.NoSRMClientFoundException;
import it.grid.storm.asynch.SRMClient;
import it.grid.storm.asynch.SRMClientException;
import it.grid.storm.asynch.SRMClientFactory;
import it.grid.storm.asynch.SRMPrepareToPutReply;
import it.grid.storm.asynch.SRMStatusOfPutRequestReply;
import it.grid.storm.asynch.VisitableCopy;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.common.types.TransferProtocol;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import java.util.ArrayList;
import java.util.Date;

public class PushCopyPutVisitor
implements CopyVisitor {
    private final TSizeInBytes getFileSize;

    private PushCopyPutVisitor() {
        this.getFileSize = null;
    }

    public PushCopyPutVisitor(TSizeInBytes getFileSize) {
        this.getFileSize = getFileSize;
    }

    @Override
    public Copy.Result visit(VisitableCopy copy) {
        try {
            TLifeTimeInSeconds retryTime = TLifeTimeInSeconds.make(Configuration.getInstance().getSRMClientPutTotalRetryTime(), TimeUnit.SECONDS);
            try {
                copy.getLog().debug("PUSH COPY CHUNK: getting SRM client...");
                SRMClient srmClient = SRMClientFactory.getInstance().client();
                copy.getLog().debug("... got it!");
                copy.getLog().debug("PUSH COPY CHUNK: Invoking prepareToPut functionality...");
                SRMPrepareToPutReply reply = srmClient.prepareToPut(copy.getGu(), copy.getRequestData().getDestinationSURL(), copy.getRequestData().getLifetime(), copy.getRequestData().getFileStorageType(), copy.getRequestData().getSpaceToken(), this.getFileSize, TransferProtocol.GSIFTP, "StoRM Remote PtP for (push) srmCopy", copy.getRequestData().getOverwriteOption(), retryTime);
                copy.getLog().debug("... got it! Reply was: " + reply);
                long timeOut = new Date().getTime() + Configuration.getInstance().getSRMClientPutTimeOut() * 1000L;
                long sleepTime = Configuration.getInstance().getSRMClientPutSleepTime() * 1000L;
                boolean timedOut = false;
                SRMStatusOfPutRequestReply statusOfPutRequestReply = null;
                TStatusCode replyCode = null;
                try {
                    do {
                        copy.getLog().debug("PUSH COPY CHUNK: Going to sleep...");
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        copy.getLog().debug("PUSH COPY CHUNK: Waking up and verifying status...");
                        statusOfPutRequestReply = srmClient.statusOfPutRequest(reply.requestToken(), copy.getGu(), copy.getRequestData().getDestinationSURL());
                        replyCode = statusOfPutRequestReply.returnStatus().getStatusCode();
                        timedOut = new Date().getTime() > timeOut;
                        copy.getLog().debug("PUSH COPY CHUNK: reply was " + statusOfPutRequestReply + "; the reply code was: " + (Object)((Object)replyCode) + "; timedOut is:" + timedOut);
                    } while ((replyCode == TStatusCode.SRM_REQUEST_QUEUED || replyCode == TStatusCode.SRM_REQUEST_INPROGRESS || replyCode == TStatusCode.SRM_INTERNAL_ERROR) && !timedOut);
                }
                catch (SRMClientException e2) {
                    copy.getLog().error("ERROR IN PushCopyChunk! PutOperation failed: SRMClient could not do an srmStatusOfPutRequest! " + e2);
                    StringBuffer sb = new StringBuffer();
                    sb.append("Parameters passed to client: ");
                    sb.append("requestToken: ");
                    sb.append(reply.requestToken().toString());
                    sb.append(", ");
                    sb.append("GridUser: ");
                    sb.append(copy.getGu().toString());
                    sb.append(", ");
                    sb.append("toSURL: ");
                    sb.append(copy.getRequestData().getDestinationSURL().toString());
                    sb.append(".");
                    copy.getLog().debug(sb.toString());
                    return copy.buildOperationResult("SRMClient failure! Could not do an srmStatusOfPutRequest! " + e2, Copy.ResultType.PUT);
                }
                copy.getLog().debug("PUSH COPY CHUNK: out of loop ...");
                if (timedOut) {
                    copy.getLog().warn("ATTENTION IN PushCopyChunk! PutOperation timed out!");
                    return copy.buildOperationResult("PutOperation timed out!", Copy.ResultType.PUT);
                }
                copy.getLog().debug("PushCopyChunk! The PutOperation completed! " + statusOfPutRequestReply.returnStatus());
                ArrayList<Object> parameters = new ArrayList<Object>(3);
                parameters.add(1, statusOfPutRequestReply.returnStatus());
                parameters.add(2, statusOfPutRequestReply.toTURL());
                parameters.add(3, reply.requestToken());
                return copy.buildOperationResult(parameters, Copy.ResultType.PUT);
            }
            catch (SRMClientException e1) {
                copy.getLog().error("ERROR IN PushCopyChunk! PutOperation failed: SRMClient could not do an srmPrepareToPut! " + e1);
                StringBuffer sb = new StringBuffer();
                sb.append("Parameters passed to client: ");
                sb.append("GridUser:");
                sb.append(copy.getGu().toString());
                sb.append(", ");
                sb.append("toSURL:");
                sb.append(copy.getRequestData().getDestinationSURL().toString());
                sb.append(", ");
                sb.append("lifetime:");
                sb.append(copy.getRequestData().getLifetime().toString());
                sb.append(", ");
                sb.append("fileStorageType:");
                sb.append(copy.getRequestData().getFileStorageType().toString());
                sb.append(", ");
                sb.append("spaceToken:");
                sb.append(copy.getRequestData().getSpaceToken().toString());
                sb.append(", ");
                sb.append("fileSize:");
                sb.append(copy.getRequestData().toString());
                sb.append(", ");
                sb.append("transferProtocol:");
                sb.append(TransferProtocol.GSIFTP.toString());
                sb.append(", ");
                sb.append("description:");
                sb.append("StoRM Remote PtP for (push) srmCopy");
                sb.append(", ");
                sb.append("overwriteOption:");
                sb.append(copy.getRequestData().getOverwriteOption().toString());
                sb.append(", ");
                sb.append("retryTime:");
                sb.append(retryTime.toString());
                sb.append(".");
                copy.getLog().debug(sb.toString());
                return copy.buildOperationResult("SRMClient failure! Could not do an srmPrepareToPut! " + e1, Copy.ResultType.PUT);
            }
            catch (NoSRMClientFoundException e1) {
                copy.getLog().error("ERROR IN PushCopyChunk! Cannot call remote SRM server because no SRM client could be loaded! " + e1, (Object)Copy.ResultType.PUT);
                return copy.buildOperationResult("Cannot talk to other SRM server because no SRM client could be loaded!", Copy.ResultType.PUT);
            }
        }
        catch (IllegalArgumentException e3) {
            copy.getLog().error("ERROR IN PushCopyChunk! Cannot create TLifeTimeInSeconds! " + e3);
            return copy.buildOperationResult(e3.toString(), Copy.ResultType.PUT);
        }
    }
}

