/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.PtP;
import it.grid.storm.catalogs.PtPChunkCatalog;
import it.grid.storm.catalogs.PtPData;
import it.grid.storm.catalogs.PtPPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.scheduler.PersistentRequestChunk;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.data.InputData;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtPPersistentChunk
extends PtP
implements PersistentRequestChunk {
    private static Logger log = LoggerFactory.getLogger(PtPPersistentChunk.class);
    private final RequestSummaryData rsd;
    private final GlobalStatusManager gsm;

    public PtPPersistentChunk(RequestSummaryData summaryData, PtPPersistentChunkData chunkData, GlobalStatusManager gsm) throws InvalidRequestAttributesException, IllegalArgumentException {
        super(chunkData);
        if (summaryData == null || gsm == null) {
            throw new IllegalArgumentException("Unable to instantiate the object, illegal arguments: summaryData=" + summaryData + " chunkData=" + chunkData);
        }
        this.rsd = summaryData;
        this.gsm = gsm;
    }

    @Override
    public String getName() {
        return "PtPChunk of request " + this.rsd.requestToken() + " for SURL " + this.requestData.getSURL();
    }

    @Override
    public String getRequestToken() {
        return this.rsd.requestToken().toString();
    }

    @Override
    public void persistStatus() {
        log.debug("Persisting status of request : " + this.rsd.requestToken() + " on SURL " + this.requestData.getSURL());
        PtPChunkCatalog.getInstance().update((PtPPersistentChunkData)this.requestData);
    }

    @Override
    public void updateGlobalStatus() {
        log.debug("Updating global status for request : " + this.rsd.requestToken() + " on SURL " + this.requestData.getSURL());
        if (this.failure) {
            this.gsm.failedChunk((PtPPersistentChunkData)this.requestData);
        } else if (this.spacefailure) {
            this.gsm.expiredSpaceLifetimeChunk((PtPPersistentChunkData)this.requestData);
        } else {
            this.gsm.successfulChunk((PtPPersistentChunkData)this.requestData);
        }
    }

    @Override
    protected void printRequestOutcome(PtPData inputData) {
        if (inputData != null) {
            if (inputData.getSURL() != null) {
                if (this.rsd.requestToken() != null) {
                    CommandHelper.printRequestOutcome("srmPrepareToPut", log, inputData.getStatus(), inputData, this.rsd.requestToken(), Arrays.asList(inputData.getSURL().toString()));
                } else {
                    CommandHelper.printRequestOutcome("srmPrepareToPut", log, inputData.getStatus(), (InputData)inputData, Arrays.asList(inputData.getSURL().toString()));
                }
            } else if (this.rsd.requestToken() != null) {
                CommandHelper.printRequestOutcome("srmPrepareToPut", log, inputData.getStatus(), (InputData)inputData, this.rsd.requestToken());
            } else {
                CommandHelper.printRequestOutcome("srmPrepareToPut", log, inputData.getStatus(), inputData);
            }
        } else {
            CommandHelper.printRequestOutcome("srmPrepareToPut", log, CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "No input available"));
        }
    }
}

