/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.acl.AclManagerFSAndHTTPS;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.Request;
import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.catalogs.PtPData;
import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.catalogs.VolatileAndJiTCatalog;
import it.grid.storm.config.Configuration;
import it.grid.storm.ea.StormEA;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.InvalidPermissionOnFileException;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.info.SpaceInfoManager;
import it.grid.storm.namespace.ExpiredSpaceTokenException;
import it.grid.storm.namespace.InvalidGetTURLProtocolException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.TURLBuildingException;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.ACLEntry;
import it.grid.storm.namespace.model.DefaultACL;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.scheduler.Chooser;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.Streets;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtP
implements Delegable,
Chooser,
Request {
    protected static final String SRM_COMMAND = "srmPrepareToPut";
    private static Logger log = LoggerFactory.getLogger(PtP.class);
    protected final PtPData requestData;
    protected final Calendar start;
    protected boolean failure = false;
    protected boolean spacefailure = false;

    public PtP(PtPData chunkData) throws InvalidRequestAttributesException {
        if (chunkData == null) {
            throw new IllegalArgumentException("Unable to instanciate the object, invalid arguments: chunkData=" + chunkData);
        }
        this.requestData = chunkData;
        this.start = Calendar.getInstance();
    }

    @Override
    public void doIt() {
        log.debug("Handling PtP chunk for user DN: " + DataHelper.getRequestor(this.requestData) + "; for SURL: " + this.requestData.getSURL());
        if (!this.verifySurlStatusTransition(this.requestData.getSURL(), this.requestData.getRequestToken())) {
            this.failure = true;
            this.requestData.changeStatusSRM_FILE_BUSY("The surl " + this.requestData.getSURL() + " is currently busy");
            log.info("Unable to perform the PTP request, surl busy");
            this.printRequestOutcome(this.requestData);
            return;
        }
        this.requestData.changeStatusSRM_REQUEST_INPROGRESS("request in progress");
        StoRI fileStoRI = null;
        if (this.requestData instanceof IdentityInputData) {
            try {
                fileStoRI = NamespaceDirector.getNamespace().resolveStoRIbySURL(this.requestData.getSURL(), ((IdentityInputData)((Object)this.requestData)).getUser());
            }
            catch (UnapprochableSurlException e) {
                this.requestData.changeStatusSRM_INVALID_PATH("Invalid SURL path specified");
                this.failure = true;
                log.info("Unable to build a stori for surl " + this.requestData.getSURL() + " for user " + DataHelper.getRequestor(this.requestData) + " UnapprochableSurlException: " + e.getMessage());
                this.printRequestOutcome(this.requestData);
                return;
            }
            catch (IllegalArgumentException e) {
                this.failure = true;
                this.requestData.changeStatusSRM_INTERNAL_ERROR("Unable to get StoRI for surl " + this.requestData.getSURL());
                log.error("Unable to get StoRI for surl " + this.requestData.getSURL() + " IllegalArgumentException: " + e.getMessage());
                this.printRequestOutcome(this.requestData);
                return;
            }
        }
        try {
            fileStoRI = NamespaceDirector.getNamespace().resolveStoRIbySURL(this.requestData.getSURL());
        }
        catch (UnapprochableSurlException e) {
            this.failure = true;
            log.info("Unable to build a stori for surl " + this.requestData.getSURL() + " UnapprochableSurlException: " + e.getMessage());
            this.requestData.changeStatusSRM_INVALID_PATH("This surl is not managed by this StoRM instance");
            this.printRequestOutcome(this.requestData);
            return;
        }
        boolean exists = false;
        try {
            exists = fileStoRI.getLocalFile().exists();
        }
        catch (SecurityException e) {
            this.requestData.changeStatusSRM_FAILURE("StoRM is not allowed to work on requested file!");
            this.failure = true;
            log.error("ATTENTION in PtPChunk! PtPChunk received a SecurityException from Java SecurityManager: StoRM cannot check for the existence of file: " + fileStoRI.getLocalFile().toString() + "; exception: " + e);
            this.printRequestOutcome(this.requestData);
            return;
        }
        if (!exists) {
            this.manageNotExistentFile(fileStoRI);
        } else if (this.requestData.overwriteOption() == TOverwriteMode.ALWAYS || this.requestData.overwriteOption() == TOverwriteMode.WHENFILESAREDIFFERENT) {
            this.manageOverwriteExistingFile(fileStoRI);
        } else if (this.requestData.overwriteOption() == TOverwriteMode.NEVER) {
            this.requestData.changeStatusSRM_DUPLICATION_ERROR("Cannot srmPut file because it already exists!");
            this.failure = true;
        } else {
            this.requestData.changeStatusSRM_FAILURE("Unexpected overwrite option! Processing failed!");
            this.failure = true;
            log.error("UNEXPECTED ERROR in PtPChunk! The specified overwrite option is unknown!");
            log.error("Received Overwrite Option: " + this.requestData.overwriteOption());
        }
        this.printRequestOutcome(this.requestData);
    }

    private boolean verifySurlStatusTransition(TSURL surl, TRequestToken requestToken) {
        Map<TRequestToken, TReturnStatus> statuses = SurlStatusManager.getSurlCurrentStatuses(surl);
        statuses.remove(requestToken);
        return TStatusCode.SRM_SPACE_AVAILABLE.isCompatibleWith(statuses.values());
    }

    private void manageNotExistentFile(StoRI fileStoRI) {
        AuthzDecision decision = this.requestData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)this.requestData)).getUser(), SRMFileRequest.PTP, fileStoRI) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.PTP, fileStoRI.getStFN());
        if (decision == null) {
            this.manageAnomaly(decision);
            return;
        }
        switch (decision) {
            case PERMIT: {
                this.managePermit(fileStoRI);
                break;
            }
            case DENY: {
                this.manageDeny();
                break;
            }
            default: {
                this.manageAnomaly(decision);
            }
        }
    }

    private void manageOverwriteExistingFile(StoRI fileStoRI) {
        AuthzDecision decision = this.requestData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)this.requestData)).getUser(), SRMFileRequest.RM, fileStoRI) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.RM, fileStoRI.getStFN());
        if (decision.equals((Object)AuthzDecision.PERMIT)) {
            this.managePermit(fileStoRI);
        } else if (decision.equals((Object)AuthzDecision.DENY)) {
            this.requestData.changeStatusSRM_AUTHORIZATION_FAILURE("Write access to " + this.requestData.getSURL() + " denied!");
            this.failure = true;
            log.debug("Write access to " + this.requestData.getSURL() + " for user " + DataHelper.getRequestor(this.requestData) + " denied!");
        } else {
            this.manageAnomaly(decision);
        }
    }

    private void managePermit(StoRI fileStoRI) {
        boolean canTraverse;
        TTURL auxTURL;
        TSpaceToken token = new SpaceHelper().getTokenFromStoRI(log, fileStoRI);
        SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
        boolean isSpaceAuthorized = this.requestData instanceof IdentityInputData ? spaceAuth.authorize(((IdentityInputData)((Object)this.requestData)).getUser(), SRMSpaceRequest.PTP) : spaceAuth.authorizeAnonymous(SRMSpaceRequest.PTP);
        if (!isSpaceAuthorized) {
            this.requestData.changeStatusSRM_AUTHORIZATION_FAILURE("Create/Write access for " + this.requestData.getSURL() + " in Storage Area: " + token + " denied!");
            this.failure = true;
            log.debug("Create/Write access for " + this.requestData.getSURL() + " in Storage Area: " + token + " denied!");
            return;
        }
        try {
            auxTURL = fileStoRI.getTURL(this.requestData.getTransferProtocols());
        }
        catch (IllegalArgumentException e) {
            this.requestData.changeStatusSRM_FAILURE("Unable to decide TURL!");
            this.failure = true;
            log.error("ERROR in PtPChunk! Null TURLPrefix in PtPChunkData caused StoRI to be unable to establish TTURL! IllegalArgumentException: " + e);
            return;
        }
        catch (InvalidGetTURLProtocolException e) {
            this.requestData.changeStatusSRM_NOT_SUPPORTED("Unable to build TURL with specified transfer protocols!");
            this.failure = true;
            log.error("ERROR in PtPChunk! No valid transfer protocol found.");
            return;
        }
        catch (TURLBuildingException e) {
            this.requestData.changeStatusSRM_FAILURE("Unable to build the TURL for the provided transfer protocol");
            this.failure = true;
            log.error("ERROR in PtPChunk! There was a failure building the TURL. : TURLBuildingException " + e);
            return;
        }
        try {
            canTraverse = this.managePermitTraverseStep(fileStoRI);
            log.debug("PtPChunk: finished TraverseStep for " + fileStoRI.getAbsolutePath());
        }
        catch (CannotMapUserException e) {
            this.requestData.changeStatusSRM_FAILURE("Unable to find local user for " + DataHelper.getRequestor(this.requestData));
            this.failure = true;
            log.error("ERROR in PtGChunk! Unable to find LocalUser for " + DataHelper.getRequestor(this.requestData) + "! CannotMapUserException: " + e.getMessage());
            return;
        }
        if (canTraverse && this.managePermitReserveSpaceStep(fileStoRI)) {
            boolean canWrite;
            try {
                canWrite = this.managePermitSetFileStep(fileStoRI);
            }
            catch (CannotMapUserException e) {
                this.requestData.changeStatusSRM_FAILURE("Unable to find local user for " + DataHelper.getRequestor(this.requestData));
                this.failure = true;
                log.error("ERROR in PtGChunk! Unable to find LocalUser for " + DataHelper.getRequestor(this.requestData) + "! CannotMapUserException: " + e.getMessage());
                return;
            }
            if (canWrite) {
                log.debug("PTP CHUNK. Addition of ReadWrite ACL on file successfully completed for " + fileStoRI.getAbsolutePath());
                this.requestData.setTransferURL(auxTURL);
                this.requestData.changeStatusSRM_SPACE_AVAILABLE("srmPrepareToPut successfully handled!");
                this.failure = false;
                if (this.requestData.fileStorageType() == TFileStorageType.VOLATILE) {
                    VolatileAndJiTCatalog.getInstance().trackVolatile(fileStoRI.getPFN(), Calendar.getInstance(), this.requestData.fileLifetime());
                }
            }
        }
    }

    private boolean managePermitTraverseStep(StoRI fileStoRI) throws CannotMapUserException {
        if (this.requestData instanceof IdentityInputData) {
            return this.verifyPath(fileStoRI) && this.setParentAcl(fileStoRI, ((IdentityInputData)((Object)this.requestData)).getUser().getLocalUser());
        }
        if (this.verifyPath(fileStoRI)) {
            this.setHttpsServiceParentAcl(fileStoRI);
            return true;
        }
        return false;
    }

    private boolean verifyPath(StoRI fileStoRI) {
        for (StoRI parentStoRI : fileStoRI.getParents()) {
            boolean exists = parentStoRI.getLocalFile().exists();
            if (exists && parentStoRI.getLocalFile().isDirectory()) continue;
            String errorString = "The requested SURL is: " + fileStoRI.getSURL().toString() + ", but its parent " + parentStoRI.getSURL().toString();
            errorString = !exists ? errorString + "does not exist!" : errorString + "is not a directory!";
            this.requestData.changeStatusSRM_INVALID_PATH(errorString);
            this.failure = true;
            log.debug(errorString + " Parent points to " + parentStoRI.getLocalFile().toString() + ".");
            return false;
        }
        return true;
    }

    private boolean setParentAcl(StoRI fileStoRI, LocalUser localUser) {
        log.debug("PtPChunk: setting parent traverse ACL for " + fileStoRI.getAbsolutePath() + " to user " + localUser);
        boolean automaticDirectoryCreation = Configuration.getInstance().getAutomaticDirectoryCreation();
        for (StoRI parentStoRI : fileStoRI.getParents()) {
            LocalFile parentFile = parentStoRI.getLocalFile();
            log.debug("PtPChunk TraverseStep - processing parent " + parentFile.toString());
            if (!this.prepareDirectory(parentFile, automaticDirectoryCreation)) {
                log.warn("Unable to perform directory preparation step on parent file " + parentFile.getAbsolutePath());
                this.failure = true;
                return false;
            }
            try {
                if (this.setAcl(parentStoRI, localUser, FilesystemPermission.Traverse, fileStoRI.hasJustInTimeACLs())) continue;
                this.requestData.changeStatusSRM_FAILURE("Local filesystem mask does not allow setting up correct ACLs for PtG!");
                this.failure = true;
                return false;
            }
            catch (Exception e) {
                this.requestData.changeStatusSRM_INTERNAL_ERROR("Local filesystem has problems manipulating ACE!");
                this.failure = true;
                return false;
            }
        }
        return true;
    }

    private boolean prepareDirectory(LocalFile f, boolean canCreate) throws SecurityException {
        if (!f.exists() && !canCreate) {
            this.requestData.changeStatusSRM_INVALID_PATH("Directory structure as specified in SURL does not exist!");
            this.failure = true;
            log.debug("ATTENTION in PtPChunk! Directory structure as specified in " + f + " does not exist, and automatic directory creation is disbaled! Failing this chunk of request!");
            return false;
        }
        if (!f.exists() && f.mkdirs()) {
            this.requestData.changeStatusSRM_INTERNAL_ERROR("Local filesystem error: could not crete directory!");
            this.failure = true;
            log.error("ERROR in PtPChunk! Filesystem was unable to successfully create directory: " + f.toString());
            return false;
        }
        return true;
    }

    private boolean managePermitSetFileStep(StoRI fileStoRI) throws CannotMapUserException {
        if (this.requestData instanceof IdentityInputData) {
            if (this.managePermitSetFileStep(fileStoRI, ((IdentityInputData)((Object)this.requestData)).getUser().getLocalUser())) {
                this.setDefaultAcl(fileStoRI);
                this.setTapeManagementAcl(fileStoRI);
                return true;
            }
            return false;
        }
        this.setDefaultAcl(fileStoRI);
        this.setTapeManagementAcl(fileStoRI);
        this.setHttpsServiceAcl(fileStoRI.getLocalFile(), FilesystemPermission.ReadWrite);
        return true;
    }

    private boolean managePermitSetFileStep(StoRI fileStoRI, LocalUser localUser) {
        log.debug("PtPChunk: setting RW ACL for " + fileStoRI.getAbsolutePath() + " for user " + localUser);
        try {
            if (!this.setAcl(fileStoRI, localUser, FilesystemPermission.ReadWrite, fileStoRI.hasJustInTimeACLs())) {
                this.requestData.changeStatusSRM_FAILURE("Local filesystem mask does not allow setting up correct ACLs for PtP!");
                this.failure = true;
                return false;
            }
        }
        catch (Exception e) {
            this.requestData.changeStatusSRM_INTERNAL_ERROR("Local filesystem has problems manipulating ACE!");
            this.failure = true;
            return false;
        }
        return true;
    }

    private boolean setAcl(StoRI parentStoRI, LocalUser localUser, FilesystemPermission permission, boolean hasJustInTimeACLs) throws Exception {
        if (hasJustInTimeACLs) {
            return this.setJiTAcl(parentStoRI, localUser, permission);
        }
        return this.setAoTAcl(parentStoRI, localUser, permission);
    }

    private boolean setJiTAcl(StoRI fileStori, LocalUser localUser, FilesystemPermission permission) throws Exception {
        boolean response;
        log.debug("SrmMkdir: Adding JiT ACL " + permission + " to user " + localUser + " for directory : '" + fileStori.getAbsolutePath() + "'");
        try {
            AclManagerFSAndHTTPS.getInstance().grantUserPermission(fileStori.getLocalFile(), localUser, permission);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant user traverse permission on parent file. IllegalArgumentException: " + e.getMessage());
            return false;
        }
        FilesystemPermission fp = fileStori.getLocalFile().getEffectiveUserPermission(localUser);
        if (fp != null) {
            if (fp.allows(permission)) {
                VolatileAndJiTCatalog.getInstance().trackJiT(fileStori.getPFN(), localUser, permission, this.start, this.requestData.pinLifetime());
                response = true;
            } else {
                log.error("ATTENTION in PtPChunk! The local filesystem has a mask that does not allow " + permission + " User-ACL to " + "be set up on" + fileStori.getLocalFile().toString() + "!");
                response = false;
            }
        } else {
            log.error("ERROR in PtPChunk! A " + permission + " User-ACL was set on " + fileStori.getAbsolutePath() + " for user " + localUser.toString() + " but when subsequently verifying its effectivity," + " a null ACE was found!");
            throw new Exception("Unable to verify user ACL");
        }
        return response;
    }

    private boolean setAoTAcl(StoRI fileStori, LocalUser localUser, FilesystemPermission permission) throws Exception {
        boolean response;
        log.debug("SrmMkdir: Adding AoT ACL " + permission + " to user " + localUser + " for directory : '" + fileStori.getAbsolutePath() + "'");
        try {
            AclManagerFSAndHTTPS.getInstance().grantGroupPermission(fileStori.getLocalFile(), localUser, permission);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant user traverse permission on parent file. IllegalArgumentException: " + e.getMessage());
            return false;
        }
        FilesystemPermission fp = fileStori.getLocalFile().getEffectiveGroupPermission(localUser);
        if (fp != null) {
            if (fp.allows(permission)) {
                response = true;
            } else {
                log.error("ATTENTION in PtPChunk! The local filesystem has a mask that does not allow Traverse Group-ACL to be set up on" + fileStori.getLocalFile().toString() + "!");
                response = false;
            }
        } else {
            log.error("ERROR in PtPChunk! A Traverse Group-ACL was set on " + fileStori.getAbsolutePath() + " for user " + localUser.toString() + " but when subsequently verifying its effectivity, " + "a null ACE was found!");
            response = false;
        }
        return response;
    }

    private void setHttpsServiceParentAcl(StoRI fileStoRI) {
        log.debug("SrmMkdir: Adding parent https ACL for directory : '" + fileStoRI.getAbsolutePath() + "' parents");
        for (StoRI parentStoRI : fileStoRI.getParents()) {
            this.setHttpsServiceAcl(parentStoRI.getLocalFile(), FilesystemPermission.Traverse);
        }
    }

    private void setHttpsServiceAcl(LocalFile file, FilesystemPermission permission) {
        log.debug("SrmMkdir: Adding https ACL " + permission + "for directory : '" + file + "'");
        try {
            AclManagerFSAndHTTPS.getInstance().grantHttpsServiceGroupPermission(file, permission);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant user permission on the created folder. IllegalArgumentException: " + e.getMessage());
            this.requestData.getStatus().extendExplaination("Unable to grant group permission on the created folder");
        }
    }

    private boolean managePermitReserveSpaceStep(StoRI fileStoRI) {
        log.debug("PtPChunk: entered ReserveSpaceStep for " + fileStoRI.getAbsolutePath());
        TSizeInBytes size = this.requestData.expectedFileSize();
        TSpaceToken spaceToken = this.requestData.getSpaceToken();
        LocalFile localFile = fileStoRI.getLocalFile();
        VirtualFSInterface fs = fileStoRI.getVirtualFileSystem();
        if (fs != null && fs.getProperties().isOnlineSpaceLimited()) {
            SpaceHelper sp = new SpaceHelper();
            long freeSpace = sp.getSAFreeSpace(log, fileStoRI);
            if (sp.isSAFull(log, fileStoRI) || !size.isEmpty() && freeSpace != -1L && freeSpace <= size.value()) {
                TSpaceToken SASpaceToken = sp.getTokenFromStoRI(log, fileStoRI);
                if (SASpaceToken == null || SASpaceToken.isEmpty()) {
                    log.error("PtPChunk - ReserveSpaceStep: Unable to get a valid TSpaceToken for stori " + fileStoRI + " . Unable to verify storage area space initialization");
                    this.requestData.changeStatusSRM_FAILURE("No valid space token for the Storage Area");
                    this.failure = true;
                    return false;
                }
                if (!sp.isSAInitialized(log, fileStoRI) && SpaceInfoManager.isInProgress(SASpaceToken)) {
                    log.debug("PtPChunk: ReserveSpaceStep: the storage area space initialization is in progress, optimistic approach, considering we got enough space");
                } else {
                    log.debug("PtPChunk - ReserveSpaceStep: no free space on Storage Area!");
                    this.requestData.changeStatusSRM_FAILURE("No free space on Storage Area");
                    this.failure = true;
                    return false;
                }
            }
        }
        try {
            boolean successful = localFile.createNewFile();
            if (!successful && this.requestData.overwriteOption() == TOverwriteMode.NEVER) {
                log.debug("PtPChunk - ReserveSpaceStep: no overwrite allowed! Failing chunk... ");
                this.requestData.changeStatusSRM_DUPLICATION_ERROR("Cannot srmPut file because it already exists!");
                this.failure = true;
                return false;
            }
            if (!successful && TStatusCode.SRM_SPACE_AVAILABLE.equals(SurlStatusManager.getSurlStatus(this.requestData.getSURL()))) {
                this.requestData.changeStatusSRM_FILE_BUSY("Requested file is still in SRM_SPACE_AVAILABLE state!");
                this.failure = true;
                log.debug("ATTENTION in PtPChunk! PtPChunk received request for SURL that is still in SRM_SPACE_AVAILABLE state!");
                return false;
            }
            if (spaceToken.isEmpty() && size.isEmpty()) {
                log.debug("PtPChunk - ReserveSpaceStep: no SpaceToken and no FileSize specified; mock file will be created... ");
            } else if (spaceToken.isEmpty() && !size.isEmpty()) {
                log.debug("PtPChunk - ReserveSpaceStep: no SpaceToken available but there is a FileSize specified; implicit space reservation taking place...");
                fileStoRI.allotSpaceForFile(size);
            } else if (!spaceToken.isEmpty() && !size.isEmpty()) {
                log.debug("PtPChunk - ReserveSpaceStep: SpaceToken available and FileSize specified; reserving space by token...");
                if (!this.isExistingSpaceToken(spaceToken)) {
                    this.requestData.changeStatusSRM_INVALID_REQUEST("The provided Space Token does not exists");
                    log.info("PtPChunk execution failed. The space token " + spaceToken + " provided by user does not exists");
                    return false;
                }
                fileStoRI.allotSpaceByToken(spaceToken, size);
            } else {
                log.debug("PtPChunk - ReserveSpaceStep: SpaceToken available and FileSize specified; reserving space by token...");
                if (!this.isExistingSpaceToken(spaceToken)) {
                    this.requestData.changeStatusSRM_INVALID_REQUEST("The provided Space Token does not exists");
                    log.info("PtPChunk execution failed. The space token " + spaceToken + " provided by user does not exists");
                    return false;
                }
                fileStoRI.allotSpaceByToken(spaceToken);
            }
            log.debug("PtPChunk: finished ReserveSpaceStep for " + fileStoRI.getAbsolutePath());
            return true;
        }
        catch (SecurityException e) {
            this.requestData.changeStatusSRM_FAILURE("Space Management step in srmPrepareToPut failed!");
            this.failure = true;
            log.error("ERROR in PtPChunk! During space reservation step in PtP, could not create file: " + localFile.toString() + "; Java s SecurityManager does not allow writing the file! " + e);
            return false;
        }
        catch (IOException e) {
            this.requestData.changeStatusSRM_FAILURE("Space Management step in srmPrepareToPut failed!");
            this.failure = true;
            log.error("ERROR in PtPChunk! During space reservation step in PtP, an error occured while trying to create the file:" + localFile.toString() + "; error: " + e);
            return false;
        }
        catch (InvalidPermissionOnFileException e) {
            this.requestData.changeStatusSRM_FAILURE("Space Management step in srmPrepareToPut failed!");
            this.failure = true;
            log.error("ERROR in PtPChunk! During space reservation step in PtP, an attempt to create file " + localFile.toString() + " failed because StoRM lacks the privileges to do so! Exception follows: " + e);
            return false;
        }
        catch (ReservationException e) {
            this.requestData.changeStatusSRM_FAILURE("Space Management step in srmPrepareToPut failed!");
            this.failure = true;
            log.error("ERROR in PtPChunk! Space component failed! Exception follows: " + e);
            return false;
        }
        catch (ExpiredSpaceTokenException e) {
            this.requestData.changeStatusSRM_SPACE_LIFETIME_EXPIRED("The provided Space Token has expired its lifetime");
            this.spacefailure = true;
            log.info("PtPChunk execution failed. ExpiredSpaceTokenException : " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.requestData.changeStatusSRM_FAILURE("Space Management step in srmPrepareToPut failed!");
            this.failure = true;
            log.error("ERROR in PtPChunk - space Step! Unexpected error in reserve space step of PtP for file " + localFile.toString() + "! Exception follows: " + e);
            log.error("Complete error stack trace follows: ");
            StackTraceElement[] ste = e.getStackTrace();
            if (ste != null) {
                for (StackTraceElement element : ste) {
                    log.error(element.toString());
                }
            }
            return false;
        }
    }

    private boolean isExistingSpaceToken(TSpaceToken spaceToken) throws Exception {
        StorageSpaceData spaceData = null;
        try {
            spaceData = new ReservedSpaceCatalog().getStorageSpace(spaceToken);
        }
        catch (TransferObjectDecodingException e) {
            log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            throw new Exception("Error retrieving Storage Area information from Token. TransferObjectDecodingException : " + e.getMessage());
        }
        catch (DataAccessException e) {
            log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
            throw new Exception("Error retrieving Storage Area information from Token. DataAccessException : " + e.getMessage());
        }
        return spaceData != null;
    }

    private void setDefaultAcl(StoRI fileStoRI) {
        DefaultACL dacl = fileStoRI.getVirtualFileSystem().getCapabilities().getDefaultACL();
        if (dacl != null && !dacl.isEmpty()) {
            for (ACLEntry ace : dacl.getACL()) {
                if (!ace.isValid()) continue;
                log.debug("Adding DefaultACL for the gid: " + ace.getGroupID() + " with permission: " + ace.getFilePermissionString());
                LocalUser u = new LocalUser(ace.getGroupID(), ace.getGroupID());
                if (ace.getFilesystemPermission() == null) {
                    log.warn("Unable to setting up the ACL. ACl entry permission is null!");
                    continue;
                }
                try {
                    AclManagerFSAndHTTPS.getInstance().grantGroupPermission(fileStoRI.getLocalFile(), u, ace.getFilesystemPermission());
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to grant group permission on the file. IllegalArgumentException: " + e.getMessage());
                }
            }
        }
    }

    private void setTapeManagementAcl(StoRI fileStoRI) {
        if (fileStoRI.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
            long expDate = System.currentTimeMillis() / 1000L + this.requestData.pinLifetime().value();
            StormEA.setPinned(fileStoRI.getLocalFile().getAbsolutePath(), expDate);
            fileStoRI.setGroupTapeWrite();
        }
    }

    private void manageDeny() {
        this.requestData.changeStatusSRM_AUTHORIZATION_FAILURE("Create/Write access to " + this.requestData.getSURL() + " denied!");
        this.failure = true;
        log.debug("Create/Write access to " + this.requestData.getSURL() + " for user " + DataHelper.getRequestor(this.requestData) + " denied!");
    }

    private void manageAnomaly(AuthzDecision decision) {
        if (decision == null) {
            this.requestData.changeStatusSRM_FAILURE("Null policy! internal error");
            this.failure = true;
            log.error("PtPChunk: Null policy! internal error!");
            return;
        }
        switch (decision) {
            case NOT_APPLICABLE: {
                this.requestData.changeStatusSRM_FAILURE("Missing Policy! Access rights cannot be established!");
                this.failure = true;
                log.error("PtPChunk: PolicyCollector warned of missing policies for the supplied SURL!");
                log.error("Requested SURL: " + this.requestData.getSURL());
                break;
            }
            case INDETERMINATE: {
                this.requestData.changeStatusSRM_FAILURE("PolicyCollector error! Access rights cannot be established!");
                this.failure = true;
                log.error("PtPChunk: PolicyCollector encountered internal problems!");
                log.error("Requested SURL: " + this.requestData.getSURL());
                break;
            }
            default: {
                this.requestData.changeStatusSRM_FAILURE("Unexpected Policy! StoRM does not know what to do!");
                this.failure = true;
                log.error("PtPChunk: unexpected policy returned by PolicyCollector for the supplied SURL!");
                log.error("Requested SURL: " + this.requestData.getSURL());
            }
        }
    }

    @Override
    public String getName() {
        return "PtP for SURL " + this.requestData.getSURL();
    }

    @Override
    public void choose(Streets s) {
        s.ptpStreet(this);
    }

    @Override
    public String getSURL() {
        return this.requestData.getSURL().toString();
    }

    @Override
    public boolean isResultSuccess() {
        boolean result = false;
        TStatusCode statusCode = this.requestData.getStatus().getStatusCode();
        if (statusCode.getValue().equals(TStatusCode.SRM_SPACE_AVAILABLE.getValue()) || this.requestData.getStatus().isSRM_SUCCESS()) {
            result = true;
        }
        return result;
    }

    public PtPData getRequestData() {
        return this.requestData;
    }

    @Override
    public String getUserDN() {
        return DataHelper.getRequestor(this.requestData);
    }

    protected void printRequestOutcome(PtPData inputData) {
        if (inputData != null) {
            if (inputData.getSURL() != null) {
                if (inputData.getRequestToken() != null) {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), inputData, inputData.getRequestToken(), Arrays.asList(inputData.getSURL().toString()));
                } else {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), (InputData)inputData, Arrays.asList(inputData.getSURL().toString()));
                }
            } else if (inputData.getRequestToken() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), (InputData)inputData, inputData.getRequestToken());
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "No input available"));
        }
    }
}

