/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidPersistentRequestAttributesException;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.PtG;
import it.grid.storm.catalogs.PtGChunkCatalog;
import it.grid.storm.catalogs.PtGData;
import it.grid.storm.catalogs.PtGPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.scheduler.PersistentRequestChunk;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtGPersistentChunk
extends PtG
implements PersistentRequestChunk {
    private static Logger log = LoggerFactory.getLogger(PtGPersistentChunk.class);
    private final RequestSummaryData rsd;
    private final GlobalStatusManager gsm;

    public PtGPersistentChunk(RequestSummaryData summaryData, PtGPersistentChunkData chunkData, GlobalStatusManager gsm) throws InvalidRequestAttributesException, InvalidPersistentRequestAttributesException {
        super(chunkData);
        if (summaryData == null || gsm == null) {
            throw new IllegalArgumentException("Unable to instantiate the object, illegal arguments: summaryData=" + summaryData + " chunkData=" + chunkData);
        }
        this.rsd = summaryData;
        this.gsm = gsm;
    }

    @Override
    public Boolean completeRequest(TapeRecallStatus recallStatus) {
        boolean success = super.completeRequest(recallStatus);
        this.persistStatus();
        if (success) {
            this.gsm.successfulChunk((PtGPersistentChunkData)this.requestData);
            log.info("Completed PtG request (" + this.rsd.requestToken() + "), file successfully recalled from tape: " + this.requestData.getSURL().toString());
        } else {
            this.gsm.failedChunk((PtGPersistentChunkData)this.requestData);
            log.error("BoL request (" + this.rsd.requestToken() + "), file not recalled from tape: " + this.requestData.getSURL().toString());
        }
        return success;
    }

    @Override
    public String getName() {
        return "PtGChunk of request " + this.rsd.requestToken() + " for SURL " + this.requestData.getSURL();
    }

    @Override
    public String getRequestToken() {
        return this.rsd.requestToken().toString();
    }

    @Override
    public boolean isResultSuccess() {
        boolean result = false;
        if (this.requestData.getStatus().getStatusCode().equals((Object)TStatusCode.SRM_FILE_PINNED) || this.requestData.getStatus().isSRM_SUCCESS()) {
            result = true;
        }
        return result;
    }

    @Override
    public void persistStatus() {
        PtGChunkCatalog.getInstance().update((PtGPersistentChunkData)this.requestData);
    }

    @Override
    public void updateGlobalStatus() {
        if (this.requestData.getStatus().getStatusCode() != TStatusCode.SRM_REQUEST_INPROGRESS) {
            if (this.failure) {
                this.gsm.failedChunk((PtGPersistentChunkData)this.requestData);
            } else {
                this.gsm.successfulChunk((PtGPersistentChunkData)this.requestData);
            }
        }
    }

    @Override
    protected void printRequestOutcome(PtGData inputData) {
        if (inputData != null) {
            if (inputData.getSURL() != null) {
                if (this.rsd.requestToken() != null) {
                    CommandHelper.printRequestOutcome("srmPrepareToGet", log, inputData.getStatus(), inputData, this.rsd.requestToken(), Arrays.asList(inputData.getSURL().toString()));
                } else {
                    CommandHelper.printRequestOutcome("srmPrepareToGet", log, inputData.getStatus(), (InputData)inputData, Arrays.asList(inputData.getSURL().toString()));
                }
            } else if (this.rsd.requestToken() != null) {
                CommandHelper.printRequestOutcome("srmPrepareToGet", log, inputData.getStatus(), (InputData)inputData, this.rsd.requestToken());
            } else {
                CommandHelper.printRequestOutcome("srmPrepareToGet", log, inputData.getStatus(), inputData);
            }
        } else {
            CommandHelper.printRequestOutcome("srmPrepareToGet", log, CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "No input available"));
        }
    }
}

