/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.acl.AclManagerFSAndHTTPS;
import it.grid.storm.asynch.Request;
import it.grid.storm.asynch.Suspendedable;
import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.catalogs.PtGData;
import it.grid.storm.catalogs.VolatileAndJiTCatalog;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.ea.StormEA;
import it.grid.storm.filesystem.FSException;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.InvalidGetTURLProtocolException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.TURLBuildingException;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.ACLEntry;
import it.grid.storm.namespace.model.DefaultACL;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.scheduler.Chooser;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.Streets;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TTURL;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtG
implements Delegable,
Chooser,
Request,
Suspendedable {
    protected static final String SRM_COMMAND = "srmPrepareToGet";
    private static Logger log = LoggerFactory.getLogger(PtG.class);
    protected PtGData requestData;
    protected final Calendar start;
    protected boolean failure = false;
    private StoRI bupFileStori;
    private LocalFile bupLocalFile;
    private LocalUser bupLocalUser;
    private TTURL bupTURL;
    private boolean downgradedToAnonymous = false;

    public PtG(PtGData requestData) throws IllegalArgumentException {
        if (requestData == null) {
            throw new IllegalArgumentException("Unable to build the object, invalid arguments: requestData=" + requestData);
        }
        this.requestData = requestData;
        this.start = Calendar.getInstance();
    }

    @Override
    public void doIt() {
        log.debug("Handling PtG chunk for user DN: " + DataHelper.getRequestor(this.requestData) + "; for SURL: " + this.requestData.getSURL());
        if (!this.verifySurlStatusTransition(this.requestData.getSURL(), this.requestData.getRequestToken())) {
            this.failure = true;
            this.requestData.changeStatusSRM_FILE_BUSY("Requested file is busy (in an incompatible state with PTG)");
            log.info("Unable to perform the PTG request, surl busy");
            this.printRequestOutcome(this.requestData);
            return;
        }
        StoRI fileStoRI = null;
        boolean unapprochableSurl = false;
        try {
            if (!this.downgradedToAnonymous && this.requestData instanceof IdentityInputData) {
                try {
                    fileStoRI = NamespaceDirector.getNamespace().resolveStoRIbySURL(this.requestData.getSURL(), ((IdentityInputData)((Object)this.requestData)).getUser());
                }
                catch (UnapprochableSurlException e) {
                    unapprochableSurl = true;
                    log.info("Unable to build a stori for surl " + this.requestData.getSURL() + " for user " + DataHelper.getRequestor(this.requestData) + " UnapprochableSurlException: " + e.getMessage());
                }
            } else {
                try {
                    fileStoRI = NamespaceDirector.getNamespace().resolveStoRIbySURL(this.requestData.getSURL());
                }
                catch (UnapprochableSurlException e) {
                    log.info("Unable to build a stori for surl " + this.requestData.getSURL() + " UnapprochableSurlException: " + e.getMessage());
                    this.failure = true;
                    this.requestData.changeStatusSRM_INVALID_PATH("This surl is not managed by this StoRM instance");
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.failure = true;
            this.requestData.changeStatusSRM_INTERNAL_ERROR("Unable to get StoRI for surl " + this.requestData.getSURL());
            log.error("Unable to get StoRY for surl " + this.requestData.getSURL() + " IllegalArgumentException: " + e.getMessage());
        }
        if (!this.failure) {
            AuthzDecision ptgAuthz;
            if (!unapprochableSurl) {
                ptgAuthz = !this.downgradedToAnonymous && this.requestData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)this.requestData)).getUser(), SRMFileRequest.PTG, fileStoRI) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.PTG, fileStoRI.getStFN());
            } else if (this.requestData.getTransferProtocols().allows(Protocol.HTTP)) {
                try {
                    fileStoRI = NamespaceDirector.getNamespace().resolveStoRIbySURL(this.requestData.getSURL());
                }
                catch (UnapprochableSurlException e) {
                    log.info("Unable to build a stori for surl " + this.requestData.getSURL() + " UnapprochableSurlException: " + e.getMessage());
                    this.failure = true;
                    this.requestData.changeStatusSRM_INVALID_PATH("This surl is not managed by this StoRM instance");
                }
                if (!this.failure) {
                    if (fileStoRI.getVirtualFileSystem().isHttpWorldReadable()) {
                        this.downgradeToAnonymousHttpRequest();
                        ptgAuthz = AuthzDecision.PERMIT;
                    } else {
                        ptgAuthz = AuthzDecision.DENY;
                    }
                } else {
                    ptgAuthz = AuthzDecision.INDETERMINATE;
                }
            } else {
                ptgAuthz = AuthzDecision.DENY;
            }
            if (!this.failure) {
                if (ptgAuthz.equals((Object)AuthzDecision.PERMIT)) {
                    this.manageIsPermit(fileStoRI);
                } else if (ptgAuthz.equals((Object)AuthzDecision.DENY)) {
                    this.manageIsDeny();
                } else if (ptgAuthz.equals((Object)AuthzDecision.INDETERMINATE)) {
                    this.manageIsIndeterminate(ptgAuthz);
                } else {
                    this.manageIsNotApplicabale(ptgAuthz);
                }
            }
        }
        this.printRequestOutcome(this.requestData);
    }

    private void downgradeToAnonymousHttpRequest() {
        this.downgradedToAnonymous = true;
        this.requestData.getTransferProtocols().getDesiredProtocols().clear();
        this.requestData.getTransferProtocols().getDesiredProtocols().add(Protocol.HTTP);
    }

    private boolean verifySurlStatusTransition(TSURL surl, TRequestToken requestToken) {
        Map<TRequestToken, TReturnStatus> statuses = SurlStatusManager.getSurlCurrentStatuses(surl);
        statuses.remove(requestToken);
        return TStatusCode.SRM_FILE_PINNED.isCompatibleWith(statuses.values());
    }

    private void manageIsPermit(StoRI fileStoRI) {
        block26: {
            TSpaceToken token = new SpaceHelper().getTokenFromStoRI(log, fileStoRI);
            SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
            boolean isSpaceAuthorized = !this.downgradedToAnonymous && this.requestData instanceof IdentityInputData ? spaceAuth.authorize(((IdentityInputData)((Object)this.requestData)).getUser(), SRMSpaceRequest.PTG) : spaceAuth.authorizeAnonymous(SRMSpaceRequest.PTG);
            if (isSpaceAuthorized) {
                try {
                    boolean canRead;
                    boolean isOnDisk;
                    TTURL turl;
                    boolean canTraverse;
                    if (!fileStoRI.getLocalFile().exists() || fileStoRI.getLocalFile().isDirectory()) {
                        this.requestData.changeStatusSRM_INVALID_PATH("The requested file either does not exist, or it is a directory!");
                        this.failure = true;
                        log.debug("ANOMALY in PtGChunk! PolicyCollector confirms read rights on file, yet file does not exist physically! Or, an srmPrepareToGet was attempted on a directory!");
                        break block26;
                    }
                    try {
                        canTraverse = this.managePermitTraverseStep(fileStoRI);
                    }
                    catch (CannotMapUserException e) {
                        this.requestData.changeStatusSRM_FAILURE("Unable to find local user for " + DataHelper.getRequestor(this.requestData));
                        this.failure = true;
                        log.error("ERROR in PtGChunk! Unable to find LocalUser for " + DataHelper.getRequestor(this.requestData) + "! CannotMapUserException: " + e.getMessage());
                        return;
                    }
                    if (!canTraverse) break block26;
                    try {
                        turl = fileStoRI.getTURL(this.requestData.getTransferProtocols());
                    }
                    catch (TURLBuildingException e) {
                        this.requestData.changeStatusSRM_FAILURE("Unable to build the TURL for the provided transfer protocol");
                        this.failure = true;
                        log.error("ERROR in PtGChunk! There was a failure building the TURL. : TURLBuildingException " + e.getMessage());
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        this.requestData.changeStatusSRM_FAILURE("Unable to decide TURL!");
                        this.failure = true;
                        log.error("ERROR in PtGChunk! invalid TURLPrefix in PtGChunkData caused StoRI to be unable to establish TTURL! IllegalArgumentException: " + e.getMessage());
                        return;
                    }
                    catch (InvalidGetTURLProtocolException e) {
                        this.requestData.changeStatusSRM_FAILURE("Unable to decide TURL!");
                        this.failure = true;
                        log.error("ERROR in PtGChunk! invalid TURL Protocol in PtGChunkData caused StoRI to be unable to establish TTURL! InvalidGetTURLProtocolException: " + e.getMessage());
                        return;
                    }
                    if (fileStoRI.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
                        long expDate = System.currentTimeMillis() / 1000L + this.requestData.getPinLifeTime().value();
                        StormEA.setPinned(fileStoRI.getLocalFile().getAbsolutePath(), expDate);
                        fileStoRI.setGroupTapeRead();
                        try {
                            this.requestData.setFileSize(TSizeInBytes.make(fileStoRI.getLocalFile().length(), SizeUnit.BYTES));
                        }
                        catch (InvalidTSizeAttributesException e) {
                            this.requestData.changeStatusSRM_FAILURE("Unable to determine file size");
                            this.failure = true;
                            log.error("ERROR in PtGChunk! error in file size computation! InvalidTSizeAttributesException: " + e.getMessage());
                            return;
                        }
                    }
                    try {
                        isOnDisk = this.isStoriOndisk(fileStoRI);
                    }
                    catch (FSException e) {
                        this.requestData.changeStatusSRM_FAILURE("Unable to verify file disk status");
                        this.failure = true;
                        log.error("ERROR in PtGChunk! error in file on disk check! FSException: " + e.getMessage());
                        return;
                    }
                    if (!isOnDisk && fileStoRI.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
                        this.requestData.changeStatusSRM_REQUEST_INPROGRESS("Recalling file from tape");
                        String voName = null;
                        if (!this.downgradedToAnonymous && this.requestData instanceof IdentityInputData && ((IdentityInputData)((Object)this.requestData)).getUser() instanceof AbstractGridUser) {
                            voName = ((AbstractGridUser)((IdentityInputData)((Object)this.requestData)).getUser()).getVO().getValue();
                        }
                        try {
                            new TapeRecallCatalog().insertTask(this, voName, fileStoRI.getLocalFile().getAbsolutePath());
                        }
                        catch (DataAccessException e) {
                            this.requestData.changeStatusSRM_FAILURE("Unable to request file recall from tape");
                            this.failure = true;
                            log.error("ERROR in PtGChunk! error in tape recall task insertion! DataAccessException: " + e.getMessage());
                            return;
                        }
                        if (!this.downgradedToAnonymous && this.requestData instanceof IdentityInputData) {
                            try {
                                this.backupData(fileStoRI, fileStoRI.getLocalFile(), ((IdentityInputData)((Object)this.requestData)).getUser().getLocalUser(), turl);
                                break block26;
                            }
                            catch (CannotMapUserException e) {
                                this.requestData.changeStatusSRM_FAILURE("Unable to find local user for " + DataHelper.getRequestor(this.requestData));
                                this.failure = true;
                                log.error("ERROR in PtGChunk! Unable to find LocalUser for " + DataHelper.getRequestor(this.requestData) + "! CannotMapUserException: " + e.getMessage());
                                return;
                            }
                        }
                        this.backupData(fileStoRI, fileStoRI.getLocalFile(), null, turl);
                        break block26;
                    }
                    try {
                        canRead = this.managePermitReadFileStep(fileStoRI, turl);
                    }
                    catch (CannotMapUserException e) {
                        this.requestData.changeStatusSRM_FAILURE("Unable to find local user for " + DataHelper.getRequestor(this.requestData));
                        this.failure = true;
                        log.error("ERROR in PtGChunk! Unable to find LocalUser for " + DataHelper.getRequestor(this.requestData) + "! CannotMapUserException: " + e.getMessage());
                        return;
                    }
                    if (canRead) {
                        this.requestData.setTransferURL(turl);
                        this.requestData.changeStatusSRM_FILE_PINNED("srmPrepareToGet successfully handled!");
                        break block26;
                    }
                    this.requestData.changeStatusSRM_FAILURE("Local filesystem mask does not allow setting up correct ACLs for PtG!");
                }
                catch (SecurityException e) {
                    this.requestData.changeStatusSRM_FAILURE("StoRM is not allowed to work on requested file!");
                    this.failure = true;
                    log.error("ATTENTION in PtGChunk! PtGChunk received a SecurityException from Java SecurityManager; StoRM cannot check-existence or check-if-directory for: " + fileStoRI.getLocalFile().toString() + "; exception: " + e);
                }
            } else {
                this.requestData.changeStatusSRM_AUTHORIZATION_FAILURE("Read access to " + this.requestData.getSURL() + " in Storage Area: " + token + " denied!");
                this.failure = true;
                log.debug("Read access to " + this.requestData.getSURL() + " in Storage Area: " + token + " denied!");
            }
        }
    }

    private boolean managePermitTraverseStep(StoRI fileStoRI) throws CannotMapUserException {
        if (!this.downgradedToAnonymous && this.requestData instanceof IdentityInputData) {
            return this.verifyPath(fileStoRI) && this.setParentsAcl(fileStoRI, ((IdentityInputData)((Object)this.requestData)).getUser().getLocalUser());
        }
        if (this.verifyPath(fileStoRI)) {
            this.setHttpsServiceParentAcl(fileStoRI);
            return true;
        }
        return false;
    }

    private boolean verifyPath(StoRI fileStoRI) {
        for (StoRI parentStoRI : fileStoRI.getParents()) {
            boolean exists = parentStoRI.getLocalFile().exists();
            boolean isDir = parentStoRI.getLocalFile().isDirectory();
            if (exists && isDir) continue;
            String errorString = "The requested SURL is: " + fileStoRI.getSURL().toString() + ", but its parent " + parentStoRI.getSURL().toString();
            errorString = !exists ? errorString + " does not exist!" : errorString + "is not a directory!";
            this.requestData.changeStatusSRM_INVALID_PATH(errorString);
            this.failure = true;
            log.error(errorString + " Parent points to " + parentStoRI.getLocalFile().toString() + ".");
            return false;
        }
        return true;
    }

    private boolean setParentsAcl(StoRI fileStoRI, LocalUser localUser) {
        log.debug("SrmMkdir: Adding parent user ACL for directory : '" + fileStoRI.getAbsolutePath() + "' parents");
        for (StoRI parentStoRI : fileStoRI.getParents()) {
            try {
                if (this.setAcl(parentStoRI, localUser, FilesystemPermission.Traverse, fileStoRI.hasJustInTimeACLs())) continue;
                this.requestData.changeStatusSRM_FAILURE("Local filesystem mask does not allow setting up correct ACLs for PtG!");
                this.failure = true;
                return false;
            }
            catch (Exception e) {
                this.requestData.changeStatusSRM_FAILURE("Local filesystem has problems manipulating ACE!");
                this.failure = true;
                return false;
            }
        }
        return true;
    }

    private boolean managePermitReadFileStep(StoRI fileStoRI, TTURL turl) throws CannotMapUserException {
        if (!this.downgradedToAnonymous && this.requestData instanceof IdentityInputData) {
            if (this.managePermitReadFileStep(fileStoRI, fileStoRI.getLocalFile(), ((IdentityInputData)((Object)this.requestData)).getUser().getLocalUser(), turl)) {
                this.setDefaultAcl(fileStoRI, fileStoRI.getLocalFile());
                return true;
            }
            return false;
        }
        this.setDefaultAcl(fileStoRI, fileStoRI.getLocalFile());
        this.setHttpsServiceAcl(fileStoRI.getLocalFile(), FilesystemPermission.Read);
        return true;
    }

    private boolean managePermitReadFileStep(StoRI fileStoRI, LocalFile localFile, LocalUser localUser, TTURL turl) {
        try {
            if (!this.setAcl(fileStoRI, localUser, FilesystemPermission.Read, fileStoRI.hasJustInTimeACLs())) {
                this.requestData.changeStatusSRM_FAILURE("Local filesystem mask does not allow setting up correct ACLs for PtG!");
                this.failure = true;
                return false;
            }
        }
        catch (Exception e) {
            this.requestData.changeStatusSRM_INTERNAL_ERROR("Local filesystem has problems manipulating ACE!");
            this.failure = true;
            return false;
        }
        log.debug("PTG CHUNK DAO. Addition of Read ACL on file successfully completed.");
        return true;
    }

    private boolean setAcl(StoRI parentStoRI, LocalUser localUser, FilesystemPermission permission, boolean hasJustInTimeACLs) throws Exception {
        if (hasJustInTimeACLs) {
            return this.setJiTAcl(parentStoRI, localUser, permission);
        }
        return this.setAoTAcl(parentStoRI, localUser, permission);
    }

    private boolean setJiTAcl(StoRI fileStori, LocalUser localUser, FilesystemPermission permission) throws Exception {
        boolean response;
        log.debug("SrmMkdir: Adding JiT ACL " + permission + " to user " + localUser + " for directory : '" + fileStori.getAbsolutePath() + "'");
        try {
            AclManagerFSAndHTTPS.getInstance().grantUserPermission(fileStori.getLocalFile(), localUser, permission);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant user traverse permission on parent file. IllegalArgumentException: " + e.getMessage());
            return false;
        }
        FilesystemPermission fp = fileStori.getLocalFile().getEffectiveUserPermission(localUser);
        if (fp != null) {
            if (fp.allows(permission)) {
                VolatileAndJiTCatalog.getInstance().trackJiT(fileStori.getPFN(), localUser, permission, this.start, this.requestData.getPinLifeTime());
                response = true;
            } else {
                log.error("ATTENTION in PtGChunk! The local filesystem has a mask that does not allow " + permission + " User-ACL to " + "be set up on" + fileStori.getLocalFile().toString() + "!");
                response = false;
            }
        } else {
            log.error("ERROR in PTGChunk! A " + permission + " User-ACL was set on " + fileStori.getAbsolutePath() + " for user " + localUser.toString() + " but when subsequently verifying its effectivity," + " a null ACE was found!");
            throw new Exception("Unable to verify user ACL");
        }
        return response;
    }

    private boolean setAoTAcl(StoRI fileStori, LocalUser localUser, FilesystemPermission permission) throws Exception {
        boolean response;
        log.debug("SrmMkdir: Adding AoT ACL " + permission + " to user " + localUser + " for directory : '" + fileStori.getAbsolutePath() + "'");
        try {
            AclManagerFSAndHTTPS.getInstance().grantGroupPermission(fileStori.getLocalFile(), localUser, permission);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant user traverse permission on parent file. IllegalArgumentException: " + e.getMessage());
            return false;
        }
        FilesystemPermission fp = fileStori.getLocalFile().getEffectiveGroupPermission(localUser);
        if (fp != null) {
            if (fp.allows(permission)) {
                response = true;
            } else {
                log.error("ATTENTION in PtGChunk! The local filesystem has a mask that does not allow Traverse Group-ACL to be set up on" + fileStori.getLocalFile().toString() + "!");
                response = false;
            }
        } else {
            log.error("ERROR in PtGChunk! A Traverse Group-ACL was set on " + fileStori.getAbsolutePath() + " for user " + localUser.toString() + " but when subsequently verifying its effectivity, " + "a null ACE was found!");
            response = false;
        }
        return response;
    }

    private void setHttpsServiceParentAcl(StoRI fileStoRI) {
        log.debug("SrmMkdir: Adding parent https ACL for directory : '" + fileStoRI.getAbsolutePath() + "' parents");
        for (StoRI parentStoRI : fileStoRI.getParents()) {
            this.setHttpsServiceAcl(parentStoRI.getLocalFile(), FilesystemPermission.Traverse);
        }
    }

    private void setHttpsServiceAcl(LocalFile file, FilesystemPermission permission) {
        log.debug("SrmMkdir: Adding https ACL " + permission + "for directory : '" + file + "'");
        try {
            AclManagerFSAndHTTPS.getInstance().grantHttpsServiceGroupPermission(file, permission);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant user permission on the created folder. IllegalArgumentException: " + e.getMessage());
            this.requestData.getStatus().extendExplaination("Unable to grant group permission on the created folder");
        }
    }

    private void setDefaultAcl(StoRI fileStoRI, LocalFile localFile) {
        VirtualFSInterface vfs = fileStoRI.getVirtualFileSystem();
        DefaultACL acl = vfs.getCapabilities().getDefaultACL();
        if (acl != null && !acl.isEmpty()) {
            List<ACLEntry> aclList = acl.getACL();
            for (ACLEntry ace : aclList) {
                if (!ace.isValid()) continue;
                log.debug("Adding DefaultACL for the gid: " + ace.getGroupID() + " with permission: " + ace.getFilePermissionString());
                LocalUser u = new LocalUser(ace.getGroupID(), ace.getGroupID());
                if (ace.getFilesystemPermission() == null) {
                    log.warn("Unable to setting up the ACL. ACl entry permission is null!");
                    continue;
                }
                try {
                    AclManagerFSAndHTTPS.getInstance().grantGroupPermission(localFile, u, ace.getFilesystemPermission());
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to grant group permissions on the file. IllegalArgumentException: " + e.getMessage());
                }
            }
        }
    }

    private void backupData(StoRI fileStoRI, LocalFile localFile, LocalUser localUser, TTURL turl) {
        this.bupFileStori = fileStoRI;
        this.bupLocalFile = localFile;
        this.bupLocalUser = localUser;
        this.bupTURL = turl;
    }

    private boolean isStoriOndisk(StoRI storiFile) throws FSException {
        if (!storiFile.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
            return true;
        }
        return storiFile.getLocalFile().isOnDisk();
    }

    @Override
    public String getName() {
        return "PtGChunk for SURL " + this.requestData.getSURL();
    }

    @Override
    public void choose(Streets s) {
        s.ptgStreet(this);
    }

    @Override
    public Boolean completeRequest(TapeRecallStatus recallStatus) {
        Boolean success;
        block11: {
            success = false;
            if (recallStatus == TapeRecallStatus.SUCCESS) {
                try {
                    if (this.bupLocalFile.isOnDisk()) {
                        success = this.managePermitReadFileStep(this.bupFileStori, this.bupLocalFile, this.bupLocalUser, this.bupTURL);
                        if (this.bupLocalUser != null) {
                            success = this.managePermitReadFileStep(this.bupFileStori, this.bupLocalFile, this.bupLocalUser, this.bupTURL);
                        } else {
                            success = true;
                            this.setDefaultAcl(this.bupFileStori, this.bupLocalFile);
                        }
                        if (success.booleanValue()) {
                            this.requestData.setTransferURL(this.bupTURL);
                            this.requestData.changeStatusSRM_FILE_PINNED("srmPrepareToGet successfully handled!");
                        } else {
                            this.requestData.changeStatusSRM_FAILURE("Local filesystem mask does not allow setting up correct ACLs for PtG!");
                        }
                        break block11;
                    }
                    log.error("File " + this.bupLocalFile.getAbsolutePath() + " not found on the disk, but it was reported to" + " be successfully recalled from tape");
                    this.requestData.changeStatusSRM_FAILURE("Error recalling file from tape");
                }
                catch (FSException e) {
                    log.error("Unable to determine if file " + this.bupLocalFile.getAbsolutePath() + " is on disk . FSException : " + e.getMessage());
                    this.requestData.changeStatusSRM_FAILURE("Internal error: unable to determine if the file is on disk");
                }
            } else if (recallStatus == TapeRecallStatus.ABORTED) {
                this.requestData.changeStatusSRM_ABORTED("Recalling file from tape aborted");
            } else {
                this.requestData.changeStatusSRM_FAILURE("Error recalling file from tape");
            }
        }
        return success;
    }

    @Override
    public PtGData getRequestData() {
        return this.requestData;
    }

    @Override
    public String getSURL() {
        return this.requestData.getSURL().toString();
    }

    @Override
    public String getUserDN() {
        return DataHelper.getRequestor(this.requestData);
    }

    @Override
    public boolean isResultSuccess() {
        boolean result = false;
        TStatusCode statusCode = this.requestData.getStatus().getStatusCode();
        if (statusCode.getValue().equals(TStatusCode.SRM_FILE_PINNED.getValue()) || this.requestData.getStatus().isSRM_SUCCESS()) {
            result = true;
        }
        return result;
    }

    private void manageIsDeny() {
        this.requestData.changeStatusSRM_AUTHORIZATION_FAILURE("Read access to " + this.requestData.getSURL() + " denied!");
        this.failure = true;
        log.debug("Read access to " + this.requestData.getSURL() + " denied!");
    }

    private void manageIsIndeterminate(AuthzDecision ad) {
        this.requestData.changeStatusSRM_FAILURE("Failure in PolicySource prevented PolicyCollector from establishing access rights! Processing failed!");
        this.failure = true;
        log.error("ERROR in PtGChunk! PolicyCollector received an error from PolicySource!");
        log.error("Received state: " + (Object)((Object)ad));
        log.error("Requested SURL: " + this.requestData.getSURL());
    }

    private void manageIsNotApplicabale(AuthzDecision ad) {
        this.requestData.changeStatusSRM_FAILURE("No policies found for the requested SURL! Therefore access rights cannot be established! Processing cannot continue!");
        this.failure = true;
        log.warn("PtGChunk: PolicyCollector found no policy for the supplied SURL!");
        log.warn("Received state: " + (Object)((Object)ad));
        log.warn("Requested SURL: " + this.requestData.getSURL());
    }

    protected void printRequestOutcome(PtGData inputData) {
        if (inputData != null) {
            if (inputData.getSURL() != null) {
                if (inputData.getRequestToken() != null) {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), inputData, inputData.getRequestToken(), Arrays.asList(inputData.getSURL().toString()));
                } else {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), (InputData)inputData, Arrays.asList(inputData.getSURL().toString()));
                }
            } else if (inputData.getRequestToken() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), (InputData)inputData, inputData.getRequestToken());
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, inputData.getStatus(), inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "No input available"));
        }
    }
}

