/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.InvalidOverallRequestAttributeException;
import it.grid.storm.catalogs.ChunkData;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalStatusManager {
    private static Logger log = LoggerFactory.getLogger(GlobalStatusManager.class);
    private TRequestToken rt = null;
    private LinkedList<Long> chunks = new LinkedList();
    private boolean finished = false;
    private InternalState internal = InternalState.IN_PROGRESS;

    public GlobalStatusManager(TRequestToken rt) throws InvalidOverallRequestAttributeException {
        if (rt == null) {
            throw new InvalidOverallRequestAttributeException();
        }
        this.rt = rt;
    }

    public synchronized void addChunk(ChunkData c) {
        log.debug("GlobalStatusManager: asked to add chunkData " + c.getIdentifier());
        if (!this.finished && c != null) {
            if (this.chunks.contains(new Long(c.getIdentifier()))) {
                log.warn("GlobalStatusManager: chunkData NOT added because of another chunkData already added with the same identifier");
            } else {
                this.chunks.add(new Long(c.getIdentifier()));
                log.debug("GlobalStatusManager: chunkData added.");
            }
        } else {
            log.warn("GlobalStatusManager: chunkData NOT added because either it is null or finishedAdding has already been invoked!");
        }
    }

    public synchronized void finishedAdding() {
        log.debug("GlobalStatusManager: received finishedAdding signal.");
        this.finished = true;
        if (this.chunks.isEmpty()) {
            if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                this.internal = InternalState.SUCCESS;
            } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                this.internal = InternalState.FAIL;
            }
            log.debug("GlobalStatusManager: since all chunks have been processed, saving final state " + this.internal);
            this.saveRequestState();
        }
    }

    public synchronized void successfulChunk(ChunkData c) {
        log.debug("GlobalStatusManager: received successfulChunk signal for " + c);
        if (c != null && !this.chunks.isEmpty() && this.chunks.remove(new Long(c.getIdentifier()))) {
            if (this.finished && this.chunks.isEmpty()) {
                log.debug("GlobalStatusManager: finished and no more chunks left... ");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.SUCCESS;
                } else if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                    this.internal = InternalState.SUCCESS;
                } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.PARTIAL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: saving final global state " + this.internal);
                this.saveRequestState();
            } else if (this.finished && !this.chunks.isEmpty()) {
                log.debug("GlobalStatusManager: finished but there are more chunks to be processed... ");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.INTERMEDIATE_SUCCESS;
                } else if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                    this.internal = InternalState.INTERMEDIATE_SUCCESS;
                } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.PARTIAL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: transited to " + this.internal);
            } else if (!this.finished) {
                log.debug("GlobalStatusManager: still not finished adding chunks for consideration, but it is the same whether there are more to be processed or not...");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.INTERMEDIATE_SUCCESS;
                } else if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                    this.internal = InternalState.INTERMEDIATE_SUCCESS;
                } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.PARTIAL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: transited to " + this.internal);
            } else {
                log.error("ERROR IN GLOBAL STATUS EVALUATION! An impossible logic codition has materialised: it may be due to multithreading issues! Request is " + this.rt);
                this.internal = InternalState.ERROR;
            }
        } else {
            log.error("ERROR IN GLOBAL STATUS EVALUATION! There was an attempt to signal a successful Chunk, but it is either null, or there are actually no Chunks left to be considered, or it was not originally asked to be considered in the evaluation!");
            log.error("Request: " + this.rt);
            log.error("Chunk: " + c);
            this.internal = InternalState.ERROR;
        }
    }

    public synchronized void failedChunk(ChunkData c) {
        log.debug("GlobalStatusManager: received failedChunk signal for " + c);
        if (c != null && !this.chunks.isEmpty() && this.chunks.remove(new Long(c.getIdentifier()))) {
            if (this.finished && this.chunks.isEmpty()) {
                log.debug("GlobalStatusManager: finished and no more chunks left... ");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.FAIL;
                } else if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                    this.internal = InternalState.FAIL;
                } else if (this.internal == InternalState.PARTIAL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: saving final global state " + this.internal);
                this.saveRequestState();
            } else if (this.finished && !this.chunks.isEmpty()) {
                log.debug("GlobalStatusManager: finished but there are more chunks to be processed... ");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.INTERMEDIATE_FAIL;
                } else if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                    this.internal = InternalState.INTERMEDIATE_FAIL;
                } else if (this.internal == InternalState.PARTIAL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: transited to " + this.internal);
            } else if (!this.finished) {
                log.debug("GlobalStatusManager: still not finished adding chunks for consideration, but it is the same whether there are more to be processed or not...");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.INTERMEDIATE_FAIL;
                } else if (this.internal == InternalState.INTERMEDIATE_SUCCESS) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.INTERMEDIATE_FAIL) {
                    this.internal = InternalState.INTERMEDIATE_FAIL;
                } else if (this.internal == InternalState.PARTIAL) {
                    this.internal = InternalState.PARTIAL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: transited to " + this.internal);
            } else {
                log.error("ERROR IN GLOBAL STATUS EVALUATION! An impossible logic codition has materialised: it may be due to multithreading issues! Request is " + this.rt);
                this.internal = InternalState.ERROR;
            }
        } else {
            log.error("ERROR IN GLOBAL STATUS EVALUATION! There was an attempt to signal a failed Chunk, but it is either null, or there are actually no Chunks left to be considered, or it was not originally asked to be considered in the evaluation!");
            log.error("Request: " + this.rt);
            log.error("ChunkData: " + c);
            this.internal = InternalState.ERROR;
        }
    }

    public synchronized void expiredSpaceLifetimeChunk(ChunkData c) {
        log.debug("GlobalStatusManager: received expiredSpaceLifetimeChunk signal for " + c);
        if (c != null && !this.chunks.isEmpty() && this.chunks.remove(new Long(c.getIdentifier()))) {
            if (this.finished && this.chunks.isEmpty()) {
                log.debug("GlobalStatusManager: finished and no more chunks left... ");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.SPACEFAIL;
                } else if (this.internal == InternalState.SPACEFAIL) {
                    this.internal = InternalState.SPACEFAIL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: saving final global state " + this.internal);
                this.saveRequestState();
            } else if (this.finished && !this.chunks.isEmpty()) {
                log.debug("GlobalStatusManager: finished but there are more chunks to be processed... ");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.SPACEFAIL;
                } else if (this.internal == InternalState.SPACEFAIL) {
                    this.internal = InternalState.SPACEFAIL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: transited to " + this.internal);
            } else if (!this.finished) {
                log.debug("GlobalStatusManager: still not finished adding chunks for consideration, but it is the same whether there are more to be processed or not...");
                if (this.internal == InternalState.IN_PROGRESS) {
                    this.internal = InternalState.SPACEFAIL;
                } else if (this.internal == InternalState.SPACEFAIL) {
                    this.internal = InternalState.SPACEFAIL;
                } else if (this.internal == InternalState.ERROR) {
                    this.internal = InternalState.ERROR;
                } else {
                    log.error("ERROR in GlobalStatusManager: programming bug! Unexpected InternalState: " + this.internal);
                }
                log.debug("GlobalStatusManager: transited to " + this.internal);
            } else {
                log.error("ERROR IN GLOBAL STATUS EVALUATION! An impossible logic codition has materialised: it may be due to multithreading issues! Request is " + this.rt);
                this.internal = InternalState.ERROR;
            }
        } else {
            log.error("ERROR IN GLOBAL STATUS EVALUATION! There was an attempt to signal a space failed Chunk, but it is either null, or there are actually no Chunks left to be considered, or it was not originally asked to be considered in the evaluation!");
            log.error("Request: " + this.rt);
            log.error("ChunkData: " + c);
            this.internal = InternalState.ERROR;
        }
    }

    private void saveRequestState() {
        log.debug("GlobalStatusManager: invoked saveRequestState.");
        try {
            boolean updatePinFileLifetime;
            TReturnStatus retstat = null;
            if (this.internal == InternalState.ERROR) {
                updatePinFileLifetime = true;
                retstat = new TReturnStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Global status cannot be evaluated: single file status must be checked.");
            } else if (this.internal == InternalState.FAIL) {
                updatePinFileLifetime = false;
                retstat = new TReturnStatus(TStatusCode.SRM_FAILURE, "All chunks failed!");
            } else if (this.internal == InternalState.SUCCESS) {
                updatePinFileLifetime = true;
                retstat = new TReturnStatus(TStatusCode.SRM_SUCCESS, "All chunks successfully handled!");
            } else if (this.internal == InternalState.PARTIAL) {
                updatePinFileLifetime = true;
                retstat = new TReturnStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Some chunks were successful while others failed!");
            } else if (this.internal == InternalState.SPACEFAIL) {
                updatePinFileLifetime = false;
                retstat = new TReturnStatus(TStatusCode.SRM_SPACE_LIFETIME_EXPIRED, "Supplied SpaceToken has expired lifetime!");
            } else {
                updatePinFileLifetime = true;
                retstat = new TReturnStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Global status cannot be evaluated: single file status must be checked.");
                log.error("ERROR IN GLOBAL STATUS EVALUATION! " + this.internal + " was attempted to be written into persistence, but it is not a final state!");
                log.error("Request: " + this.rt);
            }
            log.debug("GlobalStatusManager: saving into persistence " + retstat);
            if (updatePinFileLifetime) {
                RequestSummaryCatalog.getInstance().updateGlobalStatusPinFileLifetime(this.rt, retstat);
            } else {
                RequestSummaryCatalog.getInstance().updateGlobalStatus(this.rt, retstat);
            }
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.error("ERROR IN GLOBAL STATUS EVALUATION! Could not create a valid TReturnStatus: this is a programming bug! " + e);
        }
    }

    private static class InternalState {
        public static InternalState IN_PROGRESS = new InternalState(){

            public String toString() {
                return "InternalState IN_PROGRESS";
            }
        };
        public static InternalState INTERMEDIATE_SUCCESS = new InternalState(){

            public String toString() {
                return "InternalState INTERMEDIATE_SUCCESS";
            }
        };
        public static InternalState INTERMEDIATE_FAIL = new InternalState(){

            public String toString() {
                return "InternalState INTERMEDIATE_FAIL";
            }
        };
        public static InternalState ERROR = new InternalState(){

            public String toString() {
                return "InternalState ERROR";
            }
        };
        public static InternalState FAIL = new InternalState(){

            public String toString() {
                return "InternalState FAIL";
            }
        };
        public static InternalState SPACEFAIL = new InternalState(){

            public String toString() {
                return "InternalState SPACEFAIL";
            }
        };
        public static InternalState SUCCESS = new InternalState(){

            public String toString() {
                return "InternalState SUCCESS";
            }
        };
        public static InternalState PARTIAL = new InternalState(){

            public String toString() {
                return "InternalState PARTIAL";
            }
        };

        private InternalState() {
        }
    }
}

