/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.Copy;
import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidCopyAttributesException;
import it.grid.storm.asynch.InvalidCopyPersistentChunkAttributesException;
import it.grid.storm.catalogs.CopyChunkCatalog;
import it.grid.storm.catalogs.CopyPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.scheduler.PersistentRequestChunk;

public abstract class CopyPersistentChunk
extends Copy
implements PersistentRequestChunk {
    protected RequestSummaryData rsd = null;
    protected GlobalStatusManager gsm = null;

    public CopyPersistentChunk(GridUserInterface gu, RequestSummaryData rsd, CopyPersistentChunkData requestData, int n, GlobalStatusManager gsm) throws InvalidCopyAttributesException, InvalidCopyPersistentChunkAttributesException {
        super(gu, requestData, n);
        if (rsd == null || gsm == null) {
            throw new InvalidCopyPersistentChunkAttributesException(gu, rsd, requestData, n, gsm);
        }
        this.rsd = rsd;
        this.gsm = gsm;
    }

    @Override
    public String getName() {
        return "RequestToken of srmCopy: " + ((CopyPersistentChunkData)this.requestData).getRequestToken();
    }

    @Override
    public void persistStatus() {
        CopyChunkCatalog.getInstance().update((CopyPersistentChunkData)this.requestData);
    }

    @Override
    public String getRequestToken() {
        return ((CopyPersistentChunkData)this.requestData).getRequestToken().getValue();
    }

    @Override
    public void updateGlobalStatus() {
        if (this.failure) {
            this.gsm.failedChunk((CopyPersistentChunkData)this.requestData);
        } else {
            this.gsm.successfulChunk((CopyPersistentChunkData)this.requestData);
        }
    }
}

