/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidCopyAttributesException;
import it.grid.storm.asynch.InvalidCopyFeederAttributesException;
import it.grid.storm.asynch.InvalidOverallRequestAttributeException;
import it.grid.storm.asynch.PushCopyPersistentChunk;
import it.grid.storm.asynch.SchedulerFacade;
import it.grid.storm.catalogs.CopyChunkCatalog;
import it.grid.storm.catalogs.CopyPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.srm.types.TSURL;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyFeeder
implements Delegable {
    private static Logger log = LoggerFactory.getLogger(CopyFeeder.class);
    private RequestSummaryData rsd = null;
    private GridUserInterface gu = null;
    private GlobalStatusManager gsm = null;

    public CopyFeeder(RequestSummaryData rsd) throws InvalidCopyFeederAttributesException {
        if (rsd == null) {
            throw new InvalidCopyFeederAttributesException(null, null, null);
        }
        if (rsd.gridUser() == null) {
            throw new InvalidCopyFeederAttributesException(rsd, null, null);
        }
        try {
            this.gu = rsd.gridUser();
            this.rsd = rsd;
            this.gsm = new GlobalStatusManager(rsd.requestToken());
        }
        catch (InvalidOverallRequestAttributeException e) {
            log.error("ATTENTION in CopyFeeder! Programming bug when creating GlobalStatusManager! " + e);
            throw new InvalidCopyFeederAttributesException(rsd, this.gu, this.gsm);
        }
    }

    @Override
    public void doIt() {
        log.debug("CopyFeeder: pre-processing " + this.rsd.requestToken());
        Collection<CopyPersistentChunkData> chunks = CopyChunkCatalog.getInstance().lookup(this.rsd.requestToken());
        if (chunks.isEmpty()) {
            log.warn("ATTENTION in CopyFeeder! This SRM Copy request contained nothing to process! " + this.rsd.requestToken());
            RequestSummaryCatalog.getInstance().failRequest(this.rsd, "This SRM Copy request contained nothing to process!");
        } else {
            this.manageChunks(chunks);
            log.debug("CopyFeeder: finished pre-processing " + this.rsd.requestToken());
        }
    }

    private void manageChunks(Collection<CopyPersistentChunkData> chunksData) {
        log.debug("CopyFeeder: number of chunks in request " + chunksData.size());
        int counter = 0;
        for (CopyPersistentChunkData chunkData : chunksData) {
            this.gsm.addChunk(chunkData);
            this.manage(chunkData, counter++);
        }
        this.gsm.finishedAdding();
    }

    private void manage(CopyPersistentChunkData chunkData, int counter) {
        log.debug("CopyFeeder: scheduling chunk... ");
        try {
            chunkData.changeStatusSRM_REQUEST_INPROGRESS("srmCopy chunk is being processed!");
            CopyChunkCatalog.getInstance().update(chunkData);
            boolean validFromSurl = TSURL.isValid(chunkData.getSURL());
            boolean validToSurl = TSURL.isValid(chunkData.getDestinationSURL());
            if (validFromSurl) {
                if (validToSurl) {
                    log.info("CopyFeeder: chunk is localCopy.");
                    log.debug("Request: " + this.rsd.requestToken());
                    log.debug("Chunk: " + chunkData);
                    SchedulerFacade.getInstance().chunkScheduler().schedule(new PushCopyPersistentChunk(this.gu, this.rsd, chunkData, counter, this.gsm));
                    log.info("CopyFeeder: chunk scheduled.");
                } else {
                    log.info("CopyFeeder: chunk is pushCopy.");
                    log.debug("Request: " + this.rsd.requestToken());
                    log.debug("Chunk: " + chunkData);
                    SchedulerFacade.getInstance().chunkScheduler().schedule(new PushCopyPersistentChunk(this.gu, this.rsd, chunkData, counter, this.gsm));
                    log.info("CopyFeeder: chunk scheduled.");
                }
            } else if (validToSurl) {
                log.warn("CopyFeeder: srmCopy in pull mode NOT supported yet!");
                log.debug("Request: " + this.rsd.requestToken());
                log.debug("Chunk: " + chunkData);
                chunkData.changeStatusSRM_NOT_SUPPORTED("srmCopy in pull mode NOT supported yet!");
                CopyChunkCatalog.getInstance().update(chunkData);
                this.gsm.failedChunk(chunkData);
            } else {
                log.warn("CopyFeeder: srmCopy contract violation! Neither fromSURL nor toSURL are this machine! Cannot do a third party SRM transfer as per protocol!");
                log.warn("Request: " + this.rsd.requestToken());
                log.warn("Chunk: " + chunkData);
                chunkData.changeStatusSRM_FAILURE("SRM protocol violation! Cannot do an srmCopy between third parties!");
                CopyChunkCatalog.getInstance().update(chunkData);
                this.gsm.failedChunk(chunkData);
            }
        }
        catch (InvalidCopyAttributesException e) {
            log.error("UNEXPECTED ERROR in CopyFeeder! Chunk could not be created!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + chunkData);
            chunkData.changeStatusSRM_FAILURE("StoRM internal error does not allow this chunk to be processed!");
            CopyChunkCatalog.getInstance().update(chunkData);
            this.gsm.failedChunk(chunkData);
        }
        catch (SchedulerException e) {
            log.error("UNEXPECTED ERROR in ChunkScheduler! Chunk could not be scheduled!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + chunkData);
            chunkData.changeStatusSRM_FAILURE("StoRM internal scheduler error prevented this chunk from being processed!");
            CopyChunkCatalog.getInstance().update(chunkData);
            this.gsm.failedChunk(chunkData);
        }
    }

    @Override
    public String getName() {
        return "CopyFeeder of request: " + this.rsd.requestToken();
    }
}

