/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.BoL;
import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidPersistentRequestAttributesException;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.catalogs.BoLChunkCatalog;
import it.grid.storm.catalogs.BoLPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.scheduler.PersistentRequestChunk;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoLPersistentChunk
extends BoL
implements PersistentRequestChunk {
    private static Logger log = LoggerFactory.getLogger(BoLPersistentChunk.class);
    private RequestSummaryData rsd = null;
    private GlobalStatusManager gsm = null;

    public BoLPersistentChunk(GridUserInterface gu, RequestSummaryData rsd, BoLPersistentChunkData chunkData, GlobalStatusManager gsm) throws InvalidRequestAttributesException, InvalidPersistentRequestAttributesException {
        super(gu, chunkData);
        if (rsd == null || gsm == null) {
            throw new InvalidPersistentRequestAttributesException(gu, rsd, chunkData, gsm);
        }
        this.rsd = rsd;
        this.gsm = gsm;
    }

    @Override
    public Boolean completeRequest(TapeRecallStatus recallStatus) {
        boolean requestSuccessfull = super.completeRequest(recallStatus);
        this.persistStatus();
        if (requestSuccessfull) {
            this.gsm.successfulChunk((BoLPersistentChunkData)this.requestData);
            log.info("Completed BoL request (" + this.rsd.requestToken() + "), file successfully recalled from tape: " + this.requestData.getSURL().toString());
        } else {
            this.gsm.failedChunk((BoLPersistentChunkData)this.requestData);
            log.error("BoL request (" + this.requestData.getRequestToken() + "), file not recalled from tape: " + this.requestData.getSURL().toString());
        }
        return requestSuccessfull;
    }

    @Override
    public String getName() {
        return "BoLChunk of request " + this.rsd.requestToken() + " for SURL " + this.requestData.getSURL();
    }

    @Override
    public String getRequestToken() {
        return this.rsd.requestToken().toString();
    }

    @Override
    public void updateGlobalStatus() {
        if (this.requestData.getStatus().getStatusCode() != TStatusCode.SRM_REQUEST_INPROGRESS) {
            if (this.failure) {
                this.gsm.failedChunk((BoLPersistentChunkData)this.requestData);
            } else {
                this.gsm.successfulChunk((BoLPersistentChunkData)this.requestData);
            }
        }
    }

    @Override
    public void persistStatus() {
        BoLChunkCatalog.getInstance().update((BoLPersistentChunkData)this.requestData);
    }
}

