/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.BoLPersistentChunk;
import it.grid.storm.asynch.GlobalStatusManager;
import it.grid.storm.asynch.InvalidBoLFeederAttributesException;
import it.grid.storm.asynch.InvalidOverallRequestAttributeException;
import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.SchedulerFacade;
import it.grid.storm.catalogs.BoLChunkCatalog;
import it.grid.storm.catalogs.BoLPersistentChunkData;
import it.grid.storm.catalogs.InvalidSurlRequestDataAttributesException;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.InvalidDescendantsAuthRequestException;
import it.grid.storm.namespace.InvalidDescendantsEmptyRequestException;
import it.grid.storm.namespace.InvalidDescendantsFileRequestException;
import it.grid.storm.namespace.InvalidDescendantsPathRequestException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.srm.types.InvalidTDirOptionAttributesException;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.synchcall.data.DataHelper;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoLFeeder
implements Delegable {
    private static Logger log = LoggerFactory.getLogger(BoLFeeder.class);
    private RequestSummaryData rsd = null;
    private GridUserInterface gu = null;
    private GlobalStatusManager gsm = null;

    public BoLFeeder(RequestSummaryData rsd) throws InvalidBoLFeederAttributesException {
        if (rsd == null) {
            throw new InvalidBoLFeederAttributesException(null, null, null);
        }
        if (rsd.gridUser() == null) {
            throw new InvalidBoLFeederAttributesException(rsd, null, null);
        }
        try {
            this.gu = rsd.gridUser();
            this.rsd = rsd;
            this.gsm = new GlobalStatusManager(rsd.requestToken());
        }
        catch (InvalidOverallRequestAttributeException e) {
            log.error("ATTENTION in BoLFeeder! Programming bug when creating GlobalStatusManager! " + e);
            throw new InvalidBoLFeederAttributesException(rsd, this.gu, null);
        }
    }

    @Override
    public void doIt() {
        log.debug("BoLFeeder: pre-processing " + this.rsd.requestToken());
        Collection<BoLPersistentChunkData> chunks = BoLChunkCatalog.getInstance().lookup(this.rsd.requestToken());
        if (chunks.isEmpty()) {
            log.warn("ATTENTION in BoLFeeder! This SRM BoL request contained nothing to process! " + this.rsd.requestToken());
            RequestSummaryCatalog.getInstance().failRequest(this.rsd, "This SRM Get request contained nothing to process!");
        } else {
            this.manageChunks(chunks);
            log.debug("BoLFeeder: finished pre-processing " + this.rsd.requestToken());
        }
    }

    private void manageChunks(Collection<BoLPersistentChunkData> chunks) {
        log.debug("BoLFeeder - number of chunks in request: " + chunks.size());
        for (BoLPersistentChunkData chunkData : chunks) {
            this.gsm.addChunk(chunkData);
            if (TSURL.isValid(chunkData.getSURL())) {
                if (chunkData.getDirOption().isDirectory()) {
                    this.manageIsDirectory(chunkData);
                    continue;
                }
                this.manageNotDirectory(chunkData);
                continue;
            }
            log.warn("BoLFeeder: srmBoL contract violation! fromSURL does not correspond to this machine!\n Request: " + this.rsd.requestToken() + "\n Chunk: " + chunkData);
            chunkData.changeStatusSRM_FAILURE("SRM protocol violation! Cannot do an srmBoL of a SURL that is not local!");
            BoLChunkCatalog.getInstance().update(chunkData);
            this.gsm.failedChunk(chunkData);
        }
        this.gsm.finishedAdding();
    }

    private void manageNotDirectory(BoLPersistentChunkData auxChunkData) {
        log.debug("BoLFeeder - scheduling... ");
        auxChunkData.changeStatusSRM_REQUEST_INPROGRESS("srmBringOnLine chunk is being processed!");
        BoLChunkCatalog.getInstance().update(auxChunkData);
        try {
            SchedulerFacade.getInstance().chunkScheduler().schedule(new BoLPersistentChunk(this.gu, this.rsd, auxChunkData, this.gsm));
            log.debug("BoLFeeder - chunk scheduled.");
        }
        catch (InvalidRequestAttributesException e) {
            log.error("UNEXPECTED ERROR in BoLFeeder! Chunk could not be created!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + auxChunkData);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal error does not allow this chunk to be processed!");
            BoLChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
        catch (SchedulerException e) {
            log.error("UNEXPECTED ERROR in ChunkScheduler! Chunk could not be scheduled!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + auxChunkData);
            auxChunkData.changeStatusSRM_FAILURE("StoRM internal scheduler error prevented this chunk from being processed!");
            BoLChunkCatalog.getInstance().update(auxChunkData);
            this.gsm.failedChunk(auxChunkData);
        }
    }

    private void manageIsDirectory(BoLPersistentChunkData chunkData) {
        log.debug("BoLFeeder - pre-processing Directory chunk...");
        chunkData.changeStatusSRM_REQUEST_INPROGRESS("srmBringOnLine chunk is being processed!");
        BoLChunkCatalog.getInstance().update(chunkData);
        try {
            StoRI stori = null;
            try {
                stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(chunkData.getSURL(), this.gu);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to build StoRI by SURL and user", (Throwable)e);
                chunkData.changeStatusSRM_INTERNAL_ERROR("Unable to build StoRI by SURL and user");
                BoLChunkCatalog.getInstance().update(chunkData);
                log.debug("ATTENTION in BoLFeeder! BoLFeeder received request for a SURL and user not recognised by StoRI!");
                this.gsm.failedChunk(chunkData);
            }
            catch (UnapprochableSurlException e) {
                chunkData.changeStatusSRM_INVALID_PATH("Invalid SURL path specified");
                BoLChunkCatalog.getInstance().update(chunkData);
                log.info("Unable to build a stori for surl " + chunkData.getSURL() + " for user " + DataHelper.getRequestor(chunkData) + " UnapprochableSurlException: " + e.getMessage());
                this.gsm.failedChunk(chunkData);
            }
            if (stori != null) {
                ArrayList<StoRI> storiChildren = stori.getChildren(chunkData.getDirOption());
                log.debug("BoLFeeder - Number of children in parent: " + storiChildren.size());
                TDirOption notDir = new TDirOption(false, false, 0);
                for (StoRI storiChild : storiChildren) {
                    try {
                        BoLPersistentChunkData childData = new BoLPersistentChunkData(chunkData.getRequestToken(), storiChild.getSURL(), chunkData.getLifeTime(), notDir, chunkData.getTransferProtocols(), chunkData.getFileSize(), chunkData.getStatus(), chunkData.getTransferURL(), chunkData.getDeferredStartTime());
                        BoLChunkCatalog.getInstance().addChild(childData);
                        log.debug("BoLFeeder - added child data: " + childData);
                        this.gsm.addChunk(childData);
                        this.manageNotDirectory(childData);
                    }
                    catch (InvalidSurlRequestDataAttributesException e) {
                        log.error("ERROR in BoLFeeder! While expanding recursive request, it was not possible to create a new BoLChunkData! " + e);
                    }
                }
                log.debug("BoLFeeder - expansion completed.");
                chunkData.changeStatusSRM_SUCCESS("srmBringOnLine with dirOption set: request successfully expanded!");
                BoLChunkCatalog.getInstance().update(chunkData);
                this.gsm.successfulChunk(chunkData);
            }
        }
        catch (InvalidTDirOptionAttributesException e) {
            chunkData.changeStatusSRM_FAILURE("srmBringOnLine with dirOption set: expansion failure due to internal error!");
            BoLChunkCatalog.getInstance().update(chunkData);
            log.error("UNEXPECTED ERROR in BoLFeeder! Could not create TDirOption specifying non-expansion!\n" + e);
            log.error("Request: " + this.rsd.requestToken());
            log.error("Chunk: " + chunkData);
            this.gsm.failedChunk(chunkData);
        }
        catch (InvalidDescendantsEmptyRequestException e) {
            chunkData.changeStatusSRM_SUCCESS("BEWARE! srmBringOnLine with dirOption set: it referred to a directory that was empty!");
            BoLChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in BoLFeeder! BoLFeeder received request to expand empty directory.");
            this.gsm.successfulChunk(chunkData);
        }
        catch (InvalidDescendantsPathRequestException e) {
            chunkData.changeStatusSRM_INVALID_PATH("srmBringOnLine with dirOption set: it referred to a non-existent directory!");
            BoLChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in BoLFeeder! BoLFeeder received request to expand non-existing directory.");
            this.gsm.failedChunk(chunkData);
        }
        catch (InvalidDescendantsFileRequestException e) {
            chunkData.changeStatusSRM_INVALID_PATH("srmBringOnLine with dirOption set: a file was asked to be expanded!");
            BoLChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in BoLFeeder! BoLFeeder received request to expand a file.");
            this.gsm.failedChunk(chunkData);
        }
        catch (InvalidDescendantsAuthRequestException e) {
            chunkData.changeStatusSRM_AUTHORIZATION_FAILURE("srmBringOnLine with dirOption set: user has no right to access directory!");
            BoLChunkCatalog.getInstance().update(chunkData);
            log.debug("ATTENTION in BoLFeeder! BoLFeeder received request to expand a directory for which the user has no rights.");
            this.gsm.failedChunk(chunkData);
        }
    }

    @Override
    public String getName() {
        return "BoLFeeder of request: " + this.rsd.requestToken();
    }
}

