/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.InvalidRequestAttributesException;
import it.grid.storm.asynch.Request;
import it.grid.storm.asynch.Suspendedable;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.catalogs.BoLData;
import it.grid.storm.catalogs.RequestData;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.ea.StormEA;
import it.grid.storm.filesystem.FSException;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.scheduler.Chooser;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.Streets;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoL
implements Delegable,
Chooser,
Request,
Suspendedable {
    private static Logger log = LoggerFactory.getLogger(BoL.class);
    protected GridUserInterface gu = null;
    protected BoLData requestData = null;
    protected boolean failure = false;
    private LocalFile bupLocalFile;

    public BoL(GridUserInterface gu, BoLData chunkData) throws InvalidRequestAttributesException {
        if (gu == null || chunkData == null) {
            throw new InvalidRequestAttributesException(gu, chunkData);
        }
        this.gu = gu;
        this.requestData = chunkData;
    }

    @Override
    public void choose(Streets s) {
        s.bolStreet(this);
    }

    @Override
    public Boolean completeRequest(TapeRecallStatus recallStatus) {
        boolean requestSuccessfull;
        block7: {
            requestSuccessfull = false;
            if (recallStatus == TapeRecallStatus.SUCCESS) {
                try {
                    if (this.bupLocalFile.isOnDisk()) {
                        this.requestData.changeStatusSRM_SUCCESS("File recalled from tape");
                        requestSuccessfull = true;
                        break block7;
                    }
                    log.error("File " + this.bupLocalFile.getAbsolutePath() + " not found on the disk, but it was reported to be successfully recalled from tape");
                    this.requestData.changeStatusSRM_FAILURE("Error recalling file from tape");
                }
                catch (FSException e) {
                    log.error("Unable to determine if file " + this.bupLocalFile.getAbsolutePath() + " is on disk . FSException : " + e.getMessage());
                    this.requestData.changeStatusSRM_FAILURE("Internal error: unable to determine if the file is on disk");
                }
            } else if (recallStatus == TapeRecallStatus.ABORTED) {
                this.requestData.changeStatusSRM_ABORTED("Recalling file from tape aborted");
            } else {
                this.requestData.changeStatusSRM_FAILURE("Error recalling file from tape");
            }
        }
        return requestSuccessfull;
    }

    @Override
    public void doIt() {
        log.debug("Handling BoL chunk for user DN: " + this.gu.getDn() + "; for SURL: " + this.requestData.getSURL());
        if (!this.verifySurlStatusTransition(this.requestData.getSURL(), this.requestData.getRequestToken())) {
            this.failure = true;
            this.requestData.changeStatusSRM_FILE_BUSY("Requested file is busy (in an incompatible state with BOL)");
            log.info("Unable to perform the BOL request, surl busy");
            this.printOutcome(this.gu.getDn(), this.requestData.getSURL(), this.requestData.getStatus());
            return;
        }
        StoRI fileStoRI = null;
        try {
            fileStoRI = NamespaceDirector.getNamespace().resolveStoRIbySURL(this.requestData.getSURL(), this.gu);
        }
        catch (IllegalArgumentException e) {
            this.failure = true;
            this.requestData.changeStatusSRM_INTERNAL_ERROR("Unable to get StoRI for surl " + this.requestData.getSURL());
            log.error("Unable to get StoRI for surl " + this.requestData.getSURL() + " IllegalArgumentException: " + e.getMessage());
        }
        catch (UnapprochableSurlException e) {
            this.requestData.changeStatusSRM_INVALID_PATH("Invalid SURL path specified");
            this.failure = true;
            log.info("Unable to build a stori for surl " + this.requestData.getSURL() + " for user " + DataHelper.getRequestor(this.requestData) + " UnapprochableSurlException: " + e.getMessage());
        }
        if (!this.failure) {
            SpaceHelper sp = new SpaceHelper();
            TSpaceToken token = sp.getTokenFromStoRI(log, fileStoRI);
            SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
            if (spaceAuth.authorize(this.gu, SRMSpaceRequest.BOL)) {
                this.manageIsPermit(fileStoRI);
            } else {
                this.failure = true;
                this.requestData.changeStatusSRM_AUTHORIZATION_FAILURE("Space authoritazion denied " + this.requestData.getSURL() + " in Storage Area: " + token);
                log.debug("Read access to " + this.requestData.getSURL() + " in Storage Area: " + token + " denied!");
            }
        }
        this.printOutcome(this.gu.getDn(), this.requestData.getSURL(), this.requestData.getStatus());
    }

    @Override
    public RequestData getRequestData() {
        return this.requestData;
    }

    @Override
    public String getName() {
        return "BoLChunk for SURL " + this.requestData.getSURL();
    }

    @Override
    public String getSURL() {
        return this.requestData.getSURL().toString();
    }

    @Override
    public String getUserDN() {
        return this.gu.getDn();
    }

    @Override
    public boolean isResultSuccess() {
        boolean result = false;
        TStatusCode statusCode = this.requestData.getStatus().getStatusCode();
        if (statusCode.getValue().equals(TStatusCode.SRM_FILE_PINNED.getValue()) || this.requestData.getStatus().isSRM_SUCCESS()) {
            result = true;
        }
        return result;
    }

    private void backupData(LocalFile localFile) {
        this.bupLocalFile = localFile;
    }

    private void manageIsPermit(StoRI fileStoRI) {
        LocalFile localFile = fileStoRI.getLocalFile();
        try {
            if (!localFile.exists() || localFile.isDirectory()) {
                this.requestData.changeStatusSRM_INVALID_PATH("The requested file either does not exist, or it is a directory!");
                this.failure = true;
                log.debug("BoLChunk: the requested file either does not exist, or it is a directory!");
            } else if (fileStoRI.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
                long expDate = System.currentTimeMillis() / 1000L + (this.requestData.getLifeTime().value() + (long)this.requestData.getDeferredStartTime());
                StormEA.setPinned(localFile.getAbsolutePath(), expDate);
                fileStoRI.setGroupTapeRead();
                this.requestData.setFileSize(TSizeInBytes.make(localFile.length(), SizeUnit.BYTES));
                if (this.isStoriOndisk(fileStoRI)) {
                    this.requestData.changeStatusSRM_SUCCESS("srmBringOnLine successfully handled!");
                } else {
                    this.requestData.changeStatusSRM_REQUEST_INPROGRESS("Recalling file from tape");
                    String voName = null;
                    if (this.gu instanceof AbstractGridUser) {
                        voName = ((AbstractGridUser)this.gu).getVO().getValue();
                    }
                    new TapeRecallCatalog().insertTask(this, voName, localFile.getAbsolutePath());
                    this.backupData(localFile);
                }
            } else {
                this.requestData.changeStatusSRM_NOT_SUPPORTED("Tape not supported for this filesystem");
            }
        }
        catch (SecurityException e) {
            this.requestData.changeStatusSRM_FAILURE("StoRM is not allowed to work on requested file!");
            this.failure = true;
            log.error("ATTENTION in BoLChunk! BoLChunk received a SecurityException from Java SecurityManager; StoRM cannot check-existence or check-if-directory for: " + localFile.toString() + "; exception: " + e);
        }
        catch (Exception e) {
            this.requestData.changeStatusSRM_FAILURE("StoRM encountered an unexpected error!");
            this.failure = true;
            log.error("ERROR in BoLChunk! StoRM process got an unexpected error! " + e);
        }
    }

    private boolean isStoriOndisk(StoRI storiFile) throws FSException {
        if (!storiFile.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
            return true;
        }
        return storiFile.getLocalFile().isOnDisk();
    }

    private boolean verifySurlStatusTransition(TSURL surl, TRequestToken requestToken) {
        Map<TRequestToken, TReturnStatus> statuses = SurlStatusManager.getSurlCurrentStatuses(surl);
        statuses.remove(requestToken);
        return TStatusCode.SRM_FILE_PINNED.isCompatibleWith(statuses.values());
    }

    private void printOutcome(String dn, TSURL surl, TReturnStatus status) {
        log.info("Finished handling BoL chunk for user DN: " + dn + "; for SURL: " + surl + "; result is: " + status);
    }
}

