/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.asynch;

import it.grid.storm.asynch.BoLFeeder;
import it.grid.storm.asynch.CopyFeeder;
import it.grid.storm.asynch.InvalidBoLFeederAttributesException;
import it.grid.storm.asynch.InvalidCopyFeederAttributesException;
import it.grid.storm.asynch.InvalidPtGFeederAttributesException;
import it.grid.storm.asynch.InvalidPtPFeederAttributesException;
import it.grid.storm.asynch.PtGFeeder;
import it.grid.storm.asynch.PtPFeeder;
import it.grid.storm.asynch.SchedulerFacade;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.catalogs.RequestSummaryData;
import it.grid.storm.config.Configuration;
import it.grid.storm.scheduler.Scheduler;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.scheduler.SchedulerStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedPicker {
    private static final Logger log = LoggerFactory.getLogger(AdvancedPicker.class);
    private final Scheduler s = SchedulerFacade.getInstance().crusherScheduler();
    private Timer retriever = new Timer();
    private TimerTask retrievingTask = null;
    private final long delay = Configuration.getInstance().getPickingInitialDelay() * 1000L;
    private final long period = Configuration.getInstance().getPickingTimeInterval() * 1000L;
    private boolean abort = false;
    private Collection<TSURL> abortSURLS = null;
    private TRequestToken abortToken = null;

    public void stopIt() {
        log.debug("ADVANCED PICKER: stopped");
        if (this.retriever != null && this.retrievingTask != null) {
            this.retrievingTask.cancel();
            this.retriever.purge();
        }
    }

    public void startIt() {
        log.debug("ADVANCED PICKER: started");
        this.retrievingTask = new TimerTask(){

            @Override
            public void run() {
                AdvancedPicker.this.retrieve();
            }
        };
        this.retriever.scheduleAtFixedRate(this.retrievingTask, this.delay, this.period);
    }

    public void retrieve() {
        int crusherCapacity = -1;
        SchedulerStatus status = this.s.getStatus(0);
        crusherCapacity = status.getRemainingSize();
        Collection<RequestSummaryData> requests = RequestSummaryCatalog.getInstance().fetchNewRequests(crusherCapacity);
        if (requests.isEmpty()) {
            log.trace("ADVANCED PICKER: no request to dispatch.");
        } else {
            log.info("ADVANCED PICKER: dispatching " + requests.size() + " requests.");
        }
        TRequestType rtype = null;
        TRequestToken rt = null;
        for (RequestSummaryData rsd : requests) {
            rtype = rsd.requestType();
            rt = rsd.requestToken();
            if (this.abort && rt.equals(this.abortToken)) {
                if (this.abortSURLS == null) {
                    RequestSummaryCatalog.getInstance().abortInProgressRequest(this.abortToken);
                } else {
                    RequestSummaryCatalog.getInstance().abortChunksOfInProgressRequest(this.abortToken, this.abortSURLS);
                }
                this.abortToken = null;
                this.abortSURLS = null;
                this.abort = false;
                continue;
            }
            try {
                if (rtype == TRequestType.PREPARE_TO_GET) {
                    this.s.schedule(new PtGFeeder(rsd));
                    continue;
                }
                if (rtype == TRequestType.PREPARE_TO_PUT) {
                    this.s.schedule(new PtPFeeder(rsd));
                    continue;
                }
                if (rtype == TRequestType.COPY) {
                    this.s.schedule(new CopyFeeder(rsd));
                    continue;
                }
                if (rtype == TRequestType.BRING_ON_LINE) {
                    this.s.schedule(new BoLFeeder(rsd));
                    continue;
                }
                log.warn("ADVANCED PICKER received request " + rt + " of type " + (Object)((Object)rtype) + " which is NOT currently supported. Dropping request... ");
                log.warn("ADVANCED PICKER: Beware that the global status of request " + rt + " will transit to SRM_FAILURE, but each chunk in the request will remain in SRM_REQUEST_QUEUED!");
                try {
                    RequestSummaryCatalog.getInstance().updateGlobalStatus(rt, new TReturnStatus(TStatusCode.SRM_NOT_SUPPORTED, "Request of type " + (Object)((Object)rtype) + " is currently not supported!"));
                }
                catch (InvalidTReturnStatusAttributeException ex) {
                    log.error("ADVANCED PICKER! Unable to change global status in DB: " + ex);
                }
            }
            catch (InvalidPtGFeederAttributesException e) {
                log.error("ADVANCED PICKER ERROR! PtGFeeder could not be created because of invalid attributes:\n" + e);
                log.error("PtG Request is being dropped: " + rsd.requestToken());
                RequestSummaryCatalog.getInstance().failRequest(rsd, "Internal error does not allow request to be fed to scheduler.");
            }
            catch (InvalidPtPFeederAttributesException e) {
                log.error("ADVANCED PICKER ERROR! PtPFeeder could not be created because of invalid attributes:\n" + e);
                log.error("PtP Request is being dropped: " + rsd.requestToken());
                RequestSummaryCatalog.getInstance().failRequest(rsd, "Internal error does not allow request to be fed to scheduler.");
            }
            catch (InvalidCopyFeederAttributesException e) {
                log.error("ADVANCED PICKER ERROR! CopyFeeder could not be created because of invalid attributes:\n" + e);
                log.error("Copy Request is being dropped: " + rsd.requestToken());
                RequestSummaryCatalog.getInstance().failRequest(rsd, "Internal error does not allow request to be fed to scheduler.");
            }
            catch (InvalidBoLFeederAttributesException e) {
                log.error("ADVANCED PICKER ERROR! BoLFeeder could not be created because of invalid attributes:\n" + e);
                log.error("BoL Request is being dropped: " + rsd.requestToken());
                RequestSummaryCatalog.getInstance().failRequest(rsd, "Internal error does not allow request to be fed to scheduler.");
            }
            catch (SchedulerException e) {
                log.error("ADVANCED PICKER ERROR! The request could not be scheduled because of scheduler errors!\n" + e);
                log.error("ADVANCED PICKER ERROR! Request " + rsd.requestToken() + " of type " + (Object)((Object)rsd.requestType()) + " dropped.");
                RequestSummaryCatalog.getInstance().failRequest(rsd, "Internal scheduler has problems accepting request feed.");
            }
        }
        if (this.abort) {
            this.abortToken = null;
            this.abortSURLS = null;
            this.abort = false;
        }
    }

    public synchronized boolean abortRequest(TRequestToken rt) {
        if (this.abort) {
            return false;
        }
        if (rt == null) {
            return false;
        }
        this.abortToken = rt;
        this.abort = true;
        return true;
    }

    public synchronized boolean abortChunksOfRequest(TRequestToken rt, Collection<TSURL> c) {
        if (this.abort) {
            return false;
        }
        if (rt == null || c == null) {
            return false;
        }
        this.abortToken = rt;
        this.abortSURLS = c;
        this.abort = true;
        return true;
    }
}

